/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.IsJSClassNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.EnumSet;

public final class RegExpPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new RegExpPrototypeBuiltins();

    protected RegExpPrototypeBuiltins() {
        super("RegExp.prototype", RegExpPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpPrototype builtinEnum) {
        switch (builtinEnum) {
            case exec: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return RegExpPrototypeBuiltinsFactory.JSRegExpExecNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case test: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpTestNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toString: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpToStringNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case _match: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _replace: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpReplaceNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case _search: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSearchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _split: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSplitNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case compile: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpCompileNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case _matchAll: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchAllNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createNoRegExpError(Object obj) {
        String objName = String.valueOf(JSRuntime.toPrimitive(obj, "string"));
        return Errors.createTypeError(objName + " is not a RegExp");
    }

    static abstract class CompiledRegexPatternAccessor
    extends JSBuiltinNode {
        private static final String DEFAULT_RETURN = "(?:)";
        @Node.Child
        TRegexUtil.InteropReadStringMemberNode readPatternNode = TRegexUtil.InteropReadStringMemberNode.create();

        CompiledRegexPatternAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSRegExp(obj)"})
        Object doDynamicObject(DynamicObject obj) {
            return JSRegExp.escapeRegExpPattern(this.readPatternNode.execute(JSRegExp.getCompiledRegex(obj), "pattern"));
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(DynamicObject obj) {
            return DEFAULT_RETURN;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(DynamicObject obj) {
            return obj == this.getContext().getRealm().getRegExpPrototype();
        }

        static CompiledRegexPatternAccessor create(JSContext context, JSBuiltin builtin, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexPatternAccessorNodeGen.create(context, builtin, args);
        }
    }

    static abstract class CompiledRegexFlagPropertyAccessor
    extends JSBuiltinNode {
        @Node.Child
        TRegexUtil.TRegexCompiledRegexSingleFlagAccessor readNode;

        CompiledRegexFlagPropertyAccessor(JSContext context, JSBuiltin builtin, String flagName) {
            super(context, builtin);
            this.readNode = TRegexUtil.TRegexCompiledRegexSingleFlagAccessor.create(flagName);
        }

        @Specialization(guards={"isJSRegExp(obj)"})
        Object doDynamicObject(DynamicObject obj) {
            return this.readNode.get(JSRegExp.getCompiledRegex(obj));
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(DynamicObject obj) {
            return Undefined.instance;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(DynamicObject obj) {
            return obj == this.getContext().getRealm().getRegExpPrototype();
        }

        public static CompiledRegexFlagPropertyAccessor create(JSContext context, JSBuiltin builtin, String flagName, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexFlagPropertyAccessorNodeGen.create(context, builtin, flagName, args);
        }
    }

    public static abstract class RegExpFlagsGetterNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getGlobal;
        @Node.Child
        private PropertyGetNode getIgnoreCase;
        @Node.Child
        private PropertyGetNode getMultiline;
        @Node.Child
        private PropertyGetNode getDotAll;
        @Node.Child
        private PropertyGetNode getUnicode;
        @Node.Child
        private PropertyGetNode getSticky;
        @Node.Child
        private JSToBooleanNode toBoolean;

        public RegExpFlagsGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getGlobal = PropertyGetNode.create("global", context);
            this.getIgnoreCase = PropertyGetNode.create("ignoreCase", context);
            this.getMultiline = PropertyGetNode.create("multiline", context);
            if (context.getEcmaScriptVersion() >= 9) {
                this.getDotAll = PropertyGetNode.create("dotAll", context);
            }
            this.getUnicode = PropertyGetNode.create("unicode", context);
            this.getSticky = PropertyGetNode.create("sticky", context);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected String doObject(DynamicObject rx, @Cached(value="create()") IsJSObjectNode isObjectNode) {
            char[] flags = new char[6];
            int len = 0;
            if (this.getFlag(rx, this.getGlobal)) {
                flags[len++] = 103;
            }
            if (this.getFlag(rx, this.getIgnoreCase)) {
                flags[len++] = 105;
            }
            if (this.getFlag(rx, this.getMultiline)) {
                flags[len++] = 109;
            }
            if (this.getDotAll != null && this.getFlag(rx, this.getDotAll)) {
                flags[len++] = 115;
            }
            if (this.getFlag(rx, this.getUnicode)) {
                flags[len++] = 117;
            }
            if (this.getFlag(rx, this.getSticky)) {
                flags[len++] = 121;
            }
            if (len == 0) {
                return "";
            }
            return RegExpFlagsGetterNode.newString(flags, len);
        }

        @Fallback
        protected String doNotObject(Object thisObj) {
            throw Errors.createTypeErrorNotAnObject(thisObj);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newString(char[] flags, int len) {
            return new String(flags, 0, len);
        }

        private boolean getFlag(DynamicObject re, PropertyGetNode getNode) {
            boolean flag;
            if (this.toBoolean == null) {
                try {
                    flag = getNode.getValueBoolean(re);
                }
                catch (UnexpectedResultException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toBoolean = this.insert(JSToBooleanNode.create());
                    flag = this.toBoolean.executeBoolean(e.getResult());
                }
            } else {
                flag = this.toBoolean.executeBoolean(getNode.getValue(re));
            }
            return flag;
        }
    }

    public static final class RegExpPrototypeGetterBuiltins
    extends JSBuiltinsContainer.SwitchEnum<RegExpPrototypeGetters> {
        public static final JSBuiltinsContainer BUILTINS = new RegExpPrototypeGetterBuiltins();

        protected RegExpPrototypeGetterBuiltins() {
            super("RegExp.prototype", RegExpPrototypeGetters.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpPrototypeGetters builtinEnum) {
            switch (builtinEnum) {
                case source: {
                    return CompiledRegexPatternAccessor.create(context, builtin, RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
                }
                case flags: {
                    return RegExpPrototypeBuiltinsFactory.RegExpFlagsGetterNodeGen.create(context, builtin, RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
                }
            }
            return CompiledRegexFlagPropertyAccessor.create(context, builtin, builtinEnum.name(), RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
        }

        public static enum RegExpPrototypeGetters implements BuiltinEnum<RegExpPrototypeGetters>
        {
            flags(0),
            source(0),
            global(0),
            multiline(0),
            ignoreCase(0),
            sticky(0),
            unicode(0),
            dotAll(0);

            private final int length;

            private RegExpPrototypeGetters(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public int getECMAScriptVersion() {
                if (EnumSet.of(sticky, unicode).contains(this)) {
                    return 6;
                }
                if (this.equals(dotAll)) {
                    return 9;
                }
                return BuiltinEnum.super.getECMAScriptVersion();
            }

            @Override
            public boolean isGetter() {
                return true;
            }
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpMatchAllNode
    extends JSBuiltinNode {
        public JSRegExpMatchAllNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(regex)"}, limit="1")
        protected Object matchAll(VirtualFrame frame, DynamicObject regex, Object stringObj, @Cached(value="create()") JSToStringNode toStringNodeForInput, @Cached(value="createSpeciesConstructNode()") ArrayPrototypeBuiltins.ArraySpeciesConstructorNode speciesConstructNode, @Cached(value="create(FLAGS, getContext())") PropertyGetNode getFlagsNode, @Cached(value="create()") JSToStringNode toStringNodeForFlags, @Cached(value="create(LAST_INDEX, getContext())") PropertyGetNode getLastIndexNode, @Cached(value="create()") JSToLengthNode toLengthNode, @Cached(value="create(LAST_INDEX, FALSE, getContext(), TRUE)") PropertySetNode setLastIndexNode, @Cached(value="createCreateRegExpStringIteratorNode()") StringPrototypeBuiltins.CreateRegExpStringIteratorNode createRegExpStringIteratorNode, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="createBinaryProfile()") ConditionProfile indexInIntRangeProf) {
            String string = toStringNodeForInput.executeString(stringObj);
            DynamicObject regExpConstructor = this.getContext().getRealm().getRegExpConstructor();
            DynamicObject constructor = speciesConstructNode.speciesConstructor(regex, regExpConstructor);
            String flags = toStringNodeForFlags.executeString(getFlagsNode.getValue(regex));
            Object matcher = speciesConstructNode.construct(constructor, regex, flags);
            long lastIndex = toLengthNode.executeLong(getLastIndexNode.getValue(regex));
            setLastIndexNode.setValue(matcher, JSRuntime.boxIndex(lastIndex, indexInIntRangeProf));
            boolean global = flags.indexOf(103) != -1;
            boolean fullUnicode = flags.indexOf(117) != -1;
            return createRegExpStringIteratorNode.createIterator(frame, matcher, string, global, fullUnicode);
        }

        ArrayPrototypeBuiltins.ArraySpeciesConstructorNode createSpeciesConstructNode() {
            return ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), false);
        }

        StringPrototypeBuiltins.CreateRegExpStringIteratorNode createCreateRegExpStringIteratorNode() {
            return new StringPrototypeBuiltins.CreateRegExpStringIteratorNode(this.getContext());
        }

        @Fallback
        protected Object matchAll(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@matchAll", thisObj);
        }
    }

    public static abstract class JSRegExpSearchNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private PropertyGetNode getIndexNode;
        @Node.Child
        private JSIdenticalNode sameValueNode;

        protected JSRegExpSearchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIndexNode = PropertyGetNode.create("index", false, context);
            this.sameValueNode = JSIdenticalNode.createSameValue();
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object search(DynamicObject rx, Object param, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toString1Node) {
            String s = toString1Node.executeString(param);
            Object previousLastIndex = this.getLastIndex(rx);
            if (!this.sameValueNode.executeBoolean(previousLastIndex, 0)) {
                this.setLastIndex((Object)rx, 0);
            }
            Object result = this.regexExecIntl(rx, s);
            Object currentLastIndex = this.getLastIndex(rx);
            if (!this.sameValueNode.executeBoolean(currentLastIndex, previousLastIndex)) {
                this.setLastIndex((Object)rx, previousLastIndex);
            }
            return result == Null.instance ? Integer.valueOf(-1) : this.getIndexNode.getValue(result);
        }

        @Fallback
        protected Object search(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@search", thisObj);
        }
    }

    public static abstract class JSRegExpMatchNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private PropertyGetNode getUnicodeNode;
        @Node.Child
        private PropertyGetNode getGlobalNode;
        @Node.Child
        private JSToLengthNode toLengthNode;
        private final ConditionProfile isGlobalProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile unicodeProfile = ConditionProfile.createBinaryProfile();

        protected JSRegExpMatchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getUnicodeNode = PropertyGetNode.create("unicode", false, context);
            this.getGlobalNode = PropertyGetNode.create("global", false, context);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object match(DynamicObject rx, Object param, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toString1Node, @Cached(value="create()") JSToStringNode toString2Node) {
            String s = toString1Node.executeString(param);
            if (this.isGlobalProfile.profile(!this.getFlag(rx, this.getGlobalNode))) {
                return this.regexExecIntl(rx, s);
            }
            boolean fullUnicode = this.getFlag(rx, this.getUnicodeNode);
            this.setLastIndex((Object)rx, 0);
            DynamicObject array = JSArray.createEmptyZeroLength(this.getContext());
            int n = 0;
            DynamicObject result;
            while ((result = (DynamicObject)this.regexExecIntl(rx, s)) != Null.instance) {
                String matchStr = toString2Node.executeString(this.read(result, 0));
                this.write(array, n, matchStr);
                if (matchStr.length() == 0) {
                    int lastI = this.toLength(this.getLastIndex(rx));
                    this.setLastIndex((Object)rx, this.unicodeProfile.profile(fullUnicode) ? this.advanceStringIndexUnicode(s, lastI) : lastI + 1);
                }
                ++n;
            }
            return n == 0 ? Null.instance : array;
        }

        @Fallback
        protected Object match(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@match", thisObj);
        }

        private int toLength(Object obj) {
            if (this.toLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toLengthNode = this.insert(JSToLengthNode.create());
            }
            return (int)this.toLengthNode.executeLong(obj);
        }
    }

    public static abstract class JSRegExpReplaceNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private PropertyGetNode getGlobalNode;
        @Node.Child
        private PropertyGetNode getUnicodeNode;
        @Node.Child
        private PropertyGetNode getLengthNode;
        @Node.Child
        private PropertyGetNode getIndexNode;
        @Node.Child
        private PropertyGetNode getGroupsNode;
        @Node.Child
        private TRegexUtil.TRegexResultAccessor readLazyLengthNode;
        @Node.Child
        private DynamicObjectLibrary lazyRegexResultNode;
        @Node.Child
        private JSToLengthNode toLengthNode;
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private JSToStringNode toString3Node;
        @Node.Child
        private JSToStringNode toString4Node;
        @Node.Child
        private JSFunctionCallNode functionCallNode;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        @Node.Child
        private ReadElementNode readNamedCaptureGroupNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private HasHiddenKeyCacheNode hasLazyRegexResultNode;
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode;
        @Node.Child
        TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor;
        @Node.Child
        private TRegexUtil.TRegexFlagsAccessor flagsAccessor;
        @Node.Child
        TRegexUtil.TRegexResultAccessor resultAccessor;
        @Node.Child
        private TRegexUtil.TRegexNamedCaptureGroupsAccessor namedCaptureGroupsAccessor;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;
        @Node.Child
        private IsJSClassNode isJSRegExpNode;
        private final ConditionProfile unicodeProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile globalProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile stickyProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile functionalReplaceProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile lazyResultArrayProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile noMatchProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile validPositionProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile hasNamedCaptureGroupsProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile dollarProfile = BranchProfile.create();
        final StringBuilderProfile stringBuilderProfile;
        final BranchProfile invalidGroupNumberProfile = BranchProfile.create();
        private final ValueProfile compiledRegexProfile = ValueProfile.createIdentityProfile();
        private final BranchProfile growProfile = BranchProfile.create();

        JSRegExpReplaceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getGlobalNode = PropertyGetNode.create("global", false, context);
            this.getIndexNode = PropertyGetNode.create("index", false, context);
            this.toIntegerNode = JSToIntegerAsIntNode.create();
            this.isObjectNode = IsJSObjectNode.create();
            this.isCallableNode = IsCallableNode.create();
            this.hasLazyRegexResultNode = HasHiddenKeyCacheNode.create(JSArray.LAZY_REGEX_RESULT_ID);
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
            this.lazyRegexResultNode = DynamicObjectLibrary.getFactory().createDispatched(5);
        }

        @Specialization(guards={"cachedReplaceValue.equals(replaceValue)"})
        protected String replaceCached(DynamicObject rx, Object searchString, String replaceValue, @Cached(value="replaceValue") String cachedReplaceValue, @Cached(value="parseReplaceValueWithNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithNamedCG, @Cached(value="parseReplaceValueWithoutNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithoutNamedCG, @Cached(value="create()") JSToStringNode toString1Node) {
            this.checkObject(rx);
            if (this.isPristine(rx)) {
                return this.replaceInternal(rx, toString1Node.executeString(searchString), cachedReplaceValue, cachedParsedReplaceValueWithNamedCG, cachedParsedReplaceValueWithoutNamedCG);
            }
            return this.replaceAccordingToSpec(rx, toString1Node.executeString(searchString), cachedReplaceValue, false);
        }

        @Specialization(replaces={"replaceCached"})
        protected String replaceDynamic(DynamicObject rx, Object searchString, Object replaceValue, @Cached(value="create()") JSToStringNode toString1Node) {
            Object replaceVal;
            this.checkObject(rx);
            boolean functionalReplace = this.functionalReplaceProfile.profile(this.isCallableNode.executeBoolean(replaceValue));
            if (functionalReplace) {
                replaceVal = replaceValue;
            } else {
                String replaceString = this.toString2(replaceValue);
                replaceVal = replaceString;
                if (this.isPristine(rx)) {
                    return this.replaceInternal(rx, toString1Node.executeString(searchString), replaceString, null, null);
                }
            }
            return this.replaceAccordingToSpec(rx, toString1Node.executeString(searchString), replaceVal, functionalReplace);
        }

        @Fallback
        protected String doNoObject(Object rx, Object searchString, Object replaceValue) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", rx);
        }

        private void checkObject(DynamicObject rx) {
            if (!this.isObjectNode.executeBoolean(rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", rx);
            }
        }

        static ReplaceStringParser.Token[] parseReplaceValueWithNCG(String replaceValue) {
            return JSRegExpReplaceNode.parseReplaceValue(replaceValue, true);
        }

        static ReplaceStringParser.Token[] parseReplaceValueWithoutNCG(String replaceValue) {
            return JSRegExpReplaceNode.parseReplaceValue(replaceValue, false);
        }

        static ReplaceStringParser.Token[] parseReplaceValue(String replaceValue, boolean parseNamedCG) {
            return ReplaceStringParser.parse(replaceValue, 100, parseNamedCG);
        }

        private void initTRegexAccessors() {
            if (this.compiledRegexAccessor == null || this.flagsAccessor == null || this.resultAccessor == null || this.execIgnoreLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compiledRegexAccessor = this.insert(TRegexUtil.TRegexCompiledRegexAccessor.create());
                this.flagsAccessor = this.insert(TRegexUtil.TRegexFlagsAccessor.create());
                this.resultAccessor = this.insert(TRegexUtil.TRegexResultAccessor.create());
                this.execIgnoreLastIndexNode = this.insert(JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode.create(this.getContext(), false));
            }
        }

        private String replaceInternal(DynamicObject rx, String s, String replaceString, ReplaceStringParser.Token[] parsedWithNamedCG, ReplaceStringParser.Token[] parsedWithoutNamedCG) {
            this.initTRegexAccessors();
            Object tRegexCompiledRegex = this.compiledRegexProfile.profile(JSRegExp.getCompiledRegex(rx));
            Object tRegexFlags = this.compiledRegexAccessor.flags(tRegexCompiledRegex);
            boolean global = this.globalProfile.profile(this.flagsAccessor.global(tRegexFlags));
            boolean unicode = this.unicodeProfile.profile(this.flagsAccessor.unicode(tRegexFlags));
            boolean sticky = this.stickyProfile.profile(this.flagsAccessor.sticky(tRegexFlags));
            int length = s.length();
            StringBuilder accumulatedResult = this.stringBuilderProfile.newStringBuilder(length + 16);
            int lastMatchEnd = 0;
            int matchStart = -1;
            int lastIndex = sticky ? (int)this.toLength(this.getLastIndex(rx)) : 0;
            Object lastRegexResult = null;
            while (lastIndex <= length) {
                Object tRegexResult = this.execIgnoreLastIndexNode.execute(rx, s, lastIndex);
                if (this.noMatchProfile.profile(!this.resultAccessor.isMatch(tRegexResult))) {
                    if (matchStart >= 0) break;
                    if (global || sticky) {
                        this.setLastIndex((Object)rx, 0);
                    }
                    return s;
                }
                if (!this.getContext().getRegExpStaticResultUnusedAssumption().isValid()) {
                    lastRegexResult = tRegexResult;
                }
                matchStart = this.resultAccessor.captureGroupStart(tRegexResult, 0);
                int matchEnd = this.resultAccessor.captureGroupEnd(tRegexResult, 0);
                assert (matchStart >= 0 && matchStart <= length && matchStart >= lastMatchEnd);
                this.stringBuilderProfile.append(accumulatedResult, s, lastMatchEnd, matchStart);
                boolean namedCG = this.hasNamedCaptureGroupsProfile.profile(!this.getNamedCaptureGroupsAccessor().isNull(this.compiledRegexAccessor.namedCaptureGroups(tRegexCompiledRegex)));
                if (parsedWithNamedCG == null) {
                    ReplaceStringParser.process(replaceString, this.compiledRegexAccessor.groupCount(tRegexCompiledRegex), namedCG, this.dollarProfile, new ReplaceStringConsumerTRegex(accumulatedResult, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex), this);
                } else {
                    ReplaceStringParser.processParsed(namedCG ? parsedWithNamedCG : parsedWithoutNamedCG, new ReplaceStringConsumerTRegex(accumulatedResult, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex), this);
                }
                lastMatchEnd = matchEnd;
                if (!global) break;
                if (matchStart == matchEnd) {
                    lastIndex = unicode ? this.advanceStringIndexUnicode(s, matchEnd) : matchEnd + 1;
                    continue;
                }
                lastIndex = matchEnd;
            }
            if (this.getContext().isOptionRegexpStaticResult() && matchStart >= 0) {
                this.getContext().getRealm().setStaticRegexResult(this.getContext(), tRegexCompiledRegex, s, matchStart, lastRegexResult);
            }
            if (global || sticky) {
                this.setLastIndex((Object)rx, sticky ? lastMatchEnd : 0);
            }
            if (lastMatchEnd < length) {
                this.stringBuilderProfile.append(accumulatedResult, s, lastMatchEnd, length);
            }
            return this.stringBuilderProfile.toString(accumulatedResult);
        }

        private String replaceAccordingToSpec(DynamicObject rx, String s, Object replaceValue, boolean functionalReplace) {
            String replaceString = null;
            DynamicObject replaceFunction = null;
            if (functionalReplace) {
                replaceFunction = (DynamicObject)replaceValue;
            } else {
                replaceString = (String)replaceValue;
            }
            boolean global = this.globalProfile.profile(this.getFlag(rx, this.getGlobalNode));
            boolean fullUnicode = false;
            if (global) {
                fullUnicode = this.unicodeProfile.profile(this.getFlag(rx, this.getGetUnicodeNode()));
                this.setLastIndex((Object)rx, 0);
            }
            SimpleArrayList<DynamicObject> results = null;
            if (functionalReplace) {
                results = new SimpleArrayList<DynamicObject>();
            }
            int length = s.length();
            StringBuilder accumulatedResult = this.stringBuilderProfile.newStringBuilder(length + 16);
            int nextSourcePosition = 0;
            int matchLength = -1;
            while (true) {
                DynamicObject result;
                if (this.noMatchProfile.profile((result = (DynamicObject)this.regexExecIntl(rx, s)) == Null.instance)) {
                    if (matchLength >= 0) break;
                    return s;
                }
                matchLength = this.lazyResultArrayProfile.profile(this.isLazyResultArray(result)) ? this.getLazyLength(result) : this.processNonLazy(result);
                if (functionalReplace) {
                    results.add(result, this.growProfile);
                } else {
                    nextSourcePosition = this.processResult(accumulatedResult, result, s, replaceString, nextSourcePosition, matchLength);
                }
                if (!global) break;
                if (matchLength != 0) continue;
                long lastI = this.toLength(this.getLastIndex(rx));
                long nextIndex = lastI + 1L;
                if (JSRuntime.longIsRepresentableAsInt(nextIndex)) {
                    this.setLastIndex((Object)rx, fullUnicode ? this.advanceStringIndexUnicode(s, (int)lastI) : (int)nextIndex);
                    continue;
                }
                this.setLastIndex((Object)rx, nextIndex);
            }
            if (functionalReplace) {
                for (int i = 0; i < results.size(); ++i) {
                    nextSourcePosition = this.processResultFunctional(accumulatedResult, (DynamicObject)results.get(i), s, replaceFunction, nextSourcePosition);
                }
            }
            if (nextSourcePosition < length) {
                this.stringBuilderProfile.append(accumulatedResult, s, nextSourcePosition, length);
            }
            return this.stringBuilderProfile.toString(accumulatedResult);
        }

        private int processNonLazy(DynamicObject result) {
            int resultLength = (int)this.toLength(this.getLength(result));
            String result0Str = this.toString3(this.read(result, 0));
            this.write(result, 0, result0Str);
            for (int n = 1; n < resultLength; ++n) {
                Object value = this.read(result, n);
                if (value == Undefined.instance) continue;
                this.write(result, n, this.toString3(value));
            }
            return result0Str.length();
        }

        private boolean isLazyResultArray(DynamicObject result) {
            boolean isLazyResultArray = this.hasLazyRegexResultNode.executeHasHiddenKey(result);
            assert (isLazyResultArray == JSDynamicObject.hasProperty(result, JSArray.LAZY_REGEX_RESULT_ID));
            return isLazyResultArray;
        }

        private int processResult(StringBuilder accumulatedResult, DynamicObject result, String s, String replaceString, int nextSourcePosition, int matchLength) {
            int position = Math.max(Math.min(this.toIntegerNode.executeInt(this.getIndexNode.getValue(result)), s.length()), 0);
            if (this.validPositionProfile.profile(position >= nextSourcePosition)) {
                this.stringBuilderProfile.append(accumulatedResult, s, nextSourcePosition, position);
                Object namedCaptures = this.getGroups(result);
                if (namedCaptures != Undefined.instance) {
                    namedCaptures = this.toObject(namedCaptures);
                }
                ReplaceStringParser.process(replaceString, (int)this.toLength(this.getLength(result)), namedCaptures != Undefined.instance, this.dollarProfile, new ReplaceStringConsumer(accumulatedResult, s, replaceString, position, position + matchLength, result, (DynamicObject)namedCaptures), this);
                return position + matchLength;
            }
            return nextSourcePosition;
        }

        private int processResultFunctional(StringBuilder accumulatedResult, DynamicObject result, String s, DynamicObject replaceFunction, int nextSourcePosition) {
            int position = Math.max(Math.min(this.toIntegerNode.executeInt(this.getIndexNode.getValue(result)), s.length()), 0);
            int resultsLength = (int)this.toLength(this.getLength(result));
            Object namedCaptures = this.getGroups(result);
            Object[] arguments = new Object[resultsLength + 4 + (namedCaptures != Undefined.instance ? 1 : 0)];
            arguments[0] = Undefined.instance;
            arguments[1] = replaceFunction;
            for (int i = 0; i < resultsLength; ++i) {
                arguments[i + 2] = this.read(result, i);
            }
            arguments[resultsLength + 2] = position;
            arguments[resultsLength + 3] = s;
            if (namedCaptures != Undefined.instance) {
                arguments[resultsLength + 4] = namedCaptures;
            }
            Object callResult = this.callFunction(arguments);
            String replacement = this.toString2(callResult);
            if (this.validPositionProfile.profile(position >= nextSourcePosition)) {
                this.stringBuilderProfile.append(accumulatedResult, s, nextSourcePosition, position);
                this.stringBuilderProfile.append(accumulatedResult, replacement);
                if (this.lazyResultArrayProfile.profile(this.isLazyResultArray(result))) {
                    return position + this.getLazyLength(result);
                }
                return position + ((String)this.read(result, 0)).length();
            }
            return nextSourcePosition;
        }

        private Object callFunction(Object[] arguments) {
            if (this.functionCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.functionCallNode = this.insert(JSFunctionCallNode.create(false));
            }
            return this.functionCallNode.executeCall(arguments);
        }

        private String toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private String toString3(Object obj) {
            if (this.toString3Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString3Node = this.insert(JSToStringNode.create());
            }
            return this.toString3Node.executeString(obj);
        }

        final String toString4(Object obj) {
            if (this.toString4Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString4Node = this.insert(JSToStringNode.create());
            }
            return this.toString4Node.executeString(obj);
        }

        private int getLazyLength(DynamicObject obj) {
            if (this.readLazyLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readLazyLengthNode = this.insert(TRegexUtil.TRegexResultAccessor.create());
            }
            return this.readLazyLengthNode.captureGroupLength(JSAbstractArray.arrayGetRegexResult(obj, this.lazyRegexResultNode), 0);
        }

        private PropertyGetNode getGetUnicodeNode() {
            if (this.getUnicodeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getUnicodeNode = this.insert(PropertyGetNode.create("unicode", false, this.getContext()));
            }
            return this.getUnicodeNode;
        }

        private boolean isPristine(DynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        private Object getLength(Object obj) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(PropertyGetNode.create("length", false, this.getContext()));
            }
            return this.getLengthNode.getValue(obj);
        }

        private long toLength(Object value) {
            if (this.toLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toLengthNode = this.insert(JSToLengthNode.create());
            }
            return this.toLengthNode.executeLong(value);
        }

        private Object getGroups(Object regexResult) {
            if (this.getGroupsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getGroupsNode = this.insert(PropertyGetNode.create("groups", false, this.getContext()));
            }
            return this.getGroupsNode.getValue(regexResult);
        }

        final Object readNamedCaptureGroup(Object namedCaptureGroups, String groupName) {
            if (this.readNamedCaptureGroupNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNamedCaptureGroupNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNamedCaptureGroupNode.executeWithTargetAndIndex(namedCaptureGroups, groupName);
        }

        private Object toObject(Object obj) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.createToObject(this.getContext()));
            }
            return this.toObjectNode.execute(obj);
        }

        final TRegexUtil.TRegexNamedCaptureGroupsAccessor getNamedCaptureGroupsAccessor() {
            if (this.namedCaptureGroupsAccessor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.namedCaptureGroupsAccessor = this.insert(TRegexUtil.TRegexNamedCaptureGroupsAccessor.create());
            }
            return this.namedCaptureGroupsAccessor;
        }

        private static final class ReplaceStringConsumer
        implements ReplaceStringParser.Consumer<JSRegExpReplaceNode> {
            private final StringBuilder sb;
            private final String input;
            private final String replaceStr;
            private final int startPos;
            private final int endPos;
            private final DynamicObject result;
            private final DynamicObject namedCaptures;

            private ReplaceStringConsumer(StringBuilder sb, String input, String replaceStr, int startPos, int endPos, DynamicObject result, DynamicObject namedCaptures) {
                this.sb = sb;
                this.input = input;
                this.replaceStr = replaceStr;
                this.startPos = startPos;
                this.endPos = endPos;
                this.result = result;
                this.namedCaptures = namedCaptures;
            }

            @Override
            public void literal(JSRegExpReplaceNode node, int start, int end) {
                node.stringBuilderProfile.append(this.sb, this.replaceStr, start, end);
            }

            @Override
            public void match(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, (String)node.read(this.result, 0));
            }

            @Override
            public void matchHead(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, this.input, 0, this.startPos);
            }

            @Override
            public void matchTail(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, this.input, this.endPos, this.input.length());
            }

            @Override
            public void captureGroup(JSRegExpReplaceNode node, int groupNumber, int literalStart, int literalEnd) {
                Object capture = node.read(this.result, groupNumber);
                if (capture != Undefined.instance) {
                    node.stringBuilderProfile.append(this.sb, (String)capture);
                }
            }

            @Override
            public void namedCaptureGroup(JSRegExpReplaceNode node, String groupName) {
                Object namedCapture = node.readNamedCaptureGroup(this.namedCaptures, groupName);
                if (namedCapture != Undefined.instance) {
                    node.stringBuilderProfile.append(this.sb, node.toString4(namedCapture));
                }
            }
        }

        private static final class ReplaceStringConsumerTRegex
        implements ReplaceStringParser.Consumer<JSRegExpReplaceNode> {
            private final StringBuilder sb;
            private final String input;
            private final String replaceStr;
            private final int startPos;
            private final int endPos;
            private final Object tRegexResult;
            private final Object tRegexCompiledRegex;

            private ReplaceStringConsumerTRegex(StringBuilder sb, String input, String replaceStr, int startPos, int endPos, Object tRegexResult, Object tRegexCompiledRegex) {
                this.sb = sb;
                this.input = input;
                this.replaceStr = replaceStr;
                this.startPos = startPos;
                this.endPos = endPos;
                this.tRegexResult = tRegexResult;
                this.tRegexCompiledRegex = tRegexCompiledRegex;
            }

            @Override
            public void literal(JSRegExpReplaceNode node, int start, int end) {
                node.stringBuilderProfile.append(this.sb, this.replaceStr, start, end);
            }

            @Override
            public void match(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, this.input, this.startPos, this.endPos);
            }

            @Override
            public void matchHead(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, this.input, 0, this.startPos);
            }

            @Override
            public void matchTail(JSRegExpReplaceNode node) {
                node.stringBuilderProfile.append(this.sb, this.input, this.endPos, this.input.length());
            }

            @Override
            public void captureGroup(JSRegExpReplaceNode node, int groupNumber, int literalStart, int literalEnd) {
                TRegexUtil.TRegexResultAccessor resultAccessor = node.resultAccessor;
                StringBuilderProfile stringBuilderProfile = node.stringBuilderProfile;
                int groupCount = node.compiledRegexAccessor.groupCount(this.tRegexCompiledRegex);
                if (groupNumber < groupCount) {
                    int start = resultAccessor.captureGroupStart(this.tRegexResult, groupNumber);
                    if (start >= 0) {
                        stringBuilderProfile.append(this.sb, this.input, start, resultAccessor.captureGroupEnd(this.tRegexResult, groupNumber));
                    }
                } else if (groupNumber > 9 && groupNumber / 10 < groupCount) {
                    int start = resultAccessor.captureGroupStart(this.tRegexResult, groupNumber / 10);
                    if (start >= 0) {
                        stringBuilderProfile.append(this.sb, this.input, start, resultAccessor.captureGroupEnd(this.tRegexResult, groupNumber / 10));
                    }
                    stringBuilderProfile.append(this.sb, this.replaceStr, literalStart + 2, literalEnd);
                } else {
                    node.invalidGroupNumberProfile.enter();
                    stringBuilderProfile.append(this.sb, this.replaceStr, literalStart, literalEnd);
                }
            }

            @Override
            public void namedCaptureGroup(JSRegExpReplaceNode node, String groupName) {
                int groupNumber;
                int start;
                Object map = node.compiledRegexAccessor.namedCaptureGroups(this.tRegexCompiledRegex);
                if (node.getNamedCaptureGroupsAccessor().hasGroup(map, groupName) && (start = node.resultAccessor.captureGroupStart(this.tRegexResult, groupNumber = node.getNamedCaptureGroupsAccessor().getGroupNumber(map, groupName))) >= 0) {
                    node.stringBuilderProfile.append(this.sb, this.input, start, node.resultAccessor.captureGroupEnd(this.tRegexResult, groupNumber));
                }
            }
        }
    }

    @ImportStatic(value={JSGuards.class})
    public static abstract class JSRegExpSplitNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private JSToStringNode toString1Node;
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private PropertyGetNode getFlagsNode;
        @Node.Child
        private PropertyGetNode getLengthNode;
        @Node.Child
        private JSToUInt32Node toUInt32Node;
        @Node.Child
        private JSToLengthNode toLengthNode;
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor;
        @Node.Child
        private TRegexUtil.TRegexFlagsAccessor flagsAccessor;
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;
        @Node.Child
        private IsJSClassNode isJSRegExpNode;
        private final ConditionProfile sizeZeroProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile sameMatchEnd = ConditionProfile.createBinaryProfile();
        private final ConditionProfile resultIsNull = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isUnicode = ConditionProfile.createBinaryProfile();
        private final ConditionProfile limitProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile prematureReturnBranch = BranchProfile.create();
        private final ConditionProfile emptyFlags = ConditionProfile.createBinaryProfile();
        private final ConditionProfile stickyFlagSet = ConditionProfile.createBinaryProfile();
        private final ValueProfile compiledRegexProfile = ValueProfile.createIdentityProfile();

        JSRegExpSplitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        DynamicObject splitIntLimit(DynamicObject rx, Object input, int limit) {
            return this.doSplit(rx, input, this.toUInt32(limit));
        }

        @Specialization
        DynamicObject splitLongLimit(DynamicObject rx, Object input, long limit) {
            return this.doSplit(rx, input, this.toUInt32(limit));
        }

        @Specialization(guards={"isUndefined(limit)"})
        DynamicObject splitUndefinedLimit(DynamicObject rx, Object input, Object limit) {
            return this.doSplit(rx, input, JSRuntime.MAX_SAFE_INTEGER_LONG);
        }

        @Specialization(guards={"!isUndefined(limit)"})
        DynamicObject splitObjectLimit(DynamicObject rx, Object input, Object limit) {
            this.checkObject(rx);
            String str = this.toString1(input);
            DynamicObject constructor = this.getSpeciesConstructor(rx);
            return this.splitAccordingToSpec(rx, str, limit, constructor);
        }

        @Fallback
        Object doNoObject(Object rx, Object input, Object flags) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", rx);
        }

        private DynamicObject doSplit(DynamicObject rx, Object input, long limit) {
            this.checkObject(rx);
            String str = this.toString1(input);
            if (limit == 0L) {
                this.prematureReturnBranch.enter();
                return JSArray.createEmptyZeroLength(this.getContext());
            }
            DynamicObject constructor = this.getSpeciesConstructor(rx);
            if (constructor == this.getContext().getRealm().getRegExpConstructor() && this.isPristine(rx)) {
                return this.splitInternal(rx, str, limit);
            }
            return this.splitAccordingToSpec(rx, str, limit, constructor);
        }

        private void checkObject(DynamicObject rx) {
            if (!this.isJSObject(rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", rx);
            }
        }

        private DynamicObject getSpeciesConstructor(DynamicObject rx) {
            DynamicObject regexpConstructor = this.getContext().getRealm().getRegExpConstructor();
            return this.getArraySpeciesConstructorNode().speciesConstructor(rx, regexpConstructor);
        }

        private DynamicObject splitAccordingToSpec(DynamicObject rx, String str, Object limit, DynamicObject constructor) {
            long lim;
            String flags = this.toString2(this.getFlags(rx));
            boolean unicodeMatching = flags.indexOf(117) >= 0;
            DynamicObject splitter = (DynamicObject)this.getArraySpeciesConstructorNode().construct(constructor, rx, this.ensureSticky(flags));
            DynamicObject array = JSArray.createEmptyZeroLength(this.getContext());
            if (this.limitProfile.profile(limit == Undefined.instance)) {
                lim = JSRuntime.MAX_SAFE_INTEGER_LONG;
            } else {
                lim = this.toUInt32(limit);
                if (lim == 0L) {
                    this.prematureReturnBranch.enter();
                    return array;
                }
            }
            int size = str.length();
            if (this.sizeZeroProfile.profile(size == 0)) {
                if (this.regexExecIntl(splitter, str) == Null.instance) {
                    this.write(array, 0, str);
                }
                return array;
            }
            int arrayLength = 0;
            int prevMatchEnd = 0;
            int fromIndex = 0;
            while (fromIndex < size) {
                this.setLastIndex((Object)splitter, fromIndex);
                DynamicObject regexResult = (DynamicObject)this.regexExecIntl(splitter, str);
                if (this.resultIsNull.profile(regexResult == Null.instance)) {
                    fromIndex = this.movePosition(str, unicodeMatching, fromIndex);
                    continue;
                }
                int matchEnd = (int)this.toLength(this.getLastIndex(splitter));
                if (this.sameMatchEnd.profile(matchEnd == prevMatchEnd)) {
                    fromIndex = this.movePosition(str, unicodeMatching, fromIndex);
                    continue;
                }
                this.write(array, arrayLength, Boundaries.substring(str, prevMatchEnd, fromIndex));
                if ((long)(++arrayLength) == lim) {
                    this.prematureReturnBranch.enter();
                    return array;
                }
                prevMatchEnd = matchEnd;
                fromIndex = matchEnd;
                long numberOfCaptures = this.toLength(this.getLength(regexResult));
                int i = 1;
                while ((long)i < numberOfCaptures) {
                    this.write(array, arrayLength, this.read(regexResult, i));
                    if ((long)(++arrayLength) == lim) {
                        this.prematureReturnBranch.enter();
                        return array;
                    }
                    ++i;
                }
            }
            this.write(array, arrayLength, Boundaries.substring(str, Math.min(prevMatchEnd, str.length()), size));
            return array;
        }

        private DynamicObject splitInternal(DynamicObject rx, String str, long lim) {
            DynamicObject splitter;
            this.initTRegexAccessors();
            Object tRegexCompiledRegex = this.compiledRegexProfile.profile(JSRegExp.getCompiledRegex(rx));
            Object tRegexFlags = this.compiledRegexAccessor.flags(tRegexCompiledRegex);
            boolean unicodeMatching = this.flagsAccessor.unicode(tRegexFlags);
            if (this.stickyFlagSet.profile(this.flagsAccessor.sticky(tRegexFlags))) {
                DynamicObject regexpConstructor = this.getContext().getRealm().getRegExpConstructor();
                splitter = (DynamicObject)this.getArraySpeciesConstructorNode().construct(regexpConstructor, rx, this.removeStickyFlag(tRegexFlags));
            } else {
                splitter = rx;
            }
            DynamicObject array = JSArray.createEmptyZeroLength(this.getContext());
            int size = str.length();
            int arrayLength = 0;
            int prevMatchEnd = 0;
            int fromIndex = 0;
            int matchStart = -1;
            int matchEnd = -1;
            Object lastRegexResult = null;
            do {
                Object tRegexResult;
                if (this.resultIsNull.profile(!this.resultAccessor.isMatch(tRegexResult = this.execIgnoreLastIndexNode.execute(splitter, str, fromIndex)))) {
                    if (!this.sizeZeroProfile.profile(size == 0) && matchStart >= 0) break;
                    this.write(array, 0, str);
                    return array;
                }
                if (!this.getContext().getRegExpStaticResultUnusedAssumption().isValid()) {
                    lastRegexResult = tRegexResult;
                }
                matchStart = this.resultAccessor.captureGroupStart(tRegexResult, 0);
                matchEnd = this.resultAccessor.captureGroupEnd(tRegexResult, 0);
                if (matchEnd == prevMatchEnd) {
                    fromIndex = this.movePosition(str, unicodeMatching, fromIndex);
                    continue;
                }
                this.write(array, arrayLength++, Boundaries.substring(str, prevMatchEnd, matchStart));
                if ((long)arrayLength == lim) {
                    this.prematureReturnBranch.enter();
                    return array;
                }
                prevMatchEnd = matchEnd;
                long numberOfCaptures = this.compiledRegexAccessor.groupCount(tRegexCompiledRegex);
                int i = 1;
                while ((long)i < numberOfCaptures) {
                    this.write(array, arrayLength, TRegexUtil.TRegexMaterializeResultNode.materializeGroup(this.resultAccessor, tRegexResult, i, str));
                    if ((long)(++arrayLength) == lim) {
                        this.prematureReturnBranch.enter();
                        return array;
                    }
                    ++i;
                }
                fromIndex = matchStart == matchEnd ? this.movePosition(str, unicodeMatching, fromIndex) : matchEnd;
            } while (fromIndex < size);
            if (this.getContext().isOptionRegexpStaticResult() && matchStart >= 0) {
                this.getContext().getRealm().setStaticRegexResult(this.getContext(), tRegexCompiledRegex, str, matchStart, lastRegexResult);
            }
            if (matchStart != matchEnd || prevMatchEnd < size) {
                this.write(array, arrayLength, Boundaries.substring(str, prevMatchEnd, size));
            }
            return array;
        }

        private String removeStickyFlag(Object tRegexFlags) {
            char[] flags = new char[5];
            int len = 0;
            if (this.flagsAccessor.global(tRegexFlags)) {
                flags[len++] = 103;
            }
            if (this.flagsAccessor.ignoreCase(tRegexFlags)) {
                flags[len++] = 105;
            }
            if (this.flagsAccessor.multiline(tRegexFlags)) {
                flags[len++] = 109;
            }
            if (this.flagsAccessor.dotAll(tRegexFlags)) {
                flags[len++] = 115;
            }
            if (this.flagsAccessor.unicode(tRegexFlags)) {
                flags[len++] = 117;
            }
            if (len == 0) {
                return "";
            }
            return JSRegExpSplitNode.newString(flags, len);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newString(char[] flags, int len) {
            return new String(flags, 0, len);
        }

        private Object ensureSticky(String flags) {
            if (this.emptyFlags.profile(flags.length() == 0)) {
                return "y";
            }
            if (this.stickyFlagSet.profile(flags.indexOf(121) >= 0)) {
                return flags;
            }
            return JSRegExpSplitNode.addStickyFlag(flags);
        }

        private void initTRegexAccessors() {
            if (this.compiledRegexAccessor == null || this.flagsAccessor == null || this.resultAccessor == null || this.execIgnoreLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compiledRegexAccessor = this.insert(TRegexUtil.TRegexCompiledRegexAccessor.create());
                this.flagsAccessor = this.insert(TRegexUtil.TRegexFlagsAccessor.create());
                this.resultAccessor = this.insert(TRegexUtil.TRegexResultAccessor.create());
                this.execIgnoreLastIndexNode = this.insert(JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode.create(this.getContext(), false));
            }
        }

        private boolean isJSObject(DynamicObject rx) {
            if (this.isObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isObjectNode = this.insert(IsJSObjectNode.create());
            }
            return this.isObjectNode.executeBoolean(rx);
        }

        private String toString1(Object obj) {
            if (this.toString1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString1Node = this.insert(JSToStringNode.create());
            }
            return this.toString1Node.executeString(obj);
        }

        private String toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private Object getFlags(DynamicObject rx) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = this.insert(PropertyGetNode.create("flags", false, this.getContext()));
            }
            return this.getFlagsNode.getValue(rx);
        }

        private boolean isPristine(DynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        private long toLength(Object obj) {
            if (this.toLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toLengthNode = this.insert(JSToLengthNode.create());
            }
            return this.toLengthNode.executeLong(obj);
        }

        private Object getLength(DynamicObject obj) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(PropertyGetNode.create("length", false, this.getContext()));
            }
            return this.getLengthNode.getValue(obj);
        }

        private int movePosition(String s, boolean unicodeMatching, int lastIndex) {
            return this.isUnicode.profile(unicodeMatching) ? this.advanceStringIndexUnicode(s, lastIndex) : lastIndex + 1;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String addStickyFlag(String flags) {
            return flags + "y";
        }

        private long toUInt32(Object obj) {
            if (this.toUInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt32Node = this.insert(JSToUInt32Node.create());
            }
            return this.toUInt32Node.executeLong(obj);
        }
    }

    public static abstract class RegExpPrototypeSymbolOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode regexExecIntlNode;
        @Node.Child
        private PropertyGetNode getLastIndexNode;
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private ReadElementNode readNode;
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;
        @Node.Child
        private JSToBooleanNode toBooleanNode;
        private final ConditionProfile advanceIndexLengthProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile advanceIndexFirstProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile advanceIndexSecondProfile = ConditionProfile.createBinaryProfile();

        public RegExpPrototypeSymbolOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object read(Object target, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNode.executeWithTargetAndIndex(target, index);
        }

        protected void write(Object target, int index, Object value) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = this.insert(WriteElementNode.create(this.getContext(), true, true));
            }
            this.writeNode.executeWithTargetAndIndexAndValue(target, index, value);
        }

        protected final ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), false));
            }
            return this.arraySpeciesCreateNode;
        }

        protected int advanceStringIndexUnicode(String s, int index) {
            if (this.advanceIndexLengthProfile.profile(index + 1 >= s.length())) {
                return index + 1;
            }
            char first = s.charAt(index);
            if (this.advanceIndexFirstProfile.profile(first < '\ud800' || first > '\udbff')) {
                return index + 1;
            }
            char second = s.charAt(index + 1);
            if (this.advanceIndexSecondProfile.profile(second < '\udc00' || second > '\udfff')) {
                return index + 1;
            }
            return index + 2;
        }

        private void initLastIndexNode() {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = this.insert(PropertySetNode.create("lastIndex", false, this.getContext(), true));
            }
        }

        protected void setLastIndex(Object obj, int value) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValueInt(obj, value);
        }

        protected void setLastIndex(Object obj, Object value) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValue(obj, value);
        }

        protected Object getLastIndex(Object obj) {
            if (this.getLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLastIndexNode = this.insert(PropertyGetNode.create("lastIndex", false, this.getContext()));
            }
            return this.getLastIndexNode.getValue(obj);
        }

        protected Object regexExecIntl(DynamicObject regex, String input) {
            if (this.regexExecIntlNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regexExecIntlNode = this.insert(JSRegExpExecIntlNode.create(this.getContext()));
            }
            return this.regexExecIntlNode.execute(regex, input);
        }

        protected final boolean getFlag(DynamicObject re, PropertyGetNode getNode) {
            boolean flag;
            if (this.toBooleanNode == null) {
                try {
                    flag = getNode.getValueBoolean(re);
                }
                catch (UnexpectedResultException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toBooleanNode = this.insert(JSToBooleanNode.create());
                    flag = this.toBooleanNode.executeBoolean(e.getResult());
                }
            } else {
                flag = this.toBooleanNode.executeBoolean(getNode.getValue(re));
            }
            return flag;
        }
    }

    public static abstract class JSRegExpToStringNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getSourceNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        protected JSRegExpToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getFlagsNode = PropertyGetNode.create("flags", false, context);
            this.getSourceNode = PropertyGetNode.create("source", false, context);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected String toString(DynamicObject thisObj, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toString1Node, @Cached(value="create()") JSToStringNode toString2Node) {
            String source = toString1Node.executeString(this.getSourceNode.getValue(thisObj));
            String flags = toString2Node.executeString(this.getFlagsNode.getValue(thisObj));
            return JSRegExpToStringNode.toStringIntl(source, flags);
        }

        @Fallback
        protected Object toString(Object thisNonObj) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.toString", thisNonObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStringIntl(String source, String flags) {
            return "/" + source + "/" + flags;
        }
    }

    public static abstract class JSRegExpTestNode
    extends JSBuiltinNode {
        @Node.Child
        private TRegexUtil.InteropReadBooleanMemberNode readIsMatch;

        protected JSRegExpTestNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected Object testGeneric(DynamicObject thisObj, Object input, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") JSRegExpExecIntlNode regExpNode) {
            String inputStr = toStringNode.executeString(input);
            Object result = regExpNode.execute(thisObj, inputStr);
            if (this.getContext().getEcmaScriptVersion() >= 6) {
                return result != Null.instance;
            }
            return this.getReadIsMatch().execute(result, "isMatch");
        }

        @Fallback
        protected Object testError(Object thisNonObj, Object input) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.test", thisNonObj);
        }

        private TRegexUtil.InteropReadBooleanMemberNode getReadIsMatch() {
            if (this.readIsMatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readIsMatch = this.insert(TRegexUtil.InteropReadBooleanMemberNode.create());
            }
            return this.readIsMatch;
        }
    }

    public static abstract class JSRegExpExecES5Node
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode;
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode;
        @Node.Child
        private PropertySetNode setIndexNode;
        @Node.Child
        private PropertySetNode setInputNode;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexResultAccessor resultAccessor = TRegexUtil.TRegexResultAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexMaterializeResultNode resultMaterializer = TRegexUtil.TRegexMaterializeResultNode.create();
        private final ConditionProfile match = ConditionProfile.createCountingProfile();

        protected JSRegExpExecES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
            this.regExpNode = JSRegExpExecIntlNode.JSRegExpExecBuiltinNode.create(context);
            this.toStringNode = JSToStringNode.create();
        }

        @Specialization(guards={"isJSRegExp(thisRegExp)"})
        protected DynamicObject exec(DynamicObject thisRegExp, Object input) {
            String inputStr = this.toStringNode.executeString(input);
            Object result = this.regExpNode.execute(thisRegExp, inputStr);
            if (this.match.profile(this.resultAccessor.isMatch(result))) {
                return this.getMatchResult(result, this.compiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(thisRegExp)), inputStr);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isJSRegExp(thisObj)"})
        protected Object exec(Object thisObj, Object input) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }

        protected DynamicObject getMatchResult(Object result, int groupCount, String inputStr) {
            assert (this.getContext().getEcmaScriptVersion() < 6);
            if (this.setIndexNode == null || this.setInputNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setIndexNode = this.insert(PropertySetNode.create("index", false, this.getContext(), false));
                this.setInputNode = this.insert(PropertySetNode.create("input", false, this.getContext(), false));
            }
            Object[] matches = this.resultMaterializer.materializeFull(result, groupCount, inputStr);
            DynamicObject array = JSArray.createConstant(this.getContext(), matches);
            this.setIndexNode.setValueInt(array, this.resultAccessor.captureGroupStart(result, 0));
            this.setInputNode.setValue(array, inputStr);
            return array;
        }
    }

    public static abstract class JSRegExpExecNode
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode;

        JSRegExpExecNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() >= 6);
            this.regExpNode = JSRegExpExecIntlNode.JSRegExpExecBuiltinNode.create(context);
        }

        @Specialization(guards={"isJSRegExp(thisRegExp)"})
        DynamicObject doString(DynamicObject thisRegExp, String inputStr) {
            return (DynamicObject)this.regExpNode.execute(thisRegExp, inputStr);
        }

        @Specialization(guards={"isJSRegExp(thisRegExp)"})
        DynamicObject doObject(DynamicObject thisRegExp, Object input, @Cached(value="create()") JSToStringNode toStringNode) {
            return (DynamicObject)this.regExpNode.execute(thisRegExp, toStringNode.executeString(input));
        }

        @Fallback
        Object doNoRegExp(Object thisObj, Object input) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }
    }

    public static abstract class JSRegExpCompileNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertySetNode setLastIndexNode;

        protected JSRegExpCompileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setLastIndexNode = PropertySetNode.create("lastIndex", false, context, true);
        }

        @Specialization(guards={"isJSRegExp(thisRegExp)"})
        protected DynamicObject compile(DynamicObject thisRegExp, Object patternObj, Object flagsObj, @Cached(value="create(getContext())") CompileRegexNode compileRegexNode, @Cached(value="createUndefinedToEmpty()") JSToStringNode toStringNode, @Cached(value="createBinaryProfile()") ConditionProfile isRegExpProfile, @Cached(value="create()") TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor, @Cached(value="create()") TRegexUtil.TRegexFlagsAccessor flagsAccessor) {
            String flags;
            String pattern;
            Object regex;
            if (this.getContext().getRealm() != JSRegExp.getRealm(thisRegExp)) {
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on a RegExp from a different Realm.");
            }
            if (!JSRegExp.getLegacyFeaturesEnabled(thisRegExp)) {
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on subclasses of RegExp.");
            }
            boolean isRegExp = isRegExpProfile.profile(JSRegExp.isJSRegExp(patternObj));
            if (isRegExp) {
                if (flagsObj != Undefined.instance) {
                    throw Errors.createTypeError("flags must be undefined", (Node)this);
                }
                regex = JSRegExp.getCompiledRegex((DynamicObject)patternObj);
                pattern = compiledRegexAccessor.pattern(regex);
                flags = flagsAccessor.source(compiledRegexAccessor.flags(regex));
            } else {
                pattern = toStringNode.executeString(patternObj);
                flags = toStringNode.executeString(flagsObj);
            }
            regex = compileRegexNode.compile(pattern, flags);
            JSRegExp.updateCompilation(this.getContext(), thisRegExp, regex);
            this.setLastIndexNode.setValueInt(thisRegExp, 0);
            return thisRegExp;
        }

        @Specialization(guards={"!isJSRegExp(thisObj)"})
        protected Object compile(Object thisObj, Object pattern, Object flags) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }
    }

    public static enum RegExpPrototype implements BuiltinEnum<RegExpPrototype>
    {
        exec(1),
        test(1),
        toString(0),
        _match(1, Symbol.SYMBOL_MATCH),
        _replace(2, Symbol.SYMBOL_REPLACE),
        _search(1, Symbol.SYMBOL_SEARCH),
        _split(2, Symbol.SYMBOL_SPLIT),
        compile(2),
        _matchAll(1, Symbol.SYMBOL_MATCH_ALL);

        private final int length;
        private final Object key;

        private RegExpPrototype(int length) {
            this(length, null);
        }

        private RegExpPrototype(int length, Symbol symbol) {
            this.length = length;
            this.key = symbol;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return this == compile;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(_match, _replace, _search, _split).contains(this)) {
                return 6;
            }
            if (this.equals(_matchAll)) {
                return 10;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }

        @Override
        public Object getKey() {
            return this.key != null ? this.key : BuiltinEnum.super.getKey();
        }
    }
}

