/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNodeGen;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;

public abstract class IsPristineObjectNode
extends Node {
    private final JSClass jsClass;
    private final Shape initialPrototypeShape;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] propertyKeys;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Assumption[] propertyFinalAssumptions;
    @Node.Child
    private GetPrototypeNode getPrototypeNode = GetPrototypeNode.create();

    IsPristineObjectNode(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        assert (jsClass != JSProxy.INSTANCE) : "not supported because getting the prototype of proxy objects can have side effects";
        this.jsClass = jsClass;
        this.initialPrototypeShape = initialPrototypeShape;
        this.propertyKeys = propertyKeys;
        this.propertyFinalAssumptions = new Assumption[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            this.propertyFinalAssumptions[i] = initialPrototypeShape.getProperty(propertyKeys[i]).getLocation().getFinalAssumption();
        }
    }

    public static IsPristineObjectNode create(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        return IsPristineObjectNodeGen.create(jsClass, initialPrototypeShape, propertyKeys);
    }

    public static IsPristineObjectNode createRegExpExecAndMatch(JSContext context) {
        assert (context.getEcmaScriptVersion() >= 6);
        return IsPristineObjectNode.create(JSRegExp.INSTANCE, context.getRealm().getInitialRegExpPrototypeShape(), Symbol.SYMBOL_MATCH, RegExpPrototypeBuiltins.RegExpPrototype.exec.getKey(), "flags", "global", "unicode", "sticky");
    }

    public abstract boolean execute(DynamicObject var1);

    @Specialization(guards={"cachedShape.check(object)"}, assumptions={"getPropertyFinalAssumptions()"})
    boolean doCached(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isInstanceAndDoesNotOverwriteProps(cachedShape)") boolean isInstanceAndDoesNotOverwriteProps) {
        return isInstanceAndDoesNotOverwriteProps && this.prototypeShapeUnchanged(object);
    }

    @Specialization(assumptions={"getPropertyFinalAssumptions()"}, replaces={"doCached"})
    boolean doDynamic(DynamicObject object) {
        return this.isInstanceAndDoesNotOverwriteProps(object.getShape()) && this.prototypeShapeUnchanged(object);
    }

    @Specialization
    boolean doAssumptionsInvalid(DynamicObject object) {
        return false;
    }

    Assumption[] getPropertyFinalAssumptions() {
        return this.propertyFinalAssumptions;
    }

    private boolean prototypeShapeUnchanged(DynamicObject object) {
        return this.getPrototypeNode.executeJSObject(object).getShape() == this.initialPrototypeShape;
    }

    boolean isInstanceAndDoesNotOverwriteProps(Shape objectShape) {
        if (objectShape.getDynamicType() != this.jsClass) {
            return false;
        }
        for (Object key : this.propertyKeys) {
            if (!objectShape.hasProperty(key)) continue;
            return false;
        }
        return true;
    }
}

