/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentRead;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSGuardDisconnectedArgumentRead.class)
public final class JSGuardDisconnectedArgumentReadNodeGen
extends JSGuardDisconnectedArgumentRead
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile unconnected;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile objectDisconnected_wasDisconnected_;

    private JSGuardDisconnectedArgumentReadNodeGen(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, FrameSlot slot) {
        super(index, readElementNode, argumentsArray, slot);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object argumentsArrayNodeValue_ = this.argumentsArrayNode.execute(frameValue);
        if (state_0 != 0 && JSTypes.isDynamicObject(argumentsArrayNodeValue_)) {
            DynamicObject argumentsArrayNodeValue__ = (DynamicObject)argumentsArrayNodeValue_;
            if ((state_0 & 1) != 0 && !JSGuards.isArgumentsDisconnected(argumentsArrayNodeValue__)) {
                return this.doObject(argumentsArrayNodeValue__, this.unconnected);
            }
            if ((state_0 & 2) != 0 && JSGuards.isArgumentsDisconnected(argumentsArrayNodeValue__)) {
                return this.doObjectDisconnected(argumentsArrayNodeValue__, this.objectDisconnected_wasDisconnected_, this.unconnected);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(argumentsArrayNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object argumentsArrayNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (JSTypes.isDynamicObject(argumentsArrayNodeValue)) {
                DynamicObject argumentsArrayNodeValue_ = (DynamicObject)argumentsArrayNodeValue;
                if (!JSGuards.isArgumentsDisconnected(argumentsArrayNodeValue_)) {
                    if (this.unconnected == null) {
                        this.unconnected = ConditionProfile.createBinaryProfile();
                    }
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doObject(argumentsArrayNodeValue_, this.unconnected);
                    return object;
                }
                if (JSGuards.isArgumentsDisconnected(argumentsArrayNodeValue_)) {
                    this.objectDisconnected_wasDisconnected_ = ConditionProfile.createBinaryProfile();
                    if (this.unconnected == null) {
                        this.unconnected = ConditionProfile.createBinaryProfile();
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doObjectDisconnected(argumentsArrayNodeValue_, this.objectDisconnected_wasDisconnected_, this.unconnected);
                    return object;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.argumentsArrayNode}, argumentsArrayNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<ConditionProfile>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doObject";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.unconnected));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doObjectDisconnected";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.objectDisconnected_wasDisconnected_, this.unconnected));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static JSGuardDisconnectedArgumentRead create(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, FrameSlot slot) {
        return new JSGuardDisconnectedArgumentReadNodeGen(index, readElementNode, argumentsArray, slot);
    }
}

