/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.array.TestArrayNode;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=TestArrayNode.class)
public final class TestArrayNodeGen
extends TestArrayNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private TestArrayNodeGen(TestArrayNode.Test test) {
        super(test);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(DynamicObject arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (s1_.arrayType_.isInstance(TestArrayNode.getArrayType(arg0Value))) {
                        return this.doCached(arg0Value, s1_.arrayType_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doUncached(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(DynamicObject arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                ScriptArray arrayType__;
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null && !s1_.arrayType_.isInstance(TestArrayNode.getArrayType(arg0Value))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (arrayType__ = TestArrayNode.getArrayType(arg0Value)).isInstance(TestArrayNode.getArrayType(arg0Value)) && count1_ < 4) {
                    s1_ = new CachedData(this.cached_cache);
                    s1_.arrayType_ = arrayType__;
                    this.cached_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doCached(arg0Value, s1_.arrayType_);
                    return bl;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doUncached(arg0Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<ScriptArray>> cached = new ArrayList<List<ScriptArray>>();
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.arrayType_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static TestArrayNode create(TestArrayNode.Test test) {
        return new TestArrayNodeGen(test);
    }

    @GeneratedBy(value=TestArrayNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray arrayType_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

