/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InstanceofNode.class)
public final class InstanceofNodeGen
extends InstanceofNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSObjectData jSObject_cache;
    @Node.Child
    private ForeignTargetOther0Data foreignTargetOther0_cache;

    private InstanceofNodeGen(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(context, left, right);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7F) != 0) {
            Object rightNodeValue_;
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(rightNodeValue)) {
                JSObjectData s1_;
                rightNodeValue_ = (DynamicObject)rightNodeValue;
                if ((state_0 & 1) != 0 && (s1_ = this.jSObject_cache) != null && s1_.isObjectNode_.executeBoolean(rightNodeValue_)) {
                    return this.doJSObject(leftNodeValue, (DynamicObject)rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
                if ((state_0 & 2) != 0 && JSGuards.isNullOrUndefined(rightNodeValue_)) {
                    return this.doNullOrUndefinedTarget(leftNodeValue, (DynamicObject)rightNodeValue_);
                }
            }
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue)) {
                rightNodeValue_ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue);
                return this.doStringTarget(leftNodeValue, (String)rightNodeValue_);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue)) {
                double rightNodeValue_2 = JSTypesGen.asImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue);
                return this.doDoubleTarget(leftNodeValue, rightNodeValue_2);
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_3 = (Boolean)rightNodeValue;
                return this.doBooleanTarget(leftNodeValue, rightNodeValue_3);
            }
            if ((state_0 & 0x20) != 0 && rightNodeValue instanceof BigInt) {
                rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigIntTarget(leftNodeValue, (BigInt)rightNodeValue_);
            }
            if ((state_0 & 0x40) != 0 && rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                return this.doSymbolTarget(leftNodeValue, (Symbol)rightNodeValue_);
            }
        }
        if ((state_0 & 0x380) != 0) {
            if ((state_0 & 0x80) != 0 && JSTypes.isDynamicObject(leftNodeValue)) {
                DynamicObject leftNodeValue_ = (DynamicObject)leftNodeValue;
                if (JSGuards.isForeignObject(rightNodeValue) && JSGuards.isJSDynamicObject(leftNodeValue_)) {
                    return this.doForeignTargetJSType(leftNodeValue_, rightNodeValue);
                }
            }
            if ((state_0 & 0x300) != 0) {
                if ((state_0 & 0x100) != 0) {
                    ForeignTargetOther0Data s9_ = this.foreignTargetOther0_cache;
                    while (s9_ != null) {
                        if (s9_.interop_.accepts(rightNodeValue) && JSGuards.isForeignObject(rightNodeValue) && !JSGuards.isJSDynamicObject(leftNodeValue)) {
                            return this.doForeignTargetOther(leftNodeValue, rightNodeValue, s9_.interop_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0x200) != 0 && JSGuards.isForeignObject(rightNodeValue) && !JSGuards.isJSDynamicObject(leftNodeValue)) {
                    return this.foreignTargetOther1Boundary(state_0, leftNodeValue, rightNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignTargetOther1Boundary(int state_0, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignTargetOther1_interop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue);
            boolean bl = this.doForeignTargetOther(leftNodeValue, rightNodeValue, foreignTargetOther1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3F7) == 0 && (state_0 & 0x3FF) != 0) {
            return this.execute_double0(state_0, frameValue);
        }
        if ((state_0 & 0x3EF) == 0 && (state_0 & 0x3FF) != 0) {
            return this.execute_boolean1(state_0, frameValue);
        }
        return this.execute_generic2(state_0, frameValue);
    }

    private Object execute_double0(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state_0 & 0x1C000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state_0 & 0x1A000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state_0 & 0x16000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.doDoubleTarget(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_boolean1(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        return this.doBooleanTarget(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignTargetOther1Boundary0(int state_0, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignTargetOther1_interop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            Boolean bl = this.doForeignTargetOther(leftNodeValue_, rightNodeValue_, foreignTargetOther1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private Object execute_generic2(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0x7F) != 0) {
            Object rightNodeValue__;
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                JSObjectData s1_;
                rightNodeValue__ = (DynamicObject)rightNodeValue_;
                if ((state_0 & 1) != 0 && (s1_ = this.jSObject_cache) != null && s1_.isObjectNode_.executeBoolean(rightNodeValue__)) {
                    return this.doJSObject(leftNodeValue_, (DynamicObject)rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
                if ((state_0 & 2) != 0 && JSGuards.isNullOrUndefined(rightNodeValue__)) {
                    return this.doNullOrUndefinedTarget(leftNodeValue_, (DynamicObject)rightNodeValue__);
                }
            }
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue_)) {
                rightNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue_);
                return this.doStringTarget(leftNodeValue_, (String)rightNodeValue__);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue_)) {
                double rightNodeValue__2 = JSTypesGen.asImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue_);
                return this.doDoubleTarget(leftNodeValue_, rightNodeValue__2);
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__3 = (Boolean)rightNodeValue_;
                return this.doBooleanTarget(leftNodeValue_, rightNodeValue__3);
            }
            if ((state_0 & 0x20) != 0 && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigIntTarget(leftNodeValue_, (BigInt)rightNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return this.doSymbolTarget(leftNodeValue_, (Symbol)rightNodeValue__);
            }
        }
        if ((state_0 & 0x380) != 0) {
            if ((state_0 & 0x80) != 0 && JSTypes.isDynamicObject(leftNodeValue_)) {
                DynamicObject leftNodeValue__ = (DynamicObject)leftNodeValue_;
                if (JSGuards.isForeignObject(rightNodeValue_) && JSGuards.isJSDynamicObject(leftNodeValue__)) {
                    return this.doForeignTargetJSType(leftNodeValue__, rightNodeValue_);
                }
            }
            if ((state_0 & 0x300) != 0) {
                if ((state_0 & 0x100) != 0) {
                    ForeignTargetOther0Data s9_ = this.foreignTargetOther0_cache;
                    while (s9_ != null) {
                        if (s9_.interop_.accepts(rightNodeValue_) && JSGuards.isForeignObject(rightNodeValue_) && !JSGuards.isJSDynamicObject(leftNodeValue_)) {
                            return this.doForeignTargetOther(leftNodeValue_, rightNodeValue_, s9_.interop_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0x200) != 0 && JSGuards.isForeignObject(rightNodeValue_) && !JSGuards.isJSDynamicObject(leftNodeValue_)) {
                    return this.foreignTargetOther1Boundary0(state_0, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3F7) == 0 && (state_0 & 0x3FF) != 0) {
            return this.executeBoolean_double3(state_0, frameValue);
        }
        if ((state_0 & 0x3EF) == 0 && (state_0 & 0x3FF) != 0) {
            return this.executeBoolean_boolean4(state_0, frameValue);
        }
        return this.executeBoolean_generic5(state_0, frameValue);
    }

    private boolean executeBoolean_double3(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state_0 & 0x1C000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state_0 & 0x1A000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state_0 & 0x16000) == 0 && (state_0 & 0x3FF) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.doDoubleTarget(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean4(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        return this.doBooleanTarget(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignTargetOther1Boundary1(int state_0, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignTargetOther1_interop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = this.doForeignTargetOther(leftNodeValue_, rightNodeValue_, foreignTargetOther1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private boolean executeBoolean_generic5(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0x7F) != 0) {
            Object rightNodeValue__;
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                JSObjectData s1_;
                rightNodeValue__ = (DynamicObject)rightNodeValue_;
                if ((state_0 & 1) != 0 && (s1_ = this.jSObject_cache) != null && s1_.isObjectNode_.executeBoolean(rightNodeValue__)) {
                    return this.doJSObject(leftNodeValue_, (DynamicObject)rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
                if ((state_0 & 2) != 0 && JSGuards.isNullOrUndefined(rightNodeValue__)) {
                    return this.doNullOrUndefinedTarget(leftNodeValue_, (DynamicObject)rightNodeValue__);
                }
            }
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue_)) {
                rightNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, rightNodeValue_);
                return this.doStringTarget(leftNodeValue_, (String)rightNodeValue__);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue_)) {
                double rightNodeValue__2 = JSTypesGen.asImplicitDouble((state_0 & 0x1E000) >>> 13, rightNodeValue_);
                return this.doDoubleTarget(leftNodeValue_, rightNodeValue__2);
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__3 = (Boolean)rightNodeValue_;
                return this.doBooleanTarget(leftNodeValue_, rightNodeValue__3);
            }
            if ((state_0 & 0x20) != 0 && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigIntTarget(leftNodeValue_, (BigInt)rightNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return this.doSymbolTarget(leftNodeValue_, (Symbol)rightNodeValue__);
            }
        }
        if ((state_0 & 0x380) != 0) {
            if ((state_0 & 0x80) != 0 && JSTypes.isDynamicObject(leftNodeValue_)) {
                DynamicObject leftNodeValue__ = (DynamicObject)leftNodeValue_;
                if (JSGuards.isForeignObject(rightNodeValue_) && JSGuards.isJSDynamicObject(leftNodeValue__)) {
                    return this.doForeignTargetJSType(leftNodeValue__, rightNodeValue_);
                }
            }
            if ((state_0 & 0x300) != 0) {
                if ((state_0 & 0x100) != 0) {
                    ForeignTargetOther0Data s9_ = this.foreignTargetOther0_cache;
                    while (s9_ != null) {
                        if (s9_.interop_.accepts(rightNodeValue_) && JSGuards.isForeignObject(rightNodeValue_) && !JSGuards.isJSDynamicObject(leftNodeValue_)) {
                            return this.doForeignTargetOther(leftNodeValue_, rightNodeValue_, s9_.interop_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0x200) != 0 && JSGuards.isForeignObject(rightNodeValue_) && !JSGuards.isJSDynamicObject(leftNodeValue_)) {
                    return this.foreignTargetOther1Boundary1(state_0, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            int stringCast1;
            boolean JSObject_duplicateFound_;
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                IsJSObjectNode isObjectNode__;
                DynamicObject rightNodeValue_ = (DynamicObject)rightNodeValue;
                JSObjectData s1_ = this.jSObject_cache;
                JSObject_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && s1_.isObjectNode_.executeBoolean(rightNodeValue_)) {
                    JSObject_duplicateFound_ = true;
                }
                if (!JSObject_duplicateFound_ && (isObjectNode__ = super.insert(IsJSObjectNode.create())).executeBoolean(rightNodeValue_) && (state_0 & 1) == 0) {
                    s1_ = super.insert(new JSObjectData());
                    s1_.isObjectNode_ = s1_.insertAccessor(isObjectNode__);
                    s1_.getMethodHasInstanceNode_ = s1_.insertAccessor(this.createGetMethodHasInstance());
                    s1_.toBooleanNode_ = s1_.insertAccessor(JSToBooleanNode.create());
                    s1_.callHasInstanceNode_ = s1_.insertAccessor(JSFunctionCallNode.createCall());
                    s1_.hasInstanceProfile_ = ConditionProfile.createBinaryProfile();
                    s1_.errorBranch_ = BranchProfile.create();
                    s1_.proxyBranch_ = BranchProfile.create();
                    this.jSObject_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    JSObject_duplicateFound_ = true;
                }
                if (JSObject_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doJSObject(leftNodeValue, rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                    return bl;
                }
                if (JSGuards.isNullOrUndefined(rightNodeValue_)) {
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doNullOrUndefinedTarget(leftNodeValue, rightNodeValue_);
                    return bl;
                }
            }
            if ((stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                String rightNodeValue_ = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                state_0 |= stringCast1 << 10;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                JSObject_duplicateFound_ = this.doStringTarget(leftNodeValue, rightNodeValue_);
                return JSObject_duplicateFound_;
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
            if (doubleCast1 != 0) {
                double rightNodeValue_2 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                state_0 |= doubleCast1 << 13;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doDoubleTarget(leftNodeValue, rightNodeValue_2);
                return bl;
            }
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_ = (Boolean)rightNodeValue;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_2 = this.doBooleanTarget(leftNodeValue, rightNodeValue_);
                return rightNodeValue_2;
            }
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_2 = this.doBigIntTarget(leftNodeValue, rightNodeValue_);
                return rightNodeValue_2;
            }
            if (rightNodeValue instanceof Symbol) {
                Symbol rightNodeValue_ = (Symbol)rightNodeValue;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_2 = this.doSymbolTarget(leftNodeValue, rightNodeValue_);
                return rightNodeValue_2;
            }
            if (JSTypes.isDynamicObject(leftNodeValue)) {
                DynamicObject leftNodeValue_ = (DynamicObject)leftNodeValue;
                if (JSGuards.isForeignObject(rightNodeValue) && JSGuards.isJSDynamicObject(leftNodeValue_)) {
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_2 = this.doForeignTargetJSType(leftNodeValue_, rightNodeValue);
                    return rightNodeValue_2;
                }
            }
            if (exclude == 0) {
                int count9_ = 0;
                ForeignTargetOther0Data s9_ = this.foreignTargetOther0_cache;
                if ((state_0 & 0x100) != 0) {
                    while (!(s9_ == null || s9_.interop_.accepts(rightNodeValue) && JSGuards.isForeignObject(rightNodeValue) && !JSGuards.isJSDynamicObject(leftNodeValue))) {
                        s9_ = s9_.next_;
                        ++count9_;
                    }
                }
                if (s9_ == null && JSGuards.isForeignObject(rightNodeValue) && !JSGuards.isJSDynamicObject(leftNodeValue) && count9_ < 5) {
                    s9_ = super.insert(new ForeignTargetOther0Data(this.foreignTargetOther0_cache));
                    s9_.interop_ = s9_.insertAccessor(INTEROP_LIBRARY_.create(rightNodeValue));
                    this.foreignTargetOther0_cache = s9_;
                    this.state_0_ = state_0 |= 0x100;
                }
                if (s9_ != null) {
                    lock.unlock();
                    hasLock = false;
                    JSObject_duplicateFound_ = this.doForeignTargetOther(leftNodeValue, rightNodeValue, s9_.interop_);
                    return JSObject_duplicateFound_;
                }
            }
            InteropLibrary foreignTargetOther1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                if (JSGuards.isForeignObject(rightNodeValue) && !JSGuards.isJSDynamicObject(leftNodeValue)) {
                    foreignTargetOther1_interop__ = INTEROP_LIBRARY_.getUncached(rightNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.foreignTargetOther0_cache = null;
                    state_0 &= 0xFFFFFEFF;
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doForeignTargetOther(leftNodeValue, rightNodeValue, foreignTargetOther1_interop__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.leftNode, this.rightNode}, leftNodeValue, rightNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ForeignTargetOther0Data s9_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x3FF & (state_0 & 0x3FF) - 1) == 0 && ((s9_ = this.foreignTargetOther0_cache) == null || s9_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doJSObject";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            JSObjectData s1_ = this.jSObject_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefinedTarget";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doStringTarget";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doDoubleTarget";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBooleanTarget";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigIntTarget";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSymbolTarget";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doForeignTargetJSType";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doForeignTargetOther";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignTargetOther0Data s9_ = this.foreignTargetOther0_cache;
            while (s9_ != null) {
                cached.add(Arrays.asList(s9_.interop_));
                s9_ = s9_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignTargetOther";
        if ((state_0 & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        return Introspection.Provider.create(data);
    }

    public static InstanceofNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return new InstanceofNodeGen(context, left, right);
    }

    @GeneratedBy(value=InstanceofNode.IsBoundFunctionCacheNode.class)
    public static final class IsBoundFunctionCacheNodeGen
    extends InstanceofNode.IsBoundFunctionCacheNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private DynamicObject cachedInstance_cachedFunction_;
        @CompilerDirectives.CompilationFinal
        private boolean cachedInstance_cachedIsBound_;
        @CompilerDirectives.CompilationFinal
        private CachedShapeData cachedShape_cache;

        private IsBoundFunctionCacheNodeGen(boolean multiContext) {
            super(multiContext);
        }

        @Override
        @ExplodeLoop
        public boolean executeBoolean(DynamicObject arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    assert (!this.multiContext);
                    if (arg0Value == this.cachedInstance_cachedFunction_) {
                        return InstanceofNode.IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                    }
                }
                if ((state_0 & 2) != 0) {
                    CachedShapeData s2_ = this.cachedShape_cache;
                    while (s2_ != null) {
                        if (s2_.cachedShape_.check(arg0Value)) {
                            return InstanceofNode.IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    return InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    boolean CachedInstance_duplicateFound_ = false;
                    if ((state_0 & 1) != 0) {
                        assert (!this.multiContext);
                        if (arg0Value == this.cachedInstance_cachedFunction_) {
                            CachedInstance_duplicateFound_ = true;
                        }
                    }
                    if (!CachedInstance_duplicateFound_ && !this.multiContext && (state_0 & 1) == 0) {
                        this.cachedInstance_cachedFunction_ = arg0Value;
                        this.cachedInstance_cachedIsBound_ = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                        this.state_0_ = state_0 |= 1;
                        CachedInstance_duplicateFound_ = true;
                    }
                    if (CachedInstance_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = InstanceofNode.IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                        return bl;
                    }
                }
                if ((exclude & 2) == 0) {
                    Shape cachedShape__;
                    int count2_ = 0;
                    CachedShapeData s2_ = this.cachedShape_cache;
                    if ((state_0 & 2) != 0) {
                        while (s2_ != null && !s2_.cachedShape_.check(arg0Value)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (cachedShape__ = arg0Value.getShape()).check(arg0Value) && count2_ < 3) {
                        s2_ = new CachedShapeData(this.cachedShape_cache);
                        s2_.cachedShape_ = cachedShape__;
                        s2_.cachedIsBound_ = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                        this.cachedShape_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = InstanceofNode.IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.cachedShape_cache = null;
                state_0 &= 0xFFFFFFFC;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedShapeData s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.cachedShape_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCachedInstance";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_));
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doCachedShape";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                CachedShapeData s2_ = this.cachedShape_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.cachedShape_, s2_.cachedIsBound_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isBoundFunction";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create(data);
        }

        public static InstanceofNode.IsBoundFunctionCacheNode create(boolean multiContext) {
            return new IsBoundFunctionCacheNodeGen(multiContext);
        }

        @GeneratedBy(value=InstanceofNode.IsBoundFunctionCacheNode.class)
        private static final class CachedShapeData {
            @CompilerDirectives.CompilationFinal
            CachedShapeData next_;
            @CompilerDirectives.CompilationFinal
            Shape cachedShape_;
            @CompilerDirectives.CompilationFinal
            boolean cachedIsBound_;

            CachedShapeData(CachedShapeData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=InstanceofNode.OrdinaryHasInstanceNode.class)
    public static final class OrdinaryHasInstanceNodeGen
    extends InstanceofNode.OrdinaryHasInstanceNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private GetPrototypeNode getPrototype1Node;
        @Node.Child
        private GetPrototypeNode getPrototype2Node;
        @Node.Child
        private GetPrototypeNode getPrototype3Node;
        @CompilerDirectives.CompilationFinal
        private BranchProfile firstTrue;
        @CompilerDirectives.CompilationFinal
        private BranchProfile firstFalse;
        @CompilerDirectives.CompilationFinal
        private BranchProfile need2Hops;
        @CompilerDirectives.CompilationFinal
        private BranchProfile need3Hops;
        @CompilerDirectives.CompilationFinal
        private BranchProfile errorBranch;
        @CompilerDirectives.CompilationFinal
        private BranchProfile invalidPrototypeBranch;
        @Node.Child
        private InstanceofNode isBound_instanceofNode_;

        private OrdinaryHasInstanceNodeGen(JSContext context) {
            super(context);
        }

        @Override
        public boolean executeBoolean(Object arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) != 0) {
                if ((state_0 & 1) != 0 && !JSGuards.isCallable(arg1Value)) {
                    return this.doNotCallable(arg0Value, arg1Value);
                }
                if ((state_0 & 0xE) != 0 && JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if ((state_0 & 2) != 0 && JSGuards.isJSFunction(arg1Value_) && this.isBoundFunction(arg1Value_)) {
                        return this.doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                    }
                    if ((state_0 & 4) != 0 && !JSGuards.isJSObject(arg0Value) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        return this.doNotAnObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arg0Value) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        return this.doNotAnObjectProxy(arg0Value, arg1Value_);
                    }
                }
            }
            if ((state_0 & 0x30) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if ((state_0 & 0x10) != 0 && this.isObjectNode.executeBoolean(arg0Value_) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        return this.doJSObject(arg0Value_, arg1Value_, this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch);
                    }
                    if ((state_0 & 0x20) != 0 && this.isObjectNode.executeBoolean(arg0Value_) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        return this.doJSObjectProxy(arg0Value_, arg1Value_, this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (!JSGuards.isCallable(arg1Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doNotCallable(arg0Value, arg1Value);
                    return bl;
                }
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if (JSGuards.isJSFunction(arg1Value_) && this.isBoundFunction(arg1Value_)) {
                        this.isBound_instanceofNode_ = super.insert(InstanceofNode.create(this.context));
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                        return bl;
                    }
                    if (!JSGuards.isJSObject(arg0Value) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doNotAnObject(arg0Value, arg1Value_);
                        return bl;
                    }
                    if (!JSGuards.isJSObject(arg0Value) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doNotAnObjectProxy(arg0Value, arg1Value_);
                        return bl;
                    }
                }
                if (JSTypes.isDynamicObject(arg0Value)) {
                    DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                    if (JSTypes.isDynamicObject(arg1Value)) {
                        IsJSObjectNode jSObjectProxy_isObjectNode__;
                        IsJSObjectNode jSObject_isObjectNode__2;
                        DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                        boolean JSObject_duplicateFound_ = false;
                        if ((state_0 & 0x10) != 0 && this.isObjectNode.executeBoolean(arg0Value_) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                            JSObject_duplicateFound_ = true;
                        }
                        if (!JSObject_duplicateFound_ && (jSObject_isObjectNode__2 = super.insert(IsJSObjectNode.create())).executeBoolean(arg0Value_) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_) && (state_0 & 0x10) == 0) {
                            if (this.isObjectNode == null) {
                                this.isObjectNode = super.insert(jSObject_isObjectNode__2);
                            }
                            if (this.getPrototype1Node == null) {
                                this.getPrototype1Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.getPrototype2Node == null) {
                                this.getPrototype2Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.getPrototype3Node == null) {
                                this.getPrototype3Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.firstTrue == null) {
                                this.firstTrue = BranchProfile.create();
                            }
                            if (this.firstFalse == null) {
                                this.firstFalse = BranchProfile.create();
                            }
                            if (this.need2Hops == null) {
                                this.need2Hops = BranchProfile.create();
                            }
                            if (this.need3Hops == null) {
                                this.need3Hops = BranchProfile.create();
                            }
                            if (this.errorBranch == null) {
                                this.errorBranch = BranchProfile.create();
                            }
                            if (this.invalidPrototypeBranch == null) {
                                this.invalidPrototypeBranch = BranchProfile.create();
                            }
                            this.state_0_ = state_0 |= 0x10;
                            JSObject_duplicateFound_ = true;
                        }
                        if (JSObject_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            boolean jSObject_isObjectNode__2 = this.doJSObject(arg0Value_, arg1Value_, this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch);
                            return jSObject_isObjectNode__2;
                        }
                        boolean JSObjectProxy_duplicateFound_ = false;
                        if ((state_0 & 0x20) != 0 && this.isObjectNode.executeBoolean(arg0Value_) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                            JSObjectProxy_duplicateFound_ = true;
                        }
                        if (!JSObjectProxy_duplicateFound_ && (jSObjectProxy_isObjectNode__ = super.insert(IsJSObjectNode.create())).executeBoolean(arg0Value_) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_) && (state_0 & 0x20) == 0) {
                            if (this.isObjectNode == null) {
                                this.isObjectNode = super.insert(jSObjectProxy_isObjectNode__);
                            }
                            if (this.getPrototype1Node == null) {
                                this.getPrototype1Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.getPrototype2Node == null) {
                                this.getPrototype2Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.getPrototype3Node == null) {
                                this.getPrototype3Node = super.insert(GetPrototypeNode.create());
                            }
                            if (this.firstTrue == null) {
                                this.firstTrue = BranchProfile.create();
                            }
                            if (this.firstFalse == null) {
                                this.firstFalse = BranchProfile.create();
                            }
                            if (this.need2Hops == null) {
                                this.need2Hops = BranchProfile.create();
                            }
                            if (this.need3Hops == null) {
                                this.need3Hops = BranchProfile.create();
                            }
                            if (this.errorBranch == null) {
                                this.errorBranch = BranchProfile.create();
                            }
                            if (this.invalidPrototypeBranch == null) {
                                this.invalidPrototypeBranch = BranchProfile.create();
                            }
                            this.state_0_ = state_0 |= 0x20;
                            JSObjectProxy_duplicateFound_ = true;
                        }
                        if (JSObjectProxy_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.doJSObjectProxy(arg0Value_, arg1Value_, this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch);
                            return bl;
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[7];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "doNotCallable";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doIsBound";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(this.isBound_instanceofNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNotAnObject";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doNotAnObjectProxy";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doJSObject";
            if ((state_0 & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "doJSObjectProxy";
            if ((state_0 & 0x20) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isObjectNode, this.getPrototype1Node, this.getPrototype2Node, this.getPrototype3Node, this.firstTrue, this.firstFalse, this.need2Hops, this.need3Hops, this.errorBranch, this.invalidPrototypeBranch));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[6] = s;
            return Introspection.Provider.create(data);
        }

        public static InstanceofNode.OrdinaryHasInstanceNode create(JSContext context) {
            return new OrdinaryHasInstanceNodeGen(context);
        }
    }

    @GeneratedBy(value=InstanceofNode.class)
    private static final class ForeignTargetOther0Data
    extends Node {
        @Node.Child
        ForeignTargetOther0Data next_;
        @Node.Child
        InteropLibrary interop_;

        ForeignTargetOther0Data(ForeignTargetOther0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=InstanceofNode.class)
    private static final class JSObjectData
    extends Node {
        @Node.Child
        IsJSObjectNode isObjectNode_;
        @Node.Child
        GetMethodNode getMethodHasInstanceNode_;
        @Node.Child
        JSToBooleanNode toBooleanNode_;
        @Node.Child
        JSFunctionCallNode callHasInstanceNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile hasInstanceProfile_;
        @CompilerDirectives.CompilationFinal
        BranchProfile errorBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile proxyBranch_;

        JSObjectData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

