/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class JSToBooleanUnaryNode
extends JSUnaryNode {
    protected JSToBooleanUnaryNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        Object constantOperand;
        JSConstantNode replacement = null;
        if (child.isResultAlwaysOfType(Boolean.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode.JSConstantIntegerNode) {
            int value = ((JSConstantNode.JSConstantIntegerNode)child).executeInt(null);
            replacement = JSConstantNode.createBoolean(value != 0);
        } else if (child instanceof JSConstantNode.JSConstantBigIntNode) {
            BigInt value = ((JSConstantNode.JSConstantBigIntNode)child).executeBigInt(null);
            replacement = JSConstantNode.createBoolean(value.compareTo(BigInt.ZERO) != 0);
        } else if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && JSRuntime.isJSPrimitive(constantOperand)) {
            replacement = JSConstantNode.createBoolean(JSRuntime.toBoolean(constantOperand));
        }
        if (replacement == null) {
            return JSToBooleanUnaryNodeGen.create(child);
        }
        JavaScriptNode.transferSourceSectionAndTags(child, replacement);
        return replacement;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected static boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected static boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected static boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected static boolean doLazyString(JSLazyString value) {
        return !value.isEmpty();
    }

    @Specialization
    protected static boolean doString(String value) {
        return value.length() > 0;
    }

    @Specialization(guards={"isJSObject(value)"})
    protected static boolean doObject(Object value) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol value) {
        return true;
    }

    @Specialization(guards={"isForeignObject(value)"})
    protected static boolean doForeignObject(Object value, @Cached JSToBooleanNode toBooleanNode) {
        return toBooleanNode.executeBoolean(value);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSToBooleanUnaryNodeGen.create(JSToBooleanUnaryNode.cloneUninitialized(this.getOperand(), materializedTags));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    public String expressionToString() {
        return this.getOperand().expressionToString();
    }
}

