/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToObjectNode.class)
public final class JSToObjectNodeGen
extends JSToObjectNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private Class<?> jSObjectCached_cachedClass_;
    @Node.Child
    private ForeignObjectAllowed0Data foreignObjectAllowed0_cache;
    @Node.Child
    private JSToObjectNode foreignObjectAllowed1_toObjectNode_;

    private JSToObjectNodeGen(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        super(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_ = (JSLazyString)arg0Value;
            return this.doJSLazyString(arg0Value_);
        }
        if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70000) >>> 16, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state_0 & 0x70000) >>> 16, arg0Value);
            return this.doString(arg0Value_);
        }
        if ((state_0 & 8) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.doInt(arg0Value_);
        }
        if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x780000) >>> 19, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x780000) >>> 19, arg0Value);
            return this.doDouble(arg0Value_);
        }
        if ((state_0 & 0x20) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_);
        }
        if ((state_0 & 0x40) != 0 && JSGuards.isJavaNumber(arg0Value)) {
            return this.doNumber(arg0Value);
        }
        if ((state_0 & 0x80) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_);
        }
        if ((state_0 & 0x700) != 0) {
            if ((state_0 & 0x100) != 0) {
                assert (this.jSObjectCached_cachedClass_ != null);
                if (this.jSObjectCached_cachedClass_.isInstance(arg0Value)) {
                    return JSToObjectNode.doJSObjectCached(arg0Value, this.jSObjectCached_cachedClass_);
                }
            }
            if ((state_0 & 0x200) != 0) {
                assert (!this.isCheckForNullOrUndefined());
                if (JSGuards.isJSDynamicObject(arg0Value)) {
                    return this.doJSObjectNoCheck(arg0Value);
                }
            }
            if ((state_0 & 0x400) != 0) {
                assert (this.isCheckForNullOrUndefined());
                if (JSGuards.isJSObject(arg0Value)) {
                    return this.doJSObjectCheck(arg0Value);
                }
            }
        }
        if ((state_0 & 0x800) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            assert (this.isCheckForNullOrUndefined());
            if (JSGuards.isNullOrUndefined(arg0Value_)) {
                return this.doNullOrUndefined(arg0Value_);
            }
        }
        if ((state_0 & 0xF000) != 0) {
            if ((state_0 & 0x1000) != 0) {
                ForeignObjectAllowed0Data s13_ = this.foreignObjectAllowed0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value)) {
                        assert (this.isAllowForeign());
                        if (JSGuards.isForeignObject(arg0Value)) {
                            return this.doForeignObjectAllowed(arg0Value, s13_.toObjectNode_, s13_.interop_);
                        }
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state_0 & 0x2000) != 0) {
                assert (this.isAllowForeign());
                if (JSGuards.isForeignObject(arg0Value)) {
                    return this.foreignObjectAllowed1Boundary(state_0, arg0Value);
                }
            }
            if ((state_0 & 0x4000) != 0) {
                assert (!this.isAllowForeign());
                if (JSGuards.isForeignObject(arg0Value)) {
                    return this.doForeignObjectDisallowed(arg0Value);
                }
            }
            if (!((state_0 & 0x8000) == 0 || JSGuards.isBoolean(arg0Value) || JSGuards.isNumber(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isSymbol(arg0Value) || JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                return this.doJavaGeneric(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObjectAllowed1Boundary(int state_0, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignObjectAllowed1_interop__ = INTEROP_LIBRARY_.getUncached(arg0Value);
            Object object = this.doForeignObjectAllowed(arg0Value, this.foreignObjectAllowed1_toObjectNode_, foreignObjectAllowed1_interop__);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            Object object;
            Object jSObjectCached_cachedClass__;
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doBoolean(arg0Value_);
                return dynamicObject;
            }
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_ = (JSLazyString)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doJSLazyString(arg0Value_);
                return dynamicObject;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_2 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state_0 |= stringCast0 << 16;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doString(arg0Value_2);
                return dynamicObject;
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_2 = this.doInt(arg0Value_);
                return arg0Value_2;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_3 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 |= doubleCast0 << 19;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doDouble(arg0Value_3);
                return dynamicObject;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_3 = this.doBigInt(arg0Value_);
                return arg0Value_3;
            }
            if (JSGuards.isJavaNumber(arg0Value)) {
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_ = this.doNumber(arg0Value);
                return arg0Value_;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_3 = this.doSymbol(arg0Value_);
                return arg0Value_3;
            }
            if ((exclude & 1) == 0) {
                boolean JSObjectCached_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0) {
                    assert (this.jSObjectCached_cachedClass_ != null);
                    if (this.jSObjectCached_cachedClass_.isInstance(arg0Value)) {
                        JSObjectCached_duplicateFound_ = true;
                    }
                }
                if (!JSObjectCached_duplicateFound_ && (jSObjectCached_cachedClass__ = this.getClassIfObject(arg0Value)) != null && ((Class)jSObjectCached_cachedClass__).isInstance(arg0Value) && (state_0 & 0x100) == 0) {
                    this.jSObjectCached_cachedClass_ = jSObjectCached_cachedClass__;
                    this.state_0_ = state_0 |= 0x100;
                    JSObjectCached_duplicateFound_ = true;
                }
                if (JSObjectCached_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    jSObjectCached_cachedClass__ = JSToObjectNode.doJSObjectCached(arg0Value, this.jSObjectCached_cachedClass_);
                    return jSObjectCached_cachedClass__;
                }
            }
            if (!this.isCheckForNullOrUndefined() && JSGuards.isJSDynamicObject(arg0Value)) {
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFEFF;
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                Object JSObjectCached_duplicateFound_ = this.doJSObjectNoCheck(arg0Value);
                return JSObjectCached_duplicateFound_;
            }
            if (this.isCheckForNullOrUndefined() && JSGuards.isJSObject(arg0Value)) {
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFEFF;
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                Object JSObjectCached_duplicateFound_ = this.doJSObjectCheck(arg0Value);
                return JSObjectCached_duplicateFound_;
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (this.isCheckForNullOrUndefined() && JSGuards.isNullOrUndefined(arg0Value_)) {
                    this.state_0_ = state_0 |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    jSObjectCached_cachedClass__ = this.doNullOrUndefined(arg0Value_);
                    return jSObjectCached_cachedClass__;
                }
            }
            if ((exclude & 2) == 0) {
                int count13_ = 0;
                ForeignObjectAllowed0Data s13_ = this.foreignObjectAllowed0_cache;
                if ((state_0 & 0x1000) != 0) {
                    while (s13_ != null) {
                        if (s13_.interop_.accepts(arg0Value)) {
                            assert (this.isAllowForeign());
                            if (JSGuards.isForeignObject(arg0Value)) break;
                        }
                        s13_ = s13_.next_;
                        ++count13_;
                    }
                }
                if (s13_ == null && this.isAllowForeign() && JSGuards.isForeignObject(arg0Value) && count13_ < 5) {
                    s13_ = super.insert(new ForeignObjectAllowed0Data(this.foreignObjectAllowed0_cache));
                    s13_.toObjectNode_ = s13_.insertAccessor(JSToObjectNode.createToObject(this.context, this.checkForNullOrUndefined, this.fromWith, this.allowForeign));
                    s13_.interop_ = s13_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    this.foreignObjectAllowed0_cache = s13_;
                    this.state_0_ = state_0 |= 0x1000;
                }
                if (s13_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object2 = this.doForeignObjectAllowed(arg0Value, s13_.toObjectNode_, s13_.interop_);
                    return object2;
                }
            }
            InteropLibrary foreignObjectAllowed1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                if (this.isAllowForeign() && JSGuards.isForeignObject(arg0Value)) {
                    this.foreignObjectAllowed1_toObjectNode_ = super.insert(JSToObjectNode.createToObject(this.context, this.checkForNullOrUndefined, this.fromWith, this.allowForeign));
                    foreignObjectAllowed1_interop__ = INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 2;
                    this.foreignObjectAllowed0_cache = null;
                    state_0 &= 0xFFFFEFFF;
                    this.state_0_ = state_0 |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    Object object3 = this.doForeignObjectAllowed(arg0Value, this.foreignObjectAllowed1_toObjectNode_, foreignObjectAllowed1_interop__);
                    return object3;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if (!this.isAllowForeign() && JSGuards.isForeignObject(arg0Value)) {
                this.state_0_ = state_0 |= 0x4000;
                lock.unlock();
                hasLock = false;
                object = this.doForeignObjectDisallowed(arg0Value);
                return object;
            }
            if (!(JSGuards.isBoolean(arg0Value) || JSGuards.isNumber(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isSymbol(arg0Value) || JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                this.state_0_ = state_0 |= 0x8000;
                lock.unlock();
                hasLock = false;
                object = this.doJavaGeneric(arg0Value);
                return object;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ForeignObjectAllowed0Data s13_;
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFFFF & (state_0 & 0xFFFF) - 1) == 0 && ((s13_ = this.foreignObjectAllowed0_cache) == null || s13_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[17];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectCached";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.jSObjectCached_cachedClass_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObjectNoCheck";
        s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheck";
        s[1] = (state_0 & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state_0 & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doForeignObjectAllowed";
        if ((state_0 & 0x1000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObjectAllowed0Data s13_ = this.foreignObjectAllowed0_cache;
            while (s13_ != null) {
                cached.add(Arrays.asList(s13_.toObjectNode_, s13_.interop_));
                s13_ = s13_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doForeignObjectAllowed";
        if ((state_0 & 0x2000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignObjectAllowed1_toObjectNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doForeignObjectDisallowed";
        s[1] = (state_0 & 0x4000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        s = new Object[3];
        s[0] = "doJavaGeneric";
        s[1] = (state_0 & 0x8000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[16] = s;
        return Introspection.Provider.create(data);
    }

    public static JSToObjectNode create(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        return new JSToObjectNodeGen(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @GeneratedBy(value=JSToObjectNode.JSToObjectWrapperNode.class)
    public static final class JSToObjectWrapperNodeGen
    extends JSToObjectNode.JSToObjectWrapperNode
    implements Introspection.Provider {
        private JSToObjectWrapperNodeGen(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            super(operand, toObjectNode);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public DynamicObject executeDynamicObject(Object operandNodeValue) {
            return (DynamicObject)this.execute(null, operandNodeValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create(data);
        }

        public static JSToObjectNode.JSToObjectWrapperNode create(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            return new JSToObjectWrapperNodeGen(operand, toObjectNode);
        }
    }

    @GeneratedBy(value=JSToObjectNode.class)
    private static final class ForeignObjectAllowed0Data
    extends Node {
        @Node.Child
        ForeignObjectAllowed0Data next_;
        @Node.Child
        JSToObjectNode toObjectNode_;
        @Node.Child
        InteropLibrary interop_;

        ForeignObjectAllowed0Data(ForeignObjectAllowed0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

