/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public final class GeneratorWrapperNode
extends JavaScriptNode
implements RepeatingNode {
    @Node.Child
    private JavaScriptNode childNode;
    @Node.Child
    private JavaScriptNode stateNode;
    @Node.Child
    private WriteNode writeStateNode;

    private GeneratorWrapperNode(JavaScriptNode childNode, JavaScriptNode stateNode, WriteNode writeStateNode) {
        assert (childNode instanceof ResumableNode) : childNode;
        this.childNode = childNode;
        this.stateNode = stateNode;
        this.writeStateNode = writeStateNode;
    }

    public static JavaScriptNode createWrapper(JavaScriptNode child, JavaScriptNode readStateNode, WriteNode writeStateNode) {
        GeneratorWrapperNode wrapper = new GeneratorWrapperNode(child, readStateNode, writeStateNode);
        JavaScriptNode realChild = child instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)((Object)child)).getDelegateNode() : child;
        wrapper.setSourceSection(((Node)realChild).getSourceSection());
        return wrapper;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        JavaScriptNode child;
        Node node = child = this.childNode instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)((Object)this.childNode)).getDelegateNode() : this.childNode;
        if (child instanceof JavaScriptNode) {
            return child.hasTag(tag);
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        JavaScriptNode child;
        Node node = child = this.childNode instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)((Object)this.childNode)).getDelegateNode() : this.childNode;
        if (child instanceof JavaScriptNode) {
            return child.getNodeObject();
        }
        return null;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Node child = this.childNode;
        if (child instanceof InstrumentableNode.WrapperNode) {
            child = ((InstrumentableNode.WrapperNode)((Object)child)).getDelegateNode();
        }
        if (child instanceof ResumableNode) {
            return ((ResumableNode)((Object)child)).resume(frame);
        }
        assert (false) : child.getClass();
        throw Errors.shouldNotReachHere();
    }

    @Override
    public boolean executeRepeating(VirtualFrame frame) {
        assert (this.childNode instanceof ResumableNode && this.childNode instanceof RepeatingNode) : this.childNode.getClass();
        return (Boolean)this.execute(frame);
    }

    public Object isResuming(VirtualFrame frame) {
        return this.stateNode.execute(frame) != Undefined.instance;
    }

    public Object getState(VirtualFrame frame) {
        return this.stateNode.execute(frame);
    }

    public int getStateAsInt(VirtualFrame frame) {
        Object value = this.stateNode.execute(frame);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public void setState(VirtualFrame frame, Object resumeState) {
        this.writeStateNode.executeWrite(frame, resumeState);
    }

    public JavaScriptNode getResumableNode() {
        return this.childNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GeneratorWrapperNode.createWrapper(GeneratorWrapperNode.cloneUninitialized(this.childNode, materializedTags), GeneratorWrapperNode.cloneUninitialized(this.stateNode, materializedTags), (WriteNode)((Object)GeneratorWrapperNode.cloneUninitialized((JavaScriptNode)((Object)this.writeStateNode), materializedTags)));
    }
}

