/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Objects;

public class BlockEnvironment
extends Environment {
    private final FunctionEnvironment functionEnvironment;
    private final FrameDescriptor blockFrameDescriptor;
    private final FrameSlot parentSlot;
    private final int scopeLevel;
    private final FrameSlot[] parentSlots;

    public BlockEnvironment(Environment parent, NodeFactory factory, JSContext context) {
        super(parent, factory, context);
        this.functionEnvironment = parent.function();
        this.blockFrameDescriptor = factory.createBlockFrameDescriptor();
        this.parentSlot = Objects.requireNonNull(this.blockFrameDescriptor.findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER));
        this.scopeLevel = parent.getScopeLevel() + 1;
        this.parentSlots = BlockEnvironment.prepend(parent.getParentSlots(), this.parentSlot);
        assert (this.parentSlots.length == this.scopeLevel);
    }

    @Override
    public FunctionEnvironment function() {
        return this.functionEnvironment;
    }

    @Override
    public FrameSlot findBlockFrameSlot(String name) {
        return this.getBlockFrameDescriptor().findFrameSlot(name);
    }

    @Override
    public FrameDescriptor getBlockFrameDescriptor() {
        return this.blockFrameDescriptor;
    }

    public FrameSlot getParentSlot() {
        return this.parentSlot;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public FrameSlot[] getParentSlots() {
        return this.parentSlots;
    }

    private static FrameSlot[] prepend(FrameSlot[] srcArray, FrameSlot newSlot) {
        FrameSlot[] newArray = new FrameSlot[srcArray.length + 1];
        newArray[0] = newSlot;
        System.arraycopy(srcArray, 0, newArray, 1, srcArray.length);
        return newArray;
    }
}

