/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.runtime.JSContext;

public class DebugEnvironment
extends Environment {
    private final Node locationNode;
    private final MaterializedFrame lexicalContextFrame;

    public DebugEnvironment(Environment parent, NodeFactory factory, JSContext context, Node locationNode, MaterializedFrame lexicalContextFrame) {
        super(parent, factory, context);
        this.locationNode = locationNode;
        this.lexicalContextFrame = lexicalContextFrame;
    }

    @Override
    protected FrameSlot findBlockFrameSlot(String name) {
        return null;
    }

    @Override
    public FunctionEnvironment function() {
        return null;
    }

    @Override
    public boolean isStrictMode() {
        return true;
    }

    public boolean hasMember(String name) {
        try {
            Object scope = NodeLibrary.getUncached().getScope(this.locationNode, this.lexicalContextFrame, true);
            return InteropLibrary.getUncached().isMemberReadable(scope, name);
        }
        catch (UnsupportedMessageException e) {
            return false;
        }
    }
}

