/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.intl.CollatorFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.CollatorPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public final class JSCollator
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Collator";
    public static final String PROTOTYPE_NAME = "Collator.prototype";
    static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey("Collator");
    public static final JSCollator INSTANCE = new JSCollator();
    private static final Set<String> VALID_COLLATION_TYPES = new HashSet<String>(Arrays.asList("big5han", "compat", "dict", "direct", "ducet", "emoji", "eor", "gb2312", "phonebk", "phonetic", "pinyin", "reformed", "searchjl", "stroke", "trad", "unihan", "zhuyin"));

    private JSCollator() {
    }

    public static boolean isJSCollator(Object obj) {
        return obj instanceof JSCollatorObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject collatorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, collatorPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, collatorPrototype, CollatorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putBuiltinAccessorProperty(collatorPrototype, (Object)"compare", JSCollator.createCompareFunctionGetter(realm, ctx), Undefined.instance);
        JSObjectUtil.putToStringTag(collatorPrototype, "Intl.Collator");
        return collatorPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initializeCollator(JSContext ctx, InternalState state, String[] locales, String usage, String localeMatcher, Boolean optkn, String optkf, String sensitivity, Boolean ignorePunctuation) {
        String coType;
        boolean searchUsage;
        String kfType;
        String kf;
        state.initializedCollator = true;
        state.usage = usage;
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        Locale.Builder builder = new Locale.Builder().setLocale(strippedLocale);
        Boolean kn = optkn;
        if (kn == null) {
            String knType = selectedLocale.getUnicodeLocaleType("kn");
            if ("".equals(knType) || "true".equals(knType)) {
                kn = true;
            } else if ("false".equals(knType)) {
                kn = false;
            }
            if (kn != null) {
                String value = kn != false ? "" : "false";
                builder.setUnicodeLocaleKeyword("kn", value);
            }
        }
        if (kn != null) {
            state.numeric = kn;
        }
        if ((kf = optkf) == null && ("upper".equals(kfType = selectedLocale.getUnicodeLocaleType("kf")) || "lower".equals(kfType) || "false".equals(kfType))) {
            kf = kfType;
            builder.setUnicodeLocaleKeyword("kf", kfType);
        }
        if (kf != null) {
            state.caseFirst = kf;
        }
        if (!(searchUsage = "search".equals(usage)) && VALID_COLLATION_TYPES.contains(coType = selectedLocale.getUnicodeLocaleType("co"))) {
            builder.setUnicodeLocaleKeyword("co", coType);
            state.collation = coType;
        }
        if (sensitivity != null) {
            state.sensitivity = sensitivity;
        }
        state.ignorePunctuation = ignorePunctuation;
        Locale collatorLocale = builder.build();
        state.locale = collatorLocale.toLanguageTag();
        if (searchUsage) {
            collatorLocale = builder.setUnicodeLocaleKeyword("co", "search").build();
        }
        state.collator = Collator.getInstance(collatorLocale);
        state.collator.setDecomposition(17);
        switch (state.sensitivity) {
            case "base": {
                state.collator.setStrength(0);
                break;
            }
            case "accent": {
                state.collator.setStrength(1);
                break;
            }
            case "case": 
            case "variant": {
                state.collator.setStrength(2);
            }
        }
        if (state.ignorePunctuation && state.collator instanceof RuleBasedCollator) {
            ((RuleBasedCollator)state.collator).setAlternateHandlingShifted(true);
        }
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, CollatorFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getCollatorFactory();
        JSCollatorObject obj = new JSCollatorObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSCollator.isJSCollator(obj));
        return context.trackAllocation(obj);
    }

    public static Collator getCollatorProperty(DynamicObject obj) {
        return JSCollator.getInternalState(obj).collator;
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(DynamicObject collatorObj, String one, String two) {
        Collator collator = JSCollator.getCollatorProperty(collatorObj);
        return collator.compare(JSCollator.normalize(one), JSCollator.normalize(two));
    }

    private static String normalize(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }

    @CompilerDirectives.TruffleBoundary
    public static int caseSensitiveCompare(DynamicObject collatorObj, String one, String two) {
        Collator collator = JSCollator.getCollatorProperty(collatorObj);
        String a = JSCollator.stripAccents(one);
        String b = JSCollator.stripAccents(two);
        return collator.compare(a, b);
    }

    private static String stripAccents(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder resultBuilder = new StringBuilder(JSCollator.normalize(input));
        JSCollator.stripLlAccents(resultBuilder);
        Pattern accentMatchingPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return accentMatchingPattern.matcher(resultBuilder).replaceAll("");
    }

    private static void stripLlAccents(StringBuilder s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\u0141') {
                s.setCharAt(i, 'L');
                continue;
            }
            if (s.charAt(i) != '\u0142') continue;
            s.setCharAt(i, 'l');
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject collatorObj) {
        InternalState state = JSCollator.getInternalState(collatorObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject collatorObj) {
        assert (JSCollator.isJSCollator(collatorObj));
        return ((JSCollatorObject)collatorObj).getInternalState();
    }

    private static CallTarget createGetCompareCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> realmRef;
            @Node.Child
            private PropertySetNode setBoundObjectNode;
            private final BranchProfile errorBranch;
            {
                super(lang, sourceSection, frameDescriptor);
                this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
                this.errorBranch = BranchProfile.create();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] frameArgs = frame.getArguments();
                Object collatorObj = JSArguments.getThisObject(frameArgs);
                if (JSCollator.isJSCollator(collatorObj)) {
                    InternalState state = JSCollator.getInternalState((DynamicObject)collatorObj);
                    if (state == null || !state.initializedCollator) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("compare");
                    }
                    if (state.boundCompareFunction == null) {
                        DynamicObject compareFn;
                        if (this.realmRef == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                        }
                        JSRealm realm = this.realmRef.get();
                        if (state.sensitivity.equals("case")) {
                            JSFunctionData compareFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorCaseSensitiveCompare, c -> JSCollator.createCaseSensitiveCompareFunctionData(c));
                            compareFn = JSFunction.create(realm, compareFunctionData);
                        } else {
                            JSFunctionData compareFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorCompare, c -> JSCollator.createCompareFunctionData(c));
                            compareFn = JSFunction.create(realm, compareFunctionData);
                        }
                        this.setBoundObjectNode.setValue(compareFn, collatorObj);
                        state.boundCompareFunction = compareFn;
                    }
                    return state.boundCompareFunction;
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorTypeXExpected(JSCollator.CLASS_NAME);
            }
        });
    }

    private static JSFunctionData createCompareFunctionData(final JSContext context) {
        return JSFunctionData.createCallOnly(context, Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private PropertyGetNode getBoundObjectNode;
            @Node.Child
            private JSToStringNode toString1Node;
            @Node.Child
            private JSToStringNode toString2Node;
            {
                super(lang, sourceSection, frameDescriptor);
                this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
                this.toString1Node = JSToStringNode.create();
                this.toString2Node = JSToStringNode.create();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments));
                assert (JSCollator.isJSCollator(thisObj));
                int argumentCount = JSArguments.getUserArgumentCount(arguments);
                String one = argumentCount > 0 ? this.toString1Node.executeString(JSArguments.getUserArgument(arguments, 0)) : "undefined";
                String two = argumentCount > 1 ? this.toString2Node.executeString(JSArguments.getUserArgument(arguments, 1)) : "undefined";
                return JSCollator.compare(thisObj, one, two);
            }
        }), 2, "");
    }

    private static JSFunctionData createCaseSensitiveCompareFunctionData(final JSContext context) {
        return JSFunctionData.createCallOnly(context, Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private PropertyGetNode getBoundObjectNode;
            @Node.Child
            private JSToStringNode toString1Node;
            @Node.Child
            private JSToStringNode toString2Node;
            {
                super(lang, sourceSection, frameDescriptor);
                this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
                this.toString1Node = JSToStringNode.create();
                this.toString2Node = JSToStringNode.create();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments));
                assert (JSCollator.isJSCollator(thisObj));
                int argumentCount = JSArguments.getUserArgumentCount(arguments);
                String one = argumentCount > 0 ? this.toString1Node.executeString(JSArguments.getUserArgument(arguments, 0)) : "undefined";
                String two = argumentCount > 1 ? this.toString2Node.executeString(JSArguments.getUserArgument(arguments, 1)) : "undefined";
                return JSCollator.caseSensitiveCompare(thisObj, one, two);
            }
        }), 2, "");
    }

    private static DynamicObject createCompareFunctionGetter(JSRealm realm, JSContext context) {
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorGetCompare, c -> {
            CallTarget ct = JSCollator.createGetCompareCallTarget(context);
            return JSFunctionData.create(context, ct, ct, 0, "get compare", false, false, false, true);
        });
        return JSFunction.create(realm, fd);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getCollatorPrototype();
    }

    public static class InternalState {
        private boolean initializedCollator = false;
        private Collator collator;
        private DynamicObject boundCompareFunction = null;
        private String locale;
        private String usage = "sort";
        private String sensitivity = "variant";
        private String collation = "default";
        private boolean ignorePunctuation = false;
        private boolean numeric = false;
        private String caseFirst = "false";

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSOrdinary.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "usage", this.usage, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "sensitivity", this.sensitivity, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "ignorePunctuation", this.ignorePunctuation, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "collation", this.collation, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "numeric", this.numeric, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "caseFirst", this.caseFirst, JSAttributes.getDefault());
            return result;
        }
    }
}

