/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSWebAssemblyInstance
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Instance";
    public static final String EXPORTS = "exports";
    public static final JSWebAssemblyInstance INSTANCE = new JSWebAssemblyInstance();

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSWebAssemblyInstance(Object object) {
        return object instanceof JSWebAssemblyInstanceObject;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, constructor);
        JSObjectUtil.putAccessorProperty(ctx, prototype, EXPORTS, JSWebAssemblyInstance.createExportsGetterFunction(realm), Undefined.instance, JSAttributes.configurableEnumerableWritable());
        JSObjectUtil.putToStringTag(prototype, "WebAssembly.Instance");
        return prototype;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyInstancePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, Object wasmInstance, Object wasmModule) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getWebAssemblyInstanceFactory();
        Object exportsObject = JSWebAssemblyInstance.createExportsObject(context, wasmInstance, wasmModule);
        JSWebAssemblyInstanceObject object = new JSWebAssemblyInstanceObject(factory.getShape(realm), wasmInstance, exportsObject);
        factory.initProto(object, realm);
        return context.trackAllocation(object);
    }

    private static DynamicObject createExportsGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblyInstanceGetExports, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    if (JSWebAssemblyInstance.isJSWebAssemblyInstance(thiz)) {
                        return ((JSWebAssemblyInstanceObject)thiz).getExports();
                    }
                    throw Errors.createTypeError("WebAssembly.Instance.exports(): Receiver is not a WebAssembly.Instance", (Node)this);
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get exports");
        });
        return JSFunction.create(realm, getterData);
    }

    private static Object createExportsObject(JSContext context, Object wasmInstance, Object wasmModule) {
        DynamicObject exports = JSOrdinary.createWithNullPrototype(context);
        try {
            Object exportsFunction = context.getRealm().getWASMModuleExportsFunction();
            Object exportsInfo = InteropLibrary.getUncached(exportsFunction).execute(exportsFunction, wasmModule);
            Object wasmExports = InteropLibrary.getUncached(wasmInstance).readMember(wasmInstance, EXPORTS);
            InteropLibrary wasmExportsInterop = InteropLibrary.getUncached(wasmExports);
            InteropLibrary exportsInterop = InteropLibrary.getUncached(exportsInfo);
            long size = exportsInterop.getArraySize(exportsInfo);
            for (long i = 0L; i < size; ++i) {
                Object value;
                Object exportInfo = exportsInterop.readArrayElement(exportsInfo, i);
                InteropLibrary exportInterop = InteropLibrary.getUncached(exportInfo);
                String name = (String)exportInterop.readMember(exportInfo, "name");
                String externtype = (String)exportInterop.readMember(exportInfo, "kind");
                Object externval = wasmExportsInterop.readMember(wasmExports, name);
                if ("function".equals(externtype)) {
                    String typeInfo = (String)exportInterop.readMember(exportInfo, "type");
                    value = JSWebAssemblyInstance.exportFunction(context, externval, typeInfo);
                } else if ("global".equals(externtype)) {
                    String valueType = (String)exportInterop.readMember(exportInfo, "type");
                    value = JSWebAssemblyGlobal.create(context, externval, valueType);
                } else if ("memory".equals(externtype)) {
                    value = JSWebAssemblyMemory.create(context, externval);
                } else {
                    assert ("table".equals(externtype));
                    value = JSWebAssemblyTable.create(context, externval);
                }
                JSObject.set(exports, name, value);
            }
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
        JSObject.setIntegrityLevel(exports, true);
        return exports;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object exportFunction(JSContext context, final Object export, String typeInfo) {
        int idxOpen = typeInfo.indexOf(40);
        int idxClose = typeInfo.indexOf(41);
        String name = typeInfo.substring(0, idxOpen);
        final String argTypes = typeInfo.substring(idxOpen + 1, idxClose);
        final String returnType = typeInfo.substring(idxClose + 1);
        final int argCount = argTypes.length() / 3;
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            ToWebAssemblyValueNode toWebAssemblyValueNode;
            @Node.Child
            ToJSValueNode toJSValueNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.toWebAssemblyValueNode = ToWebAssemblyValueNode.create();
                this.toJSValueNode = ToJSValueNode.create();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                if ("i64".equals(returnType)) {
                    throw Errors.createTypeError("Return type is i64");
                }
                if (argTypes.indexOf("i64") != -1) {
                    throw Errors.createTypeError("Argument type is i64");
                }
                Object[] frameArguments = frame.getArguments();
                int userArgumentCount = JSArguments.getUserArgumentCount(frameArguments);
                Object[] wasmArgs = new Object[argCount];
                for (int i = 0; i < argCount; ++i) {
                    Object wasmArg = i < userArgumentCount ? JSArguments.getUserArgument(frameArguments, i) : Undefined.instance;
                    wasmArgs[i] = this.toWebAssemblyValueNode.execute(wasmArg, argTypes.substring(3 * i, 3 * (i + 1)));
                }
                try {
                    Object wasmResult;
                    try {
                        wasmResult = InteropLibrary.getUncached(export).execute(export, wasmArgs);
                    }
                    catch (GraalJSException jsex) {
                        throw jsex;
                    }
                    catch (AbstractTruffleException tex) {
                        ExceptionType type = InteropLibrary.getUncached(tex).getExceptionType(tex);
                        if (type == ExceptionType.INTERRUPT || type == ExceptionType.EXIT) {
                            throw tex;
                        }
                        throw Errors.createRuntimeError(tex, this);
                    }
                    if (returnType.isEmpty()) {
                        return Undefined.instance;
                    }
                    return this.toJSValueNode.execute(wasmResult);
                }
                catch (InteropException ex) {
                    throw Errors.shouldNotReachHere(ex);
                }
            }
        });
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, callTarget, argCount, name);
        DynamicObject result = JSFunction.create(context.getRealm(), functionData);
        JSObjectUtil.putHiddenProperty(result, JSWebAssembly.FUNCTION_ADDRESS, export);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object transformImportObject(JSContext context, Object wasmModule, Object importObject) {
        try {
            TruffleObject truffleImportObject = (TruffleObject)importObject;
            DynamicObject transformedImportObject = JSOrdinary.create(context);
            Object importsFn = context.getRealm().getWASMModuleImportsFunction();
            Object imports = InteropLibrary.getUncached(importsFn).execute(importsFn, wasmModule);
            InteropLibrary importsInterop = InteropLibrary.getUncached(imports);
            long size = importsInterop.getArraySize(imports);
            for (long i = 0L; i < size; ++i) {
                DynamicObject transformedModule;
                Object wasmValue;
                Object descriptor = importsInterop.readArrayElement(imports, i);
                InteropLibrary descriptorInterop = InteropLibrary.getUncached(descriptor);
                Object module = descriptorInterop.readMember(descriptor, "module");
                Object moduleImportObject = JSObject.get(truffleImportObject, module);
                if (!(moduleImportObject instanceof TruffleObject)) {
                    throw Errors.createTypeErrorNotAnObject(moduleImportObject);
                }
                Object name = descriptorInterop.readMember(descriptor, "name");
                Object value = JSObject.get((TruffleObject)moduleImportObject, name);
                Object externType = descriptorInterop.readMember(descriptor, "kind");
                if ("function".equals(externType)) {
                    if (!JSRuntime.isCallable(value)) {
                        throw Errors.createLinkError("Imported value is not callable");
                    }
                    String typeInfo = (String)descriptorInterop.readMember(descriptor, "type");
                    wasmValue = JSWebAssemblyInstance.createHostFunction(context, value, typeInfo);
                } else if ("global".equals(externType)) {
                    if (JSRuntime.isNumber(value)) {
                        String valueType = (String)descriptorInterop.readMember(descriptor, "type");
                        if ("i64".equals(valueType)) {
                            throw Errors.createLinkError("Can't import the value of i64 WebAssembly.Global");
                        }
                        Object webAssemblyValue = JSWebAssemblyInstance.toWebAssemblyValue(value, valueType);
                        try {
                            Object createGlobal = context.getRealm().getWASMGlobalConstructor();
                            wasmValue = InteropLibrary.getUncached(createGlobal).execute(createGlobal, valueType, false, webAssemblyValue);
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    } else {
                        if (!JSWebAssemblyGlobal.isJSWebAssemblyGlobal(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Global object");
                        wasmValue = ((JSWebAssemblyGlobalObject)value).getWASMGlobal();
                    }
                } else if ("memory".equals(externType)) {
                    if (!JSWebAssemblyMemory.isJSWebAssemblyMemory(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Memory object");
                    wasmValue = ((JSWebAssemblyMemoryObject)value).getWASMMemory();
                } else {
                    assert ("table".equals(externType)) : externType;
                    if (!JSWebAssemblyTable.isJSWebAssemblyTable(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Table object");
                    wasmValue = ((JSWebAssemblyTableObject)value).getWASMTable();
                }
                if (JSObject.hasOwnProperty(transformedImportObject, module)) {
                    transformedModule = (DynamicObject)JSObject.get(transformedImportObject, module);
                } else {
                    transformedModule = JSOrdinary.create(context);
                    JSObject.set(transformedImportObject, module, (Object)transformedModule);
                }
                JSObject.set(transformedModule, name, wasmValue);
            }
            return transformedImportObject;
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    private static Object toWebAssemblyValue(Object value, String type) {
        assert (!"i64".equals(type));
        if ("i32".equals(type)) {
            return JSRuntime.toInt32(value);
        }
        double doubleValue = JSRuntime.toDouble(value);
        if ("f32".equals(type)) {
            return Float.valueOf((float)doubleValue);
        }
        assert ("f64".equals(type));
        return doubleValue;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createHostFunction(JSContext context, final Object fn, String typeInfo) {
        assert (JSRuntime.isCallable(fn));
        int idxOpen = typeInfo.indexOf(40);
        int idxClose = typeInfo.indexOf(41);
        String name = typeInfo.substring(0, idxOpen);
        final String argTypes = typeInfo.substring(idxOpen + 1, idxClose);
        final String returnType = typeInfo.substring(idxClose + 1);
        int argCount = argTypes.length() / 3;
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            ToWebAssemblyValueNode toWebAssemblyValueNode;
            @Node.Child
            ToJSValueNode toJSValueNode;
            @Node.Child
            JSFunctionCallNode callNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.toWebAssemblyValueNode = ToWebAssemblyValueNode.create();
                this.toJSValueNode = ToJSValueNode.create();
                this.callNode = JSFunctionCallNode.createCall();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                if ("i64".equals(returnType)) {
                    throw Errors.createTypeError("Return type is i64");
                }
                if (argTypes.indexOf("i64") != -1) {
                    throw Errors.createTypeError("Argument type is i64");
                }
                Object[] frameArguments = frame.getArguments();
                int userArgumentCount = JSArguments.getUserArgumentCount(frameArguments);
                Object[] jsArgs = new Object[userArgumentCount];
                for (int i = 0; i < userArgumentCount; ++i) {
                    jsArgs[i] = this.toJSValueNode.execute(JSArguments.getUserArgument(frameArguments, i));
                }
                Object result = this.callNode.executeCall(JSArguments.create(Undefined.instance, fn, jsArgs));
                if (returnType.isEmpty()) {
                    return Undefined.instance;
                }
                return this.toWebAssemblyValueNode.execute(result, returnType);
            }
        });
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, callTarget, argCount, name);
        return JSFunction.create(context.getRealm(), functionData);
    }
}

