/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyTablePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public class JSWebAssemblyTable
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final int MAX_TABLE_SIZE = 10000000;
    public static final String CLASS_NAME = "Table";
    public static final String PROTOTYPE_NAME = "Table.prototype";
    public static final String LENGTH = "length";
    public static final JSWebAssemblyTable INSTANCE = new JSWebAssemblyTable();

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSWebAssemblyTable(Object object) {
        return object instanceof JSWebAssemblyTableObject;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WebAssemblyTablePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorProperty(ctx, prototype, LENGTH, JSWebAssemblyTable.createLengthGetterFunction(realm), null, JSAttributes.configurableEnumerableWritable());
        JSObjectUtil.putToStringTag(prototype, "WebAssembly.Table");
        return prototype;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyTablePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyTableObject create(JSContext context, Object wasmTable) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getWebAssemblyTableFactory();
        JSWebAssemblyTableObject object = new JSWebAssemblyTableObject(factory.getShape(realm), wasmTable);
        factory.initProto(object, realm);
        return context.trackAllocation(object);
    }

    private static DynamicObject createLengthGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblyTableGetLength, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    if (JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                        Object wasmTable = ((JSWebAssemblyTableObject)thiz).getWASMTable();
                        try {
                            return InteropLibrary.getUncached(wasmTable).readMember(wasmTable, JSWebAssemblyTable.LENGTH);
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    }
                    throw Errors.createTypeError("WebAssembly.Table.length(): Receiver is not a WebAssembly.Table", (Node)this);
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get length");
        });
        return JSFunction.create(realm, getterData);
    }
}

