/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.StrongKeyWeakValueEntry;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;

final class TransitionMap<K, V>
implements Map<K, V> {
    private final EconomicMap<K, StrongKeyWeakValueEntry<K, V>> map = EconomicMap.create();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    TransitionMap() {
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    private V getValue(StrongKeyWeakValueEntry<K, V> entry) {
        return entry == null ? null : (V)entry.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            return this.getValue((StrongKeyWeakValueEntry)this.map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue(this.map.put(key, new StrongKeyWeakValueEntry<K, V>(key, value, this.queue)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue(this.map.removeKey(key));
        }
    }

    private void expungeStaleEntries() {
        Reference<V> x;
        while ((x = this.queue.poll()) != null) {
            StrongKeyWeakValueEntry ex = (StrongKeyWeakValueEntry)x;
            if (this.map.get(ex.getKey()) != ex) continue;
            this.map.removeKey(ex.getKey());
            ShapeImpl.shapeCacheExpunged.inc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            while (this.queue.poll() != null) {
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            UnmodifiableMapCursor cursor = this.map.getEntries();
            while (cursor.advance()) {
                Object value = ((StrongKeyWeakValueEntry)cursor.getValue()).get();
                if (value == null) continue;
                consumer.accept(cursor.getKey(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R iterateEntries(BiFunction<? super K, ? super V, R> consumer) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            UnmodifiableMapCursor cursor = this.map.getEntries();
            while (cursor.advance()) {
                R result;
                Object value = ((StrongKeyWeakValueEntry)cursor.getValue()).get();
                if (value == null || (result = consumer.apply(cursor.getKey(), value)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

