/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.FinalIntMap;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.ImageBuildTimeOptions;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.ObjectSizeCalculator;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotBindingsValue;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextThreadLocal;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotParsedEval;
import com.oracle.truffle.polyglot.PolyglotStackFramesRetriever;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotThreadLocalActions;
import com.oracle.truffle.polyglot.PolyglotValue;
import com.oracle.truffle.polyglot.ProcessHandlers;
import com.oracle.truffle.polyglot.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotContextImpl
extends AbstractPolyglotImpl.AbstractContextImpl
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotContextImpl.class);
    private static final InteropLibrary UNCACHED = InteropLibrary.getFactory().getUncached();
    private static final Object[] DISPOSED_CONTEXT_THREAD_LOCALS = new Object[0];
    @CompilerDirectives.CompilationFinal
    static SingleContextState singleContextState = new SingleContextState(null);
    final Assumption singleThreaded = Truffle.getRuntime().createAssumption("Single threaded");
    private final Map<Thread, PolyglotThreadInfo> threads = new WeakHashMap<Thread, PolyglotThreadInfo>();
    volatile PolyglotThreadInfo cachedThreadInfo = PolyglotThreadInfo.NULL;
    volatile boolean interrupting;
    volatile boolean cancelling;
    volatile boolean cancelled;
    volatile String invalidMessage;
    volatile boolean invalidResourceLimit;
    volatile Thread closingThread;
    private final ReentrantLock closingLock = new ReentrantLock();
    volatile boolean closed;
    volatile boolean invalid;
    volatile boolean disposing;
    final PolyglotEngineImpl engine;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final PolyglotLanguageContext[] contexts;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final Object[] contextImpls;
    Context creatorApi;
    Context currentApi;
    final TruffleContext creatorTruffleContext;
    final TruffleContext currentTruffleContext;
    final PolyglotContextImpl parent;
    volatile Map<String, Value> polyglotBindings;
    volatile Value polyglotHostBindings;
    private final PolyglotBindings polyglotBindingsObject = new PolyglotBindings(this);
    final PolyglotLanguage creator;
    final Map<String, Object> creatorArguments;
    final ContextWeakReference weakReference;
    final Set<ProcessHandlers.ProcessDecorator> subProcesses;
    @CompilerDirectives.CompilationFinal
    PolyglotContextConfig config;
    @CompilerDirectives.CompilationFinal
    private volatile FinalIntMap languageIndexMap;
    private final List<PolyglotContextImpl> childContexts = new ArrayList<PolyglotContextImpl>();
    boolean inContextPreInitialization;
    List<Source> sourcesToInvalidate;
    final AtomicLong volatileStatementCounter = new AtomicLong();
    long statementCounter;
    final long statementLimit;
    private volatile Object contextBoundLoggers;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    Object[] contextLocals;
    volatile boolean localsCleared;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Object[] singleThreadContextLocals;
    private long currentThreadLocalSingleThreadID = -1L;
    private final ContextLocalsTL contextThreadLocals = new ContextLocalsTL();
    private ObjectSizeCalculator objectSizeCalculator;
    final PolyglotThreadLocalActions threadLocalActions;

    static Object resetSingleContextState(boolean reuse) {
        SingleContextState prev = singleContextState;
        singleContextState = new SingleContextState(reuse ? prev.singleContext : null);
        return prev;
    }

    static SingleContextState getSingleContextState() {
        return singleContextState;
    }

    static void restoreSingleContextState(Object state) {
        singleContextState = (SingleContextState)state;
    }

    static boolean isSingleContextAssumptionValid() {
        return singleContextState.singleContextAssumption.isValid();
    }

    private PolyglotContextImpl() {
        super(null);
        this.engine = null;
        this.contexts = null;
        this.contextImpls = null;
        this.creatorTruffleContext = null;
        this.currentTruffleContext = null;
        this.parent = null;
        this.polyglotHostBindings = null;
        this.polyglotBindings = null;
        this.creator = null;
        this.creatorArguments = null;
        this.weakReference = null;
        this.statementLimit = 0L;
        this.threadLocalActions = null;
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
    }

    PolyglotContextImpl(PolyglotEngineImpl engine, PolyglotContextConfig config) {
        super(engine.impl);
        this.parent = null;
        this.engine = engine;
        this.config = config;
        this.creator = null;
        this.creatorArguments = Collections.emptyMap();
        this.creatorTruffleContext = EngineAccessor.LANGUAGE.createTruffleContext(this, true);
        this.currentTruffleContext = EngineAccessor.LANGUAGE.createTruffleContext(this, false);
        this.weakReference = new ContextWeakReference(this);
        this.contextImpls = new Object[engine.contextLength];
        this.contexts = this.createContextArray();
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
        this.statementCounter = this.statementLimit = config.limits != null && config.limits.statementLimit != 0L ? config.limits.statementLimit : 0x7FFFFFFFFFFFFFFEL;
        this.volatileStatementCounter.set(this.statementLimit);
        this.threadLocalActions = new PolyglotThreadLocalActions(this);
        PolyglotEngineImpl.ensureInstrumentsCreated(config.getConfiguredInstruments());
        if (!config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, config.logLevels, this.getAllLoggers());
        }
        this.notifyContextCreated();
        PolyglotContextImpl.initializeStaticContext(this);
    }

    PolyglotContextImpl(PolyglotLanguageContext creator, Map<String, Object> langConfig) {
        super(creator.getEngine().impl);
        PolyglotContextImpl parent;
        this.parent = parent = creator.context;
        this.config = parent.config;
        this.engine = parent.engine;
        this.creator = creator.language;
        this.creatorArguments = langConfig;
        this.statementLimit = 0L;
        this.weakReference = new ContextWeakReference(this);
        this.parent.addChildContext(this);
        this.creatorTruffleContext = EngineAccessor.LANGUAGE.createTruffleContext(this, true);
        this.currentTruffleContext = EngineAccessor.LANGUAGE.createTruffleContext(this, false);
        this.interrupting = parent.interrupting;
        this.invalid = this.parent.invalid;
        this.invalidMessage = this.parent.invalidMessage;
        this.cancelling = this.parent.cancelling;
        this.contextBoundLoggers = this.parent.contextBoundLoggers;
        this.threadLocalActions = new PolyglotThreadLocalActions(this);
        if (!parent.config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, parent.config.logLevels, this.getAllLoggers());
        }
        this.contextImpls = new Object[this.engine.contextLength];
        this.contexts = this.createContextArray();
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
        this.engine.noInnerContexts.invalidate();
        PolyglotContextImpl.initializeStaticContext(this);
    }

    OptionValues getInstrumentContextOptions(PolyglotInstrument instrument) {
        return this.config.getInstrumentOptionValues(instrument);
    }

    @Override
    public void resetLimits() {
        PolyglotLanguageContext languageContext = this.getHostContext();
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            PolyglotLimits.reset(this);
            EngineAccessor.INSTRUMENT.notifyContextResetLimit(this.engine, this.creatorTruffleContext);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    @Override
    public void safepoint() {
        PolyglotLanguageContext languageContext = this.getHostContext();
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            TruffleSafepoint.poll(this.engine.getUncachedLocation());
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    private PolyglotLanguageContext[] createContextArray() {
        PolyglotLanguageContext hostContext;
        Collection<PolyglotLanguage> languages = this.engine.idToLanguage.values();
        PolyglotLanguageContext[] newContexts = new PolyglotLanguageContext[this.engine.contextLength];
        Iterator<PolyglotLanguage> languageIterator = languages.iterator();
        newContexts[0] = hostContext = new PolyglotLanguageContext(this, this.engine.hostLanguage);
        for (int i = 1; i < this.engine.contextLength; ++i) {
            PolyglotLanguage language = languageIterator.next();
            newContexts[i] = new PolyglotLanguageContext(this, language);
        }
        hostContext.ensureInitialized(null);
        ((HostLanguage.HostContext)hostContext.getContextImpl()).initializeInternal(hostContext);
        return newContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    if (state.singleContext != null) {
                        state.singleContextAssumption.invalidate();
                        state.singleContext = null;
                    } else {
                        state.singleContext = context;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    assert (state.singleContext == context);
                    state.singleContext = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateStaticContextAssumption() {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    state.singleContextAssumption.invalidate();
                    state.singleContext = null;
                }
            }
        }
    }

    PolyglotLanguageContext getContext(PolyglotLanguage language) {
        return this.contexts[language.index];
    }

    Object getContextImpl(PolyglotLanguage language) {
        Object contextImpl;
        assert (this.contextImpls.length == this.engine.contextLength);
        if (CompilerDirectives.inInterpreter()) {
            contextImpl = this.contextImpls[language.index];
        } else {
            CompilerAsserts.partialEvaluationConstant(language);
            contextImpl = EngineAccessor.RUNTIME.castArrayFixedLength(this.contextImpls, language.engine.contextLength)[language.index];
            Class<?> castClass = language.contextClass;
            contextImpl = EngineAccessor.RUNTIME.unsafeCast(contextImpl, castClass, true, castClass != Void.class, true);
        }
        assert (language.contextClass == (contextImpl == null ? Void.class : contextImpl.getClass())) : "Instable context class: " + language.contextClass + " vs. " + (contextImpl == null ? Void.class : contextImpl.getClass());
        return contextImpl;
    }

    PolyglotLanguageContext getContextInitialized(PolyglotLanguage language, PolyglotLanguage accessingLanguage) {
        PolyglotLanguageContext context = this.getContext(language);
        context.ensureInitialized(accessingLanguage);
        return context;
    }

    void notifyContextCreated() {
        EngineAccessor.INSTRUMENT.notifyContextCreated(this.engine, this.creatorTruffleContext);
    }

    private synchronized void addChildContext(PolyglotContextImpl child) {
        if (this.closingThread != null) {
            throw PolyglotEngineException.illegalState("Adding child context into a closing context.");
        }
        this.childContexts.add(child);
    }

    static PolyglotContextImpl currentNotEntered() {
        SingleContextState singleContext = singleContextState;
        PolyglotContextImpl context = singleContext.singleContext;
        if (singleContext.singleContextAssumption.isValid()) {
            if (singleContext.contextThreadLocal.isSet()) {
                return context;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return null;
        }
        return (PolyglotContextImpl)singleContext.contextThreadLocal.get();
    }

    static PolyglotContextImpl currentEntered(PolyglotEngineImpl enteredInEngine) {
        assert (enteredInEngine != null);
        CompilerAsserts.partialEvaluationConstant(enteredInEngine);
        SingleContextState state = singleContextState;
        Object context = state.singleContext;
        if (!state.singleContextAssumption.isValid()) {
            context = state.contextThreadLocal.getEntered();
        }
        if (CompilerDirectives.inCompiledCode()) {
            return EngineAccessor.RUNTIME.unsafeCast(context, PolyglotContextImpl.class, true, true, true);
        }
        return context;
    }

    static PolyglotContextImpl requireContext() {
        PolyglotContextImpl context = PolyglotContextImpl.currentNotEntered();
        if (context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PolyglotEngineException.illegalState("There is no current context available.");
        }
        return context;
    }

    @Override
    public synchronized void explicitEnter(Context sourceContext) {
        try {
            this.checkCreatorAccess(sourceContext, "entered");
            PolyglotContextImpl prev = this.engine.enter(this, this.engine.getUncachedLocation(), true);
            PolyglotThreadInfo current = this.getCachedThreadInfo();
            assert (current.getThread() == Thread.currentThread());
            current.explicitContextStack.addLast(prev);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    @Override
    public synchronized void explicitLeave(Context sourceContext) {
        if (this.closed || this.closingThread == Thread.currentThread()) {
            return;
        }
        try {
            this.checkCreatorAccess(sourceContext, "left");
            PolyglotThreadInfo current = this.getCachedThreadInfo();
            LinkedList<PolyglotContextImpl> stack = current.explicitContextStack;
            if (stack.isEmpty() || current.getThread() == null) {
                throw PolyglotEngineException.illegalState("The context is not entered explicity. A context can only be left if it was previously entered.");
            }
            this.engine.leave(stack.removeLast(), this);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    private void checkCreatorAccess(Context context, String operation) {
        if (context != this.creatorApi) {
            throw PolyglotEngineException.illegalState(String.format("Context instances that were received using Context.get() cannot be %s.", operation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotContextImpl enterThreadChanged(Node safepointLocation, boolean enterReverted, boolean pollSafepoint) {
        PolyglotContextImpl polyglotContextImpl;
        block27: {
            PolyglotThreadInfo enteredThread = null;
            PolyglotContextImpl prev = null;
            try {
                Thread current = Thread.currentThread();
                boolean needsInitialization = false;
                polyglotContextImpl = this;
                synchronized (polyglotContextImpl) {
                    boolean transitionToMultiThreading;
                    PolyglotThreadInfo threadInfo = this.getCachedThreadInfo();
                    if (enterReverted && threadInfo.getEnteredCount() == 0) {
                        this.threadLocalActions.notifyThreadActivation(threadInfo, false);
                    }
                    this.checkClosed();
                    assert (threadInfo != null);
                    threadInfo = this.threads.get(current);
                    if (threadInfo == null) {
                        threadInfo = this.createThreadInfo(current);
                        needsInitialization = true;
                    }
                    boolean bl = transitionToMultiThreading = this.singleThreaded.isValid() && this.hasActiveOtherThread(true);
                    if (transitionToMultiThreading) {
                        this.checkAllThreadAccesses(Thread.currentThread(), false);
                    }
                    if (transitionToMultiThreading) {
                        this.engine.singleThreadPerContext.invalidate();
                    }
                    Thread closing = this.closingThread;
                    if (needsInitialization) {
                        if (closing != null && closing != current) {
                            throw PolyglotEngineException.illegalState("Can not create new threads in closing context.", true);
                        }
                        this.threads.put(current, threadInfo);
                    }
                    if (needsInitialization) {
                        this.initializeThreadLocals(threadInfo);
                    }
                    prev = threadInfo.enterInternal();
                    try {
                        threadInfo.notifyEnter(this.engine, this);
                    }
                    catch (Throwable t) {
                        threadInfo.leaveInternal(prev);
                        throw t;
                    }
                    enteredThread = threadInfo;
                    if (needsInitialization) {
                        this.threadLocalActions.notifyEnterCreatedThread();
                    }
                    if (enteredThread.getEnteredCount() == 1) {
                        this.threadLocalActions.notifyThreadActivation(threadInfo, true);
                    }
                    if (transitionToMultiThreading) {
                        this.transitionToMultiThreaded();
                    }
                    if (needsInitialization) {
                        this.initializeNewThread(current);
                    }
                    this.setCachedThreadInfo(threadInfo);
                }
                if (needsInitialization) {
                    EngineAccessor.INSTRUMENT.notifyThreadStarted(this.engine, this.creatorTruffleContext, current);
                }
                polyglotContextImpl = prev;
                if (!pollSafepoint) break block27;
            }
            catch (Throwable throwable) {
                if (pollSafepoint) {
                    try {
                        TruffleSafepoint.pollHere(safepointLocation);
                    }
                    catch (Throwable t) {
                        if (enteredThread != null) {
                            this.engine.leave(prev, this);
                        }
                        throw t;
                    }
                }
                throw throwable;
            }
            try {
                TruffleSafepoint.pollHere(safepointLocation);
            }
            catch (Throwable t) {
                if (enteredThread != null) {
                    this.engine.leave(prev, this);
                }
                throw t;
            }
        }
        return polyglotContextImpl;
    }

    void setCachedThreadInfo(PolyglotThreadInfo info) {
        assert (Thread.holdsLock(this));
        this.cachedThreadInfo = this.closed || this.closingThread != null || this.invalid || this.interrupting ? PolyglotThreadInfo.NULL : info;
    }

    synchronized void checkMultiThreadedAccess(PolyglotThread newThread) {
        boolean singleThread = this.singleThreaded.isValid() ? !this.isActiveNotCancelled() : false;
        this.checkAllThreadAccesses(newThread, singleThread);
    }

    private void checkAllThreadAccesses(Thread enteringThread, boolean singleThread) {
        assert (Thread.holdsLock(this));
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            boolean accessAllowed = true;
            if (!EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, enteringThread, singleThread)) {
                accessAllowed = false;
            }
            if (accessAllowed) {
                for (PolyglotThreadInfo seenThread : this.threads.values()) {
                    if (EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, seenThread.getThread(), singleThread)) continue;
                    accessAllowed = false;
                    break;
                }
            }
            if (accessAllowed) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(enteringThread, singleThread, deniedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotThreadInfo leaveThreadChanged(PolyglotContextImpl prev, boolean entered) {
        PolyglotThreadInfo info;
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            Thread current = Thread.currentThread();
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            PolyglotThreadInfo threadInfo = this.threads.get(current);
            assert (threadInfo != null);
            info = threadInfo;
            if (entered) {
                try {
                    info.notifyLeave(this.engine, this);
                }
                finally {
                    info.leaveInternal(prev);
                }
            }
            if (threadInfo.getEnteredCount() == 0) {
                this.threadLocalActions.notifyThreadActivation(threadInfo, false);
            }
            if (this.cancelling && !info.isActiveNotCancelled()) {
                this.notifyThreadClosed();
            }
            if (!(this.closed || this.cancelling || this.invalid || this.interrupting)) {
                this.setCachedThreadInfo(threadInfo);
            }
            if (this.interrupting && !info.isActiveNotCancelled()) {
                Thread.interrupted();
                this.notifyAll();
            }
        }
        return info;
    }

    private void initializeNewThread(Thread thread) {
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            EngineAccessor.LANGUAGE.initializeThread(context.env, thread);
        }
    }

    long getStatementsExecuted() {
        long count = this.engine.singleThreadPerContext.isValid() ? this.statementCounter : this.volatileStatementCounter.get();
        return this.statementLimit - count;
    }

    private void transitionToMultiThreaded() {
        assert (this.singleThreaded.isValid());
        assert (Thread.holdsLock(this));
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            EngineAccessor.LANGUAGE.initializeMultiThreading(context.env);
        }
        this.singleThreaded.invalidate();
        long statementsExecuted = this.statementLimit - this.statementCounter;
        this.volatileStatementCounter.getAndAdd(-statementsExecuted);
    }

    private PolyglotThreadInfo createThreadInfo(Thread current) {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo threadInfo = new PolyglotThreadInfo(this, current);
        boolean singleThread = this.isSingleThreaded();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized() || EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, current, singleThread)) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, singleThread, deniedLanguages);
        }
        return threadInfo;
    }

    static RuntimeException throwDeniedThreadAccess(Thread current, boolean accessSingleThreaded, List<PolyglotLanguage> deniedLanguages) {
        StringBuilder languagesString = new StringBuilder("");
        for (PolyglotLanguage language : deniedLanguages) {
            if (languagesString.length() != 0) {
                languagesString.append(", ");
            }
            languagesString.append(language.getId());
        }
        String message = accessSingleThreaded ? String.format("Single threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString) : String.format("Multi threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString);
        throw PolyglotEngineException.illegalState(message);
    }

    Value findLegacyExportedSymbol(String symbolName) {
        Value legacySymbol = this.findLegacyExportedSymbol(symbolName, true);
        if (legacySymbol != null) {
            return legacySymbol;
        }
        return this.findLegacyExportedSymbol(symbolName, false);
    }

    private Value findLegacyExportedSymbol(String name, boolean onlyExplicit) {
        for (PolyglotLanguageContext languageContext : this.contexts) {
            Object s;
            if (!languageContext.isInitialized() || (s = EngineAccessor.LANGUAGE.findExportedSymbol(languageContext.env, name, onlyExplicit)) == null) continue;
            return languageContext.asValue(s);
        }
        return null;
    }

    @Override
    public Value getBindings(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        assert (languageContext != null);
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            if (!languageContext.isInitialized()) {
                languageContext.ensureInitialized(null);
            }
            Value value = languageContext.getHostBindings();
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    @Override
    public Value getPolyglotBindings() {
        try {
            this.checkClosed();
            Value bindings = this.polyglotHostBindings;
            if (bindings == null) {
                this.initPolyglotBindings();
                bindings = this.polyglotHostBindings;
            }
            return bindings;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.engine, e);
        }
    }

    public Map<String, Value> getPolyglotGuestBindings() {
        Map<String, Value> bindings = this.polyglotBindings;
        if (bindings == null) {
            this.initPolyglotBindings();
            bindings = this.polyglotBindings;
        }
        return bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPolyglotBindings() {
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            if (this.polyglotBindings == null) {
                this.polyglotBindings = new ConcurrentHashMap<String, Value>();
                PolyglotBindings bindings = new PolyglotBindings(this.getHostContext());
                this.polyglotHostBindings = this.getAPIAccess().newValue(bindings, new PolyglotBindingsValue(this.getHostContext(), bindings));
            }
        }
    }

    public Object getPolyglotBindingsObject() {
        return this.polyglotBindingsObject;
    }

    void checkClosed() {
        if (this.invalid && this.closingThread != Thread.currentThread() && this.invalidMessage != null) {
            throw this.createCancelException(null);
        }
        if (this.closed) {
            throw PolyglotEngineException.illegalState("The Context is already closed.");
        }
    }

    PolyglotLanguageContext getHostContext() {
        return this.contexts[0];
    }

    HostLanguage.HostContext getHostContextImpl() {
        return (HostLanguage.HostContext)this.getHostContext().getContextImpl();
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    PolyglotLanguageContext getLanguageContext(Class<? extends TruffleLanguage<?>> languageClass) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.getLanguageContextImpl(languageClass);
        }
        return this.getLanguageContextBoundary(languageClass);
    }

    @CompilerDirectives.TruffleBoundary
    private PolyglotLanguageContext getLanguageContextBoundary(Class<? extends TruffleLanguage<?>> languageClass) {
        return this.getLanguageContextImpl(languageClass);
    }

    PolyglotLanguageContext findLanguageContext(Class<? extends TruffleLanguage> languageClazz) {
        PolyglotLanguage directLanguage = this.engine.getLanguage(languageClazz, false);
        if (directLanguage != null) {
            return this.getContext(directLanguage);
        }
        for (PolyglotLanguageContext lang : this.contexts) {
            if (!lang.isInitialized()) continue;
            TruffleLanguage<?> language = EngineAccessor.LANGUAGE.getLanguage(lang.env);
            if (languageClazz == TruffleLanguage.class || !languageClazz.isInstance(language)) continue;
            return lang;
        }
        HashSet<String> languageNames = new HashSet<String>();
        for (PolyglotLanguageContext lang : this.contexts) {
            if (!lang.isInitialized()) continue;
            languageNames.add(lang.language.cache.getClassName());
        }
        throw PolyglotEngineException.illegalState("Cannot find language " + languageClazz + " among " + languageNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageContext getLanguageContextImpl(Class<? extends TruffleLanguage<?>> languageClass) {
        int indexValue;
        FinalIntMap map = this.languageIndexMap;
        int n = indexValue = map != null ? map.get(languageClass) : -1;
        if (indexValue == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                if (this.languageIndexMap == null) {
                    this.languageIndexMap = new FinalIntMap();
                }
                if ((indexValue = this.languageIndexMap.get(languageClass)) == -1) {
                    PolyglotLanguageContext context = this.findLanguageContext(languageClass);
                    indexValue = context.language.index;
                    this.languageIndexMap.put(languageClass, indexValue);
                }
            }
        }
        PolyglotLanguageContext context = this.contexts[indexValue];
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeInnerContextLanguage(String languageId) {
        PolyglotLanguage language = this.engine.idToLanguage.get(languageId);
        assert (language != null) : "language creating the inner context not be found";
        Object prev = this.engine.enterIfNeeded(this, true);
        try {
            this.initializeLanguage(language);
        }
        finally {
            this.engine.leaveIfNeeded(prev, this);
        }
    }

    private boolean initializeLanguage(PolyglotLanguage language) {
        PolyglotLanguageContext languageContext = this.getContext(language);
        assert (languageContext != null);
        languageContext.checkAccess(null);
        if (!languageContext.isInitialized()) {
            return languageContext.ensureInitialized(null);
        }
        return false;
    }

    @Override
    public boolean initializeLanguage(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            boolean bl = this.initializeLanguage(language);
            return bl;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    @Override
    public Value parse(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        assert (languageContext != null);
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            Source source = (Source)sourceImpl;
            languageContext.checkAccess(null);
            languageContext.ensureInitialized(null);
            CallTarget target = languageContext.parseCached(null, source, null);
            Value value = languageContext.asValue(new PolyglotParsedEval(languageContext, source, target));
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    @Override
    public Value eval(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        assert (languageContext != null);
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            Value hostValue;
            Source source = (Source)sourceImpl;
            languageContext.checkAccess(null);
            languageContext.ensureInitialized(null);
            CallTarget target = languageContext.parseCached(null, source, null);
            Object result = target.call(PolyglotImpl.EMPTY_ARGS);
            try {
                hostValue = languageContext.asValue(result);
            }
            catch (ClassCastException | NullPointerException e) {
                throw new AssertionError(String.format("Language %s returned an invalid return value %s. Must be an interop value.", languageId, result), e);
            }
            if (source.isInteractive()) {
                PolyglotContextImpl.printResult(languageContext, result);
            }
            Value value = hostValue;
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    private PolyglotLanguage requirePublicLanguage(String languageId) {
        PolyglotLanguage language = this.engine.idToLanguage.get(languageId);
        if (language == null || language.cache.isInternal()) {
            this.engine.requirePublicLanguage(languageId);
            assert (false);
            return null;
        }
        return language;
    }

    @CompilerDirectives.TruffleBoundary
    static void printResult(PolyglotLanguageContext languageContext, Object result) {
        String stringResult;
        if (!EngineAccessor.LANGUAGE.isVisible(languageContext.env, result)) {
            return;
        }
        try {
            stringResult = UNCACHED.asString(UNCACHED.toDisplayString(languageContext.getLanguageView(result), true));
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        try {
            OutputStream out = languageContext.context.config.out;
            out.write(stringResult.getBytes(StandardCharsets.UTF_8));
            out.write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioex) {
            throw new IllegalStateException(ioex);
        }
    }

    @Override
    public Engine getEngineImpl(Context sourceContext) {
        return sourceContext == this.creatorApi ? this.engine.creatorApi : this.engine.currentApi;
    }

    @Override
    public void close(Context sourceContext, boolean cancelIfExecuting) {
        try {
            this.checkCreatorAccess(sourceContext, "closed");
            if (cancelIfExecuting) {
                this.cancel(false, null, true);
            } else {
                this.closeAndMaybeWait(false);
            }
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    void cancel(boolean resourceLimit, String message, boolean wait) {
        boolean invalidated = this.invalidateAll(resourceLimit, message == null ? "Context execution was cancelled." : message);
        if (wait && invalidated && !this.closed) {
            this.closeAndMaybeWait(true);
        }
    }

    void closeAndMaybeWait(boolean cancelIfExecuting) {
        boolean closeCompleted = this.closeImpl(cancelIfExecuting, cancelIfExecuting, true);
        if (cancelIfExecuting) {
            this.engine.getCancelHandler().cancel(Arrays.asList(this));
        } else if (!closeCompleted) {
            throw PolyglotEngineException.illegalState(String.format("The context is currently executing on another thread. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
        }
        this.checkSubProcessFinished();
        if (this.engine.boundEngine && this.parent == null) {
            this.engine.ensureClosed(cancelIfExecuting, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInterruptForChildContexts() {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            this.interrupting = false;
            PolyglotContextImpl[] childContextsToInterrupt = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (PolyglotContextImpl childCtx : childContextsToInterrupt) {
                childCtx.finishInterruptForChildContexts();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptChildContexts() {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            PolyglotThreadInfo info = this.getCachedThreadInfo();
            if (info != PolyglotThreadInfo.NULL && info.isActive()) {
                throw PolyglotEngineException.illegalState("Cannot interrupt context from a thread where its child context is active.");
            }
            this.interrupting = true;
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            PolyglotContextImpl[] childContextsToInterrupt = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (PolyglotContextImpl childCtx : childContextsToInterrupt) {
                childCtx.interruptChildContexts();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean interrupt(Context sourceContext, Duration timeout) {
        try {
            this.checkCreatorAccess(sourceContext, "interrupted");
            if (this.parent != null) {
                throw PolyglotEngineException.illegalState("Cannot interrupt inner context separately.");
            }
            this.engine.neverInterrupted.invalidate();
            long startMillis = System.currentTimeMillis();
            boolean waitForCloseOrInterrupt = false;
            while (true) {
                if (waitForCloseOrInterrupt) {
                    this.closingLock.lock();
                    this.closingLock.unlock();
                    waitForCloseOrInterrupt = false;
                }
                PolyglotContextImpl[] polyglotContextImplArray = this;
                // MONITORENTER : this
                if (this.closed) {
                    // MONITOREXIT : polyglotContextImplArray
                    return true;
                }
                if (this.interrupting) {
                    waitForCloseOrInterrupt = true;
                    // MONITOREXIT : polyglotContextImplArray
                    continue;
                }
                Thread localClosingThread = this.closingThread;
                if (localClosingThread == null) break;
                if (localClosingThread == Thread.currentThread()) {
                    // MONITOREXIT : polyglotContextImplArray
                    return true;
                }
                waitForCloseOrInterrupt = true;
                // MONITOREXIT : polyglotContextImplArray
            }
            PolyglotThreadInfo info = this.getCachedThreadInfo();
            if (info != PolyglotThreadInfo.NULL && info.isActive()) {
                throw PolyglotEngineException.illegalState("Cannot interrupt context from a thread where the context is active.");
            }
            this.interrupting = true;
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            PolyglotContextImpl[] childContextsToInterrupt = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            this.closingLock.lock();
            // MONITOREXIT : polyglotContextImplArray
            try {
                for (PolyglotContextImpl childCtx : childContextsToInterrupt) {
                    childCtx.interruptChildContexts();
                }
                boolean bl = this.engine.getCancelHandler().cancel(Collections.singletonList(this), startMillis, timeout);
                return bl;
            }
            finally {
                try {
                    PolyglotContextImpl[] polyglotContextImplArray = this;
                }
                catch (Throwable throwable) {
                    this.closingLock.unlock();
                    throw throwable;
                }
            }
        }
        catch (Throwable thr) {
            throw PolyglotImpl.guestToHostException(this.engine, thr);
        }
    }

    @Override
    public Value asValue(Object hostValue) {
        PolyglotLanguageContext languageContext = this.getHostContext();
        assert (languageContext != null);
        Object prev = PolyglotValue.hostEnter(languageContext);
        try {
            PolyglotLanguageContext targetLanguageContext;
            this.checkClosed();
            if (hostValue instanceof Value) {
                PolyglotValue value = (PolyglotValue)this.getAPIAccess().getImpl((Value)hostValue);
                if (value.languageContext != null && value.languageContext.context == this) {
                    Value value2 = (Value)hostValue;
                    return value2;
                }
                targetLanguageContext = this.getHostContext();
            } else if (HostWrapper.isInstance(hostValue)) {
                targetLanguageContext = HostWrapper.asInstance(hostValue).getLanguageContext();
                if (this != targetLanguageContext.context) {
                    targetLanguageContext = this.getHostContext();
                }
            } else {
                targetLanguageContext = this.getHostContext();
            }
            Value value = targetLanguageContext.asValue(targetLanguageContext.toGuestValue(null, hostValue));
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.getHostContext(), e, true);
        }
        finally {
            PolyglotValue.hostLeave(languageContext, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForClose() {
        while (!this.closeImpl(false, true, true)) {
            try {
                PolyglotContextImpl polyglotContextImpl = this;
                synchronized (polyglotContextImpl) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForThreads(long startMillis, long timeoutMillis) {
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            long timeElapsed = System.currentTimeMillis() - startMillis;
            while (this.hasActiveOtherThread(true) && (timeoutMillis == 0L || timeElapsed < timeoutMillis)) {
                try {
                    if (timeoutMillis == 0L) {
                        this.wait();
                    } else {
                        this.wait(timeoutMillis - timeElapsed);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeElapsed = System.currentTimeMillis() - startMillis;
            }
            return !this.hasActiveOtherThread(true);
        }
    }

    boolean isSingleThreaded() {
        return this.singleThreaded.isValid();
    }

    Map<Thread, PolyglotThreadInfo> getSeenThreads() {
        assert (Thread.holdsLock(this));
        return this.threads;
    }

    boolean isActiveNotCancelled() {
        return this.isActiveNotCancelled(true);
    }

    synchronized boolean isActiveNotCancelled(boolean includePolyglotThreads) {
        for (PolyglotThreadInfo seenTinfo : this.threads.values()) {
            if (!includePolyglotThreads && seenTinfo.isPolyglotThread(this) || !seenTinfo.isActiveNotCancelled()) continue;
            return true;
        }
        return false;
    }

    synchronized boolean isActive() {
        for (PolyglotThreadInfo seenTinfo : this.threads.values()) {
            if (!seenTinfo.isActive()) continue;
            return true;
        }
        return false;
    }

    synchronized boolean isActiveNotCancelled(Thread thread) {
        PolyglotThreadInfo info = this.threads.get(thread);
        if (info == null || info == PolyglotThreadInfo.NULL) {
            return false;
        }
        return info.isActiveNotCancelled();
    }

    synchronized boolean isActive(Thread thread) {
        PolyglotThreadInfo info = this.threads.get(thread);
        if (info == null || info == PolyglotThreadInfo.NULL) {
            return false;
        }
        return info.isActive();
    }

    PolyglotThreadInfo getFirstActiveOtherThread(boolean includePolyglotThreads) {
        assert (Thread.holdsLock(this));
        for (PolyglotThreadInfo otherInfo : this.threads.values()) {
            if (!includePolyglotThreads && otherInfo.isPolyglotThread(this) || otherInfo.isCurrent() || !otherInfo.isActiveNotCancelled()) continue;
            return otherInfo;
        }
        return null;
    }

    boolean hasActiveOtherThread(boolean includePolyglotThreads) {
        return this.getFirstActiveOtherThread(includePolyglotThreads) != null;
    }

    synchronized void notifyThreadClosed() {
        PolyglotThreadInfo currentTInfo = this.getCachedThreadInfo();
        if (currentTInfo != PolyglotThreadInfo.NULL) {
            currentTInfo.cancelled = true;
            Thread.interrupted();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long calculateHeapSize(long stopAtBytes, AtomicBoolean calculationCancelled) {
        try {
            ObjectSizeCalculator localObjectSizeCalculator;
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                localObjectSizeCalculator = this.objectSizeCalculator;
                if (localObjectSizeCalculator == null) {
                    this.objectSizeCalculator = localObjectSizeCalculator = new ObjectSizeCalculator();
                }
            }
            return localObjectSizeCalculator.calculateObjectSize(this.getContextHeapRoots(), stopAtBytes, calculationCancelled);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Polyglot context heap size calculation is not supported on current Truffle runtime.", e);
        }
    }

    Object[] getContextHeapRoots() {
        ArrayList<Object> heapRoots = new ArrayList<Object>();
        this.addRootPointersForContext(heapRoots);
        this.addRootPointersForStackFrames(heapRoots);
        return heapRoots.toArray();
    }

    private void addRootPointersForStackFrames(List<Object> heapRoots) {
        FrameInstance[][] frameInstances = PolyglotStackFramesRetriever.getStackFrames(this);
        for (int i = 0; i < frameInstances.length; ++i) {
            for (int j = 0; j < frameInstances[i].length; ++j) {
                heapRoots.add(frameInstances[i][j].getFrame(FrameInstance.FrameAccess.READ_ONLY));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRootPointersForContext(List<Object> heapRoots) {
        PolyglotContextImpl[] childContextStartPoints;
        heapRoots.add(this.contextImpls);
        if (this.polyglotBindings != null) {
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                if (this.polyglotBindings != null) {
                    for (Map.Entry entry : this.polyglotBindings.entrySet()) {
                        heapRoots.add(entry.getKey());
                        if (entry.getValue() == null) continue;
                        heapRoots.add(this.getAPIAccess().getReceiver((Value)entry.getValue()));
                    }
                }
            }
        }
        heapRoots.add(this.contextLocals);
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (polyglotContextImplArray) {
            for (PolyglotThreadInfo info : this.threads.values()) {
                heapRoots.add(info.getContextThreadLocals());
            }
            childContextStartPoints = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
        }
        for (PolyglotContextImpl childCtx : childContextStartPoints) {
            childCtx.addRootPointersForContext(heapRoots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelChildContexts() {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            this.cancelling = true;
            PolyglotContextImpl[] childContextsToCancel = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (PolyglotContextImpl childCtx : childContextsToCancel) {
                childCtx.cancelChildContexts();
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"})
    boolean closeImpl(boolean cancelIfExecuting, boolean waitForPolyglotThreads, boolean notifyInstruments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean childContextsClosed() {
        assert (Thread.holdsLock(this));
        for (PolyglotContextImpl childCtx : this.childContexts) {
            if (childCtx.closed) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChildContexts(boolean cancelIfExecuting, boolean waitForPolyglotThreads, boolean notifyInstruments) {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            PolyglotContextImpl[] childrenToClose = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (PolyglotContextImpl childContext : childrenToClose) {
                childContext.closeImpl(cancelIfExecuting, waitForPolyglotThreads, notifyInstruments);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PolyglotLanguageContext> disposeContext() {
        assert (!this.disposing);
        this.disposing = true;
        try {
            ArrayList<PolyglotLanguageContext> disposedContexts = new ArrayList<PolyglotLanguageContext>(this.contexts.length);
            Object object = this;
            synchronized (object) {
                for (int i = this.contexts.length - 1; i >= 0; --i) {
                    PolyglotLanguageContext context = this.contexts[i];
                    boolean disposed = context.dispose();
                    if (!disposed) continue;
                    disposedContexts.add(context);
                }
            }
            object = disposedContexts;
            return object;
        }
        finally {
            this.disposing = false;
        }
    }

    private void finalizeContext(boolean notifyInstruments) {
        boolean finalizationPerformed;
        do {
            finalizationPerformed = false;
            for (int i = this.contexts.length - 1; i >= 0; --i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (!context.isInitialized()) continue;
                finalizationPerformed |= context.finalizeContext(notifyInstruments);
            }
        } while (finalizationPerformed);
    }

    synchronized void sendInterrupt() {
        if (!this.cancelling && !this.interrupting) {
            return;
        }
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            if (threadInfo.isCurrent() || !threadInfo.isActiveNotCancelled()) continue;
            threadInfo.getThread().interrupt();
        }
    }

    Object getLocal(PolyglotLocals.LocalLocation l) {
        assert (l.engine == this.engine) : PolyglotContextImpl.invalidSharingError(this.engine, l.engine);
        return l.readLocal(this, this.contextLocals, false);
    }

    private Object[] getCurrentThreadLocals(PolyglotEngineImpl e) {
        Object[] locals;
        CompilerAsserts.partialEvaluationConstant(e);
        if (e.singleThreadPerContext.isValid()) {
            if (this.currentThreadLocalSingleThreadID == Thread.currentThread().getId()) {
                locals = this.singleThreadContextLocals;
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                locals = this.contextThreadLocals.get();
            }
        } else {
            locals = this.contextThreadLocals.get();
        }
        assert (locals != null) : "thread local not initialized.";
        if (CompilerDirectives.inCompiledCode()) {
            locals = EngineAccessor.RUNTIME.unsafeCast(locals, Object[].class, true, true, true);
        }
        PolyglotEngineImpl.StableLocalLocations locations = e.contextThreadLocalLocations;
        if (!locations.assumption.isValid() || locations.locations.length != locals.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            locals = this.updateThreadLocals();
        }
        return locals;
    }

    private void setCurrentThreadLocals(Object[] locals) {
        assert (Thread.holdsLock(this));
        if (this.engine.singleThreadPerContext.isValid()) {
            this.singleThreadContextLocals = locals;
            this.currentThreadLocalSingleThreadID = Thread.currentThread().getId();
        } else if (Thread.currentThread().getId() == this.currentThreadLocalSingleThreadID) {
            this.currentThreadLocalSingleThreadID = -1L;
            this.singleThreadContextLocals = null;
        }
        this.contextThreadLocals.set(locals);
        PolyglotThreadInfo info = this.threads.get(Thread.currentThread());
        assert (info != null) : "thread not yet initialized";
        assert (info.getContextThreadLocals() == locals) : "thread locals consistent";
    }

    private Object[] getThreadLocals(Thread thread) {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo threadInfo = this.threads.get(thread);
        if (threadInfo == null) {
            return null;
        }
        return threadInfo.getContextThreadLocals();
    }

    Object getThreadLocal(PolyglotLocals.LocalLocation l) {
        assert (l.engine == this.engine) : PolyglotContextImpl.invalidSharingError(this.engine, l.engine);
        if (CompilerDirectives.isPartialEvaluationConstant(l)) {
            return l.readLocal(this, this.getCurrentThreadLocals(l.engine), true);
        }
        return this.getThreadLocalBoundary(l);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getThreadLocalBoundary(PolyglotLocals.LocalLocation l) {
        return l.readLocal(this, this.getCurrentThreadLocals(l.engine), true);
    }

    @CompilerDirectives.TruffleBoundary
    synchronized Object getThreadLocal(PolyglotLocals.LocalLocation l, Thread t) {
        assert (l.engine == this.engine) : PolyglotContextImpl.invalidSharingError(this.engine, l.engine);
        Object[] threadLocals = this.getThreadLocals(t);
        if (threadLocals == null) {
            return null;
        }
        return l.readLocal(this, threadLocals, true);
    }

    void initializeThreadLocals(PolyglotThreadInfo threadInfo) {
        assert (Thread.holdsLock(this));
        assert (Thread.currentThread() == threadInfo.getThread()) : "thread locals must only be initialized on the current thread";
        PolyglotEngineImpl.StableLocalLocations locations = this.engine.contextThreadLocalLocations;
        Object[] locals = new Object[locations.locations.length];
        Thread thread = threadInfo.getThread();
        for (PolyglotInstrument instrument : this.engine.idToInstrument.values()) {
            if (!instrument.isCreated()) continue;
            this.invokeContextLocalsFactory(this.contextLocals, instrument.contextLocalLocations);
            this.invokeContextThreadFactory(locals, instrument.contextThreadLocalLocations, thread);
        }
        for (PolyglotLanguageContext language : this.contexts) {
            if (!language.isCreated()) continue;
            this.invokeContextLocalsFactory(this.contextLocals, language.getLanguageInstance().contextLocalLocations);
            this.invokeContextThreadFactory(locals, language.getLanguageInstance().contextThreadLocalLocations, thread);
        }
        threadInfo.setContextThreadLocals(locals);
        this.setCurrentThreadLocals(locals);
    }

    void initializeContextLocals() {
        assert (Thread.holdsLock(this));
        if (this.contextLocals != null) {
            return;
        }
        PolyglotEngineImpl.StableLocalLocations locations = this.engine.contextLocalLocations;
        Object[] locals = new Object[locations.locations.length];
        for (PolyglotInstrument instrument : this.engine.idToInstrument.values()) {
            if (!instrument.isCreated()) continue;
            this.invokeContextLocalsFactory(locals, instrument.contextLocalLocations);
        }
        assert (this.contextLocals == null);
        this.contextLocals = locals;
    }

    private synchronized Object[] updateThreadLocals() {
        assert (Thread.holdsLock(this));
        Object[] newThreadLocals = this.getThreadLocals(Thread.currentThread());
        this.setCurrentThreadLocals(newThreadLocals);
        return newThreadLocals;
    }

    void resizeContextThreadLocals(PolyglotEngineImpl.StableLocalLocations locations) {
        assert (Thread.holdsLock(this));
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            Object[] threadLocals = threadInfo.getContextThreadLocals();
            if (threadLocals.length >= locations.locations.length) continue;
            threadInfo.setContextThreadLocals(Arrays.copyOf(threadLocals, locations.locations.length));
        }
    }

    void resizeContextLocals(PolyglotEngineImpl.StableLocalLocations locations) {
        Thread.holdsLock(this);
        Object[] oldLocals = this.contextLocals;
        if (oldLocals != null) {
            if (oldLocals.length > locations.locations.length) {
                throw new AssertionError((Object)"Context locals array must never shrink.");
            }
            if (locations.locations.length > oldLocals.length) {
                this.contextLocals = Arrays.copyOf(oldLocals, locations.locations.length);
            }
        } else {
            this.contextLocals = new Object[locations.locations.length];
        }
    }

    void invokeContextLocalsFactory(Object[] locals, PolyglotLocals.LocalLocation[] locations) {
        assert (Thread.holdsLock(this));
        if (locations == null) {
            return;
        }
        try {
            for (int i = 0; i < locations.length; ++i) {
                PolyglotLocals.LocalLocation location = locations[i];
                if (locals[location.index] != null) continue;
                locals[location.index] = location.invokeFactory(this, null);
            }
        }
        catch (Throwable t) {
            for (int i = 0; i < locations.length; ++i) {
                locals[locations[i].index] = null;
            }
            throw t;
        }
    }

    void invokeContextThreadLocalFactory(PolyglotLocals.LocalLocation[] locations) {
        assert (Thread.holdsLock(this));
        if (locations == null) {
            return;
        }
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            this.invokeContextThreadFactory(threadInfo.getContextThreadLocals(), locations, threadInfo.getThread());
        }
    }

    private void invokeContextThreadFactory(Object[] threadLocals, PolyglotLocals.LocalLocation[] locations, Thread thread) {
        assert (Thread.holdsLock(this));
        if (locations == null) {
            return;
        }
        try {
            for (int i = 0; i < locations.length; ++i) {
                PolyglotLocals.LocalLocation location = locations[i];
                if (threadLocals[location.index] != null) continue;
                threadLocals[location.index] = location.invokeFactory(this, thread);
            }
        }
        catch (Throwable t) {
            for (int i = 0; i < locations.length; ++i) {
                threadLocals[locations[i].index] = null;
            }
            throw t;
        }
    }

    static String invalidSharingError(PolyglotEngineImpl expectedEngine, PolyglotEngineImpl actualEngine) {
        return String.format("Detected invaliding sharing of context locals between polyglot engines. Expected engine %s but was %s.", expectedEngine, actualEngine);
    }

    PolyglotThreadInfo getCachedThreadInfo() {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo currentTInfo = this.cachedThreadInfo;
        if (currentTInfo.getThread() != Thread.currentThread() && (currentTInfo = this.threads.get(Thread.currentThread())) == null) {
            currentTInfo = PolyglotThreadInfo.NULL;
        }
        assert (currentTInfo.getThread() == null || currentTInfo.getThread() == Thread.currentThread());
        return currentTInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean patch(PolyglotContextConfig newConfig) {
        CompilerAsserts.neverPartOfCompilation();
        this.config = newConfig;
        PolyglotContextImpl.initializeStaticContext(this);
        if (!newConfig.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, newConfig.logLevels, this.getAllLoggers());
        }
        PolyglotContextImpl prev = this.engine.enter(this, this.engine.getUncachedLocation(), true);
        try {
            for (int i = 1; i < this.contexts.length; ++i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (context.patch(newConfig)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.engine.leave(prev, this);
        }
        return true;
    }

    void replayInstrumentationEvents() {
        this.notifyContextCreated();
        for (PolyglotLanguageContext lc : this.contexts) {
            LanguageInfo language = lc.language.info;
            if (!lc.eventsEnabled || lc.env == null) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextCreate(this, this.creatorTruffleContext, language);
            EngineAccessor.INSTRUMENT.notifyLanguageContextCreated(this, this.creatorTruffleContext, language);
            if (!lc.isInitialized()) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextInitialize(this, this.creatorTruffleContext, language);
            EngineAccessor.INSTRUMENT.notifyLanguageContextInitialized(this, this.creatorTruffleContext, language);
            if (!lc.finalized) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextFinalized(this, this.creatorTruffleContext, language);
        }
    }

    synchronized void checkSubProcessFinished() {
        ProcessHandlers.ProcessDecorator[] processes;
        for (ProcessHandlers.ProcessDecorator process : processes = this.subProcesses.toArray(new ProcessHandlers.ProcessDecorator[this.subProcesses.size()])) {
            if (!process.isAlive()) continue;
            throw PolyglotEngineException.illegalState(String.format("The context has an alive sub-process %s created by %s.", process.getCommand(), process.getOwner().language.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolyglotContextImpl preInitialize(PolyglotEngineImpl engine) {
        PolyglotContextImpl polyglotContextImpl;
        Object object;
        FileSystems.PreInitializeContextFileSystem fs = new FileSystems.PreInitializeContextFileSystem();
        FileSystems.PreInitializeContextFileSystem internalFs = new FileSystems.PreInitializeContextFileSystem();
        EconomicSet<String> allowedLanguages = EconomicSet.create();
        allowedLanguages.addAll(engine.getLanguages().keySet());
        PolyglotContextConfig config = new PolyglotContextConfig(engine, System.out, System.err, System.in, false, PolyglotAccess.ALL, false, false, false, false, null, Collections.emptyMap(), allowedLanguages, Collections.emptyMap(), fs, internalFs, engine.logHandler, false, null, EnvironmentAccess.INHERIT, null, null, null, null);
        PolyglotContextImpl context = new PolyglotContextImpl(engine, config);
        Object object2 = engine.lock;
        synchronized (object2) {
            engine.addContext(context);
        }
        try {
            object2 = context;
            synchronized (object2) {
                context.initializeContextLocals();
            }
            context.sourcesToInvalidate = new ArrayList<Source>();
            String oldOption = engine.engineOptionValues.get(PolyglotEngineOptions.PreinitializeContexts);
            String newOption = ImageBuildTimeOptions.get("PreinitializeContexts");
            String optionValue = !oldOption.isEmpty() && !newOption.isEmpty() ? oldOption + "," + newOption : oldOption + newOption;
            HashSet<String> languagesToPreinitialize = new HashSet<String>();
            if (!optionValue.isEmpty()) {
                Collections.addAll(languagesToPreinitialize, optionValue.split(","));
            }
            for (PolyglotLanguage language : engine.idToLanguage.values()) {
                if (language.isFirstInstance()) continue;
                languagesToPreinitialize.add(language.getId());
            }
            if (!languagesToPreinitialize.isEmpty()) {
                context.inContextPreInitialization = true;
                try {
                    PolyglotContextImpl prev = context.engine.enter(context, context.engine.getUncachedLocation(), true);
                    try {
                        for (String languageId : engine.getLanguages().keySet()) {
                            PolyglotLanguage language;
                            if (languagesToPreinitialize.contains(languageId) && (language = engine.findLanguage(null, languageId, null, false, true)) != null) {
                                if (PolyglotContextImpl.overridesPatchContext(languageId)) {
                                    context.getContextInitialized(language, null);
                                    LOG.log(Level.FINE, "Pre-initialized context for language: {0}", language.getId());
                                } else if (language.isFirstInstance()) {
                                    LOG.log(Level.WARNING, "Language {0} cannot be pre-initialized as it does not override TruffleLanguage.patchContext method.", languageId);
                                }
                            }
                            language = engine.idToLanguage.get(languageId);
                            language.clearOptionValues();
                        }
                    }
                    finally {
                        object = context;
                        synchronized (object) {
                            context.leaveAndDisposeThread(prev, Thread.currentThread());
                        }
                    }
                }
                finally {
                    context.inContextPreInitialization = false;
                }
            }
            context.cachedThreadInfo = PolyglotThreadInfo.NULL;
            PolyglotContextImpl.disposeStaticContext(context);
            polyglotContextImpl = context;
            object = engine.lock;
        }
        catch (Throwable throwable) {
            Iterator<Source> iterator = engine.lock;
            synchronized (iterator) {
                engine.removeContext(context);
            }
            for (Source sourceToInvalidate : context.sourcesToInvalidate) {
                EngineAccessor.SOURCE.invalidateAfterPreinitialiation(sourceToInvalidate);
            }
            context.sourcesToInvalidate = null;
            fs.onPreInitializeContextEnd();
            internalFs.onPreInitializeContextEnd();
            FileSystems.resetDefaultFileSystemProvider();
            if (!config.logLevels.isEmpty()) {
                EngineAccessor.LANGUAGE.configureLoggers(context, null, context.getAllLoggers());
            }
            throw throwable;
        }
        synchronized (object) {
            engine.removeContext(context);
        }
        for (Source sourceToInvalidate : context.sourcesToInvalidate) {
            EngineAccessor.SOURCE.invalidateAfterPreinitialiation(sourceToInvalidate);
        }
        context.sourcesToInvalidate = null;
        fs.onPreInitializeContextEnd();
        internalFs.onPreInitializeContextEnd();
        FileSystems.resetDefaultFileSystemProvider();
        if (!config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(context, null, context.getAllLoggers());
        }
        return polyglotContextImpl;
    }

    void leaveAndDisposeThread(PolyglotContextImpl prev, Thread thread) {
        assert (Thread.holdsLock(this));
        assert (Thread.currentThread() == thread);
        Map<Thread, PolyglotThreadInfo> seenThreads = this.getSeenThreads();
        PolyglotThreadInfo info = seenThreads.get(thread);
        if (info == null) {
            return;
        }
        for (PolyglotLanguageContext languageContext : this.contexts) {
            if (!languageContext.isInitialized()) continue;
            EngineAccessor.LANGUAGE.disposeThread(languageContext.env, thread);
        }
        this.engine.leave(prev, this);
        info.setContextThreadLocals(DISPOSED_CONTEXT_THREAD_LOCALS);
        this.setCurrentThreadLocals(DISPOSED_CONTEXT_THREAD_LOCALS);
        seenThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOrCreateContextLoggers() {
        Object res = this.contextBoundLoggers;
        if (res == null) {
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                res = this.contextBoundLoggers;
                if (res == null) {
                    this.contextBoundLoggers = res = EngineAccessor.LANGUAGE.createEngineLoggers(PolyglotLoggers.LoggerCache.newContextLoggerCache(this), this.config.logLevels);
                }
            }
        }
        return res;
    }

    private Object[] getAllLoggers() {
        Object defaultLoggers = EngineAccessor.LANGUAGE.getDefaultLoggers();
        Object engineLoggers = this.engine.getEngineLoggers();
        Object contextLoggers = this.contextBoundLoggers;
        ArrayList<Object> allLoggers = new ArrayList<Object>(3);
        allLoggers.add(defaultLoggers);
        if (engineLoggers != null) {
            allLoggers.add(engineLoggers);
        }
        if (contextLoggers != null) {
            allLoggers.add(contextLoggers);
        }
        return allLoggers.toArray(new Object[allLoggers.size()]);
    }

    PolyglotEngineImpl.CancelExecution createCancelException(Node location) {
        return new PolyglotEngineImpl.CancelExecution(location, this.invalidMessage, this.invalidResourceLimit);
    }

    synchronized boolean invalidate(boolean resourceLimit, String message) {
        assert (message != null);
        if (!this.invalid) {
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            this.invalidMessage = message;
            this.invalidResourceLimit = resourceLimit;
            this.invalid = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invalidateAll(boolean resourceLimit, String message) {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            boolean invalidated = this.invalidate(resourceLimit, message);
            PolyglotContextImpl[] childContextsToInvalidate = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (PolyglotContextImpl childCtx : childContextsToInvalidate) {
                invalidated = childCtx.invalidateAll(resourceLimit, this.invalidMessage) || invalidated;
            }
            return invalidated;
        }
    }

    private static boolean overridesPatchContext(String languageId) {
        LanguageCache cache = LanguageCache.languages().get(languageId);
        for (Method m : cache.loadLanguage().getClass().getDeclaredMethods()) {
            if (!m.getName().equals("patchContext")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PolyglotContextImpl[");
        b.append("state=");
        if (this.closed) {
            b.append("closed");
            if (this.invalid) {
                b.append(" invalid");
            }
        } else if (this.cancelling) {
            b.append("cancelling");
        } else if (this.isActive()) {
            b.append("active");
        } else {
            b.append("inactive");
        }
        b.append(" languages=[");
        String sep = "";
        for (PolyglotLanguageContext languageContext : this.contexts) {
            if (!languageContext.isInitialized() && !languageContext.isCreated()) continue;
            b.append(sep);
            b.append(languageContext.language.getId());
            sep = ", ";
        }
        b.append("]");
        b.append("]");
        return b.toString();
    }

    final class ContextLocalsTL
    extends ThreadLocal<Object[]> {
        ContextLocalsTL() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] get() {
            return (Object[])super.get();
        }
    }

    static class ContextWeakReference
    extends WeakReference<PolyglotContextImpl> {
        volatile boolean removed = false;
        final List<PolyglotLanguageInstance> freeInstances = new ArrayList<PolyglotLanguageInstance>();

        ContextWeakReference(PolyglotContextImpl referent) {
            super(referent, referent.engine.contextsReferenceQueue);
        }
    }

    static final class SingleContextState {
        private final PolyglotContextThreadLocal contextThreadLocal = new PolyglotContextThreadLocal();
        private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("Single Context");
        @CompilerDirectives.CompilationFinal
        private volatile PolyglotContextImpl singleContext;

        SingleContextState() {
            this(PolyglotContextImpl.singleContextState.singleContext);
        }

        SingleContextState(PolyglotContextImpl context) {
            this.singleContext = context;
        }

        PolyglotContextThreadLocal getContextThreadLocal() {
            return this.contextThreadLocal;
        }

        Assumption getSingleContextAssumption() {
            return this.singleContextAssumption;
        }
    }
}

