/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.polyglot.HostAccess;

final class PolyglotTargetMapping
implements Comparable<PolyglotTargetMapping> {
    final Class<Object> sourceType;
    final Class<Object> targetType;
    final Predicate<Object> accepts;
    final Function<Object, Object> converter;
    final int hostPriority;

    <S, T> PolyglotTargetMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> accepts, Function<S, T> converter, HostAccess.TargetMappingPrecedence precedence) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.accepts = accepts;
        this.converter = converter;
        this.hostPriority = PolyglotTargetMapping.toHostPriority(precedence);
    }

    private static int toHostPriority(HostAccess.TargetMappingPrecedence p) {
        switch (p) {
            case HIGHEST: {
                return 0;
            }
            case HIGH: {
                return 1;
            }
            case LOW: {
                return 2;
            }
            case LOWEST: {
                return 8;
            }
        }
        throw new AssertionError((Object)"invalid precedence");
    }

    @Override
    public int compareTo(PolyglotTargetMapping o) {
        return Integer.compare(this.hostPriority, o.hostPriority);
    }
}

