/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.RegexResultGetEndNode;
import com.oracle.truffle.regex.result.RegexResultGetStartNode;
import com.oracle.truffle.regex.runtime.nodes.ToIntNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public abstract class RegexResult
extends AbstractConstantKeysObject {
    static final String PROP_IS_MATCH = "isMatch";
    static final String PROP_GET_START = "getStart";
    static final String PROP_GET_END = "getEnd";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("isMatch", "getStart", "getEnd");

    public abstract int getStart(int var1);

    public abstract int getEnd(int var1);

    @Override
    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public final Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "isMatch": {
                return this != NoMatchResult.getInstance();
            }
            case "getStart": {
                return new RegexResultGetStartMethod(this);
            }
            case "getEnd": {
                return new RegexResultGetEndMethod(this);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create(symbol);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToIntNode toIntNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (args.length != 1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create(1, args.length);
        }
        return invokeCache.execute(this, member, toIntNode.execute(args[0]));
    }

    @ImportStatic(value={RegexResult.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(RegexResult var1, String var2, int var3) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        Object getStartIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        Object getStartEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        Object getEndIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        Object getEndEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(RegexResult receiver, String symbol, int groupNumber, @Cached RegexResultGetStartNode getStartNode, @Cached RegexResultGetEndNode getEndNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "getStart": {
                    return getStartNode.execute(receiver, groupNumber);
                }
                case "getEnd": {
                    return getEndNode.execute(receiver, groupNumber);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="2")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexResult receiver, String symbol) {
            return RegexResult.PROP_GET_START.equals(symbol) || RegexResult.PROP_GET_END.equals(symbol);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetEndMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetEndMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetEndNode getEndNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(1, args.length);
            }
            return getEndNode.execute(this.result, toIntNode.execute(args[1]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetEndMethod{result=" + this.result + '}';
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetStartMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetStartMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetStartNode getStartNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(1, args.length);
            }
            return getStartNode.execute(this.result, toIntNode.execute(args[0]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetStartMethod{result=" + this.result + '}';
        }
    }

    @ExportMessage
    static abstract class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="3")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="3", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isReadable(RegexResult receiver, String symbol) {
            return KEYS.contains(symbol);
        }
    }

    @ExportMessage
    static abstract class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2")
        static boolean isMatchIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != NoMatchResult.getInstance();
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2", replaces={"isMatchIdentity"})
        static boolean isMatchEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != NoMatchResult.getInstance();
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        static RegexResultGetStartMethod getStartIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        static RegexResultGetStartMethod getStartEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        static RegexResultGetEndMethod getEndIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        static RegexResultGetEndMethod getEndEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(replaces={"isMatchEquals", "getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object readGeneric(RegexResult receiver, String symbol) throws UnknownIdentifierException {
            switch (symbol) {
                case "isMatch": {
                    return receiver != NoMatchResult.getInstance();
                }
                case "getStart": {
                    return new RegexResultGetStartMethod(receiver);
                }
                case "getEnd": {
                    return new RegexResultGetEndMethod(receiver);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }
}

