/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNodeGen;

@GenerateUncached
public abstract class InputReadNode
extends Node {
    public static InputReadNode create() {
        return InputReadNodeGen.create();
    }

    public abstract int execute(Object var1, int var2);

    @Specialization
    static int doBytes(byte[] input, int index) {
        return Byte.toUnsignedInt(input[index]);
    }

    @Specialization
    static int doString(String input, int index) {
        return input.charAt(index);
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static int doBoxedCharArray(Object input, int index, @CachedLibrary(value="input") InteropLibrary inputs, @Cached ToCharNode toCharNode) {
        try {
            return toCharNode.execute(inputs.readArrayElement(input, index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public static int readWithMask(TruffleObject input, int indexInput, String mask, int indexMask, InputReadNode charAtNode) {
        CompilerAsserts.partialEvaluationConstant(mask == null);
        int c = charAtNode.execute(input, indexInput);
        return mask == null ? c : c | mask.charAt(indexMask);
    }

    public static int readWithMask(TruffleObject input, int indexInput, byte[] mask, int indexMask, InputReadNode charAtNode) {
        CompilerAsserts.partialEvaluationConstant(mask == null);
        int c = charAtNode.execute(input, indexInput);
        return mask == null ? c : c | Byte.toUnsignedInt(mask[indexMask]);
    }
}

