/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.charset.CharMatchers;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAMap;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.QuantifierGuard;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexLiteralLookAroundExecutorNode;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyFlavor;
import java.util.List;

public final class TRegexBacktrackingNFAExecutorNode
extends TRegexExecutorNode {
    public static final TRegexExecutorNode[] NO_LOOK_AROUND_EXECUTORS = new TRegexExecutorNode[0];
    private final PureNFA nfa;
    private final int nQuantifiers;
    private final int nZeroWidthQuantifiers;
    private final int maxNTransitions;
    private final boolean writesCaptureGroups;
    private final boolean forward;
    private final boolean ignoreCase;
    private final boolean unicode;
    private final boolean backrefWithNullTargetSucceeds;
    private final boolean monitorCaptureGroupsInEmptyCheck;
    private final boolean transitionMatchesStepByStep;
    private final boolean loneSurrogates;
    private final boolean loopbackInitialState;
    private final InnerLiteral innerLiteral;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TRegexExecutorNode[] lookAroundExecutors;
    @Node.Children
    private CharMatcher[] matchers;
    private final int[] zeroWidthTermEnclosedCGLow;
    private final int[] zeroWidthQuantifierCGOffsets;
    @Node.Child
    InputRegionMatchesNode regionMatchesNode;
    @Node.Child
    InputIndexOfStringNode indexOfNode;
    @Node.Child
    CharMatcher loopbackInitialStateMatcher;
    private static final int IP_BEGIN = -1;
    private static final int IP_BACKTRACK = -2;
    private static final int IP_END = -3;

    public TRegexBacktrackingNFAExecutorNode(PureNFAMap nfaMap, PureNFA nfa, TRegexExecutorNode[] lookAroundExecutors, CompilationBuffer compilationBuffer) {
        RegexASTSubtreeRootNode subtree = nfaMap.getASTSubtree(nfa);
        this.nfa = nfa;
        this.writesCaptureGroups = subtree.hasCaptureGroups();
        this.forward = !(subtree instanceof LookBehindAssertion);
        this.ignoreCase = nfaMap.getAst().getFlags().isIgnoreCase();
        this.unicode = nfaMap.getAst().getFlags().isUnicode();
        this.backrefWithNullTargetSucceeds = nfaMap.getAst().getOptions().getFlavor() != RubyFlavor.INSTANCE;
        this.monitorCaptureGroupsInEmptyCheck = nfaMap.getAst().getOptions().getFlavor() == RubyFlavor.INSTANCE;
        this.transitionMatchesStepByStep = nfaMap.getAst().getOptions().getFlavor() == RubyFlavor.INSTANCE;
        this.loneSurrogates = nfaMap.getAst().getProperties().hasLoneSurrogates();
        this.nQuantifiers = nfaMap.getAst().getQuantifierCount().getCount();
        this.nZeroWidthQuantifiers = nfaMap.getAst().getZeroWidthQuantifiables().size();
        List<QuantifiableTerm> zeroWidthQuantifiables = nfaMap.getAst().getZeroWidthQuantifiables();
        this.zeroWidthTermEnclosedCGLow = new int[this.nZeroWidthQuantifiers];
        this.zeroWidthQuantifierCGOffsets = new int[this.zeroWidthTermEnclosedCGLow.length + 1];
        int offset = 0;
        for (int i = 0; i < this.nZeroWidthQuantifiers; ++i) {
            QuantifiableTerm quantifiable = zeroWidthQuantifiables.get(i);
            if (quantifiable.isGroup()) {
                Group group = quantifiable.asGroup();
                this.zeroWidthTermEnclosedCGLow[i] = group.getEnclosedCaptureGroupsLow();
                offset += 2 * (group.getEnclosedCaptureGroupsHigh() - group.getEnclosedCaptureGroupsLow());
            }
            this.zeroWidthQuantifierCGOffsets[i + 1] = offset;
        }
        this.lookAroundExecutors = lookAroundExecutors;
        this.loopbackInitialState = nfa == nfaMap.getRoot() && !nfaMap.getAst().getFlags().isSticky() && !nfaMap.getAst().getRoot().startsWithCaret();
        this.innerLiteral = nfa == nfaMap.getRoot() && nfaMap.getAst().getProperties().hasInnerLiteral() ? nfaMap.getAst().extractInnerLiteral() : null;
        if (this.loopbackInitialState && this.innerLiteral == null) {
            CodePointSet initialCharSet = nfaMap.getMergedInitialStateCharSet(compilationBuffer);
            this.loopbackInitialStateMatcher = initialCharSet == null ? null : CharMatchers.createMatcher(initialCharSet, compilationBuffer);
        }
        nfa.materializeGroupBoundaries();
        this.matchers = new CharMatcher[nfa.getNumberOfStates()];
        int maxTransitions = 0;
        for (int i = 0; i < this.matchers.length; ++i) {
            PureNFAState s = nfa.getState(i);
            if (s.isCharacterClass()) {
                this.matchers[i] = this.insert(CharMatchers.createMatcher(s.getCharSet(), compilationBuffer));
            }
            maxTransitions = Math.max(maxTransitions, ((PureNFATransition[])s.getSuccessors(this.forward)).length);
            s.initIsDeterministic(this.forward, compilationBuffer);
        }
        this.maxNTransitions = maxTransitions;
    }

    public void initialize(TRegexExecNode rootNode) {
        for (TRegexExecutorNode executor : this.lookAroundExecutors) {
            executor.setRoot(rootNode);
            this.insert(executor);
        }
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.writesCaptureGroups;
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexBacktrackingNFAExecutorLocals(input, fromIndex, index, maxIndex, this.getNumberOfCaptureGroups(), this.nQuantifiers, this.nZeroWidthQuantifiers, this.zeroWidthTermEnclosedCGLow, this.zeroWidthQuantifierCGOffsets, this.transitionMatchesStepByStep, this.maxNTransitions);
    }

    @Override
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        CompilerDirectives.ensureVirtualized(locals);
        if (this.innerLiteral != null) {
            locals.setIndex(locals.getFromIndex());
            int innerLiteralIndex = this.findInnerLiteral(locals);
            if (innerLiteralIndex < 0) {
                return null;
            }
            locals.setLastInnerLiteralIndex(innerLiteralIndex);
            locals.setIndex(innerLiteralIndex);
            this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize());
        }
        if (this.loopbackInitialState) {
            locals.setLastInitialStateIndex(locals.getIndex());
        }
        this.runMergeExplode(locals, compactString);
        return locals.popResult();
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    protected void runMergeExplode(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString) {
        block16: {
            int nextIp;
            int ip = -1;
            block0: while (true) {
                LoopNode.reportLoopCount(this, 1);
                if (CompilerDirectives.inInterpreter()) {
                    RegexRootNode.checkThreadInterrupted();
                }
                CompilerAsserts.partialEvaluationConstant(ip);
                if (ip == -1) {
                    if (this.nfa.getAnchoredInitialState(this.isForward()) != this.nfa.getUnAnchoredInitialState(this.isForward()) && this.inputAtBegin(locals)) {
                        ip = this.nfa.getAnchoredInitialState(this.isForward()).getId();
                        continue;
                    }
                    ip = this.nfa.getUnAnchoredInitialState(this.isForward()).getId();
                    continue;
                }
                if (ip == -2) {
                    if (locals.canPopResult()) break block16;
                    if (!locals.canPop()) {
                        if (!this.loopbackInitialState) break block16;
                        assert (this.isForward());
                        locals.setIndex(locals.getLastInitialStateIndex());
                        if (!this.inputHasNext(locals)) break block16;
                        this.inputSkip(locals);
                        if (this.innerLiteral != null) {
                            if (locals.getLastInitialStateIndex() == locals.getLastInnerLiteralIndex()) {
                                int innerLiteralIndex = this.findInnerLiteral(locals);
                                if (innerLiteralIndex < 0) break block16;
                                locals.setLastInnerLiteralIndex(innerLiteralIndex);
                                locals.setIndex(innerLiteralIndex);
                                this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize());
                            }
                        } else if (this.loopbackInitialStateMatcher != null) {
                            assert (this.isForward());
                            while (this.inputHasNext(locals) && !this.loopbackInitialStateMatcher.execute(this.inputReadAndDecode(locals))) {
                                this.inputAdvance(locals);
                            }
                        }
                        locals.setLastInitialStateIndex(locals.getIndex());
                        locals.resetToInitialState();
                        ip = this.nfa.getUnAnchoredInitialState(this.isForward()).getId();
                        continue;
                    }
                    int nextIp2 = locals.pop();
                    for (int i = 0; i < this.nfa.getNumberOfStates(); ++i) {
                        int stateId = this.nfa.getState(i).getId();
                        CompilerAsserts.partialEvaluationConstant(stateId);
                        if (stateId != nextIp2) continue;
                        ip = stateId;
                        continue block0;
                    }
                    break block16;
                }
                if (ip == -3) break block16;
                PureNFAState curState = this.nfa.getState(ip);
                CompilerAsserts.partialEvaluationConstant(curState);
                PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors(this.isForward());
                CompilerAsserts.partialEvaluationConstant(successors);
                CompilerAsserts.partialEvaluationConstant(successors.length);
                nextIp = this.runState(locals, compactString, curState);
                for (int i = 0; i < successors.length; ++i) {
                    int targetIp = ((PureNFAState)successors[i].getTarget(this.isForward())).getId();
                    if (targetIp != nextIp) continue;
                    CompilerAsserts.partialEvaluationConstant(targetIp);
                    ip = targetIp;
                    continue block0;
                }
                if (nextIp != -2) break;
                ip = -2;
            }
            assert (nextIp == -3);
        }
    }

    @ExplodeLoop
    private int runState(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFAState curState) {
        long bs;
        int iBS;
        CompilerAsserts.partialEvaluationConstant(curState);
        if (curState.isFinalState(this.isForward())) {
            locals.setResult();
            locals.pushResult();
            return -3;
        }
        if (curState.isLookAround() && !this.canInlineLookAroundIntoTransition(curState)) {
            int[] subMatchResult = this.runSubMatcher(locals.createSubNFALocals(), compactString, curState);
            if (TRegexBacktrackingNFAExecutorNode.subMatchFailed(curState, subMatchResult)) {
                return -2;
            }
            if (!curState.isLookAroundNegated() && this.getLookAroundExecutor(curState).writesCaptureGroups()) {
                locals.overwriteCaptureGroups(subMatchResult);
            }
        }
        if (curState.isBackReference() && !this.canInlineBackReferenceIntoTransition()) {
            int backrefResult = this.matchBackReferenceGeneric(locals, locals.getCaptureGroupStart(curState.getBackRefNumber()), locals.getCaptureGroupEnd(curState.getBackRefNumber()));
            if (backrefResult < 0) {
                return -2;
            }
            locals.setIndex(backrefResult);
        }
        PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors(this.isForward());
        CompilerAsserts.partialEvaluationConstant(successors);
        CompilerAsserts.partialEvaluationConstant(successors.length);
        boolean atEnd = this.inputAtEnd(locals);
        int c = atEnd ? 0 : this.inputReadAndDecode(locals);
        int index = locals.getIndex();
        if (curState.isDeterministic()) {
            if (this.transitionMatchesStepByStep) {
                int[] currentFrame = locals.getStackFrameBuffer();
                locals.readFrame(currentFrame);
                for (int i = 0; i < successors.length; ++i) {
                    PureNFATransition transition = successors[i];
                    CompilerAsserts.partialEvaluationConstant(transition);
                    if (this.tryUpdateState(locals, compactString, transition, index, atEnd, c)) {
                        locals.restoreIndex();
                        return ((PureNFAState)transition.getTarget(this.isForward())).getId();
                    }
                    locals.writeFrame(currentFrame);
                }
                return -2;
            }
            for (int i = 0; i < successors.length; ++i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (!this.transitionMatches(locals, compactString, transition, index, atEnd, c)) continue;
                this.updateState(locals, transition, index);
                locals.restoreIndex();
                return ((PureNFAState)transition.getTarget(this.isForward())).getId();
            }
            return -2;
        }
        if (this.transitionMatchesStepByStep) {
            boolean hasMatchingTransition = false;
            boolean transitionToFinalStateWins = false;
            int[] currentFrame = locals.getStackFrameBuffer();
            locals.readFrame(currentFrame);
            for (int i = successors.length - 1; i >= 0; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (this.tryUpdateState(locals, compactString, transition, index, atEnd, c)) {
                    hasMatchingTransition = true;
                    PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
                    CompilerAsserts.partialEvaluationConstant(target);
                    if (target.isFinalState(this.isForward())) {
                        locals.setResult();
                        locals.pushResult();
                        transitionToFinalStateWins = true;
                        locals.writeFrame(currentFrame);
                        continue;
                    }
                    locals.setPc(target.getId());
                    transitionToFinalStateWins = false;
                    locals.pushFrame(currentFrame);
                    continue;
                }
                locals.writeFrame(currentFrame);
            }
            if (transitionToFinalStateWins) {
                return -3;
            }
            if (hasMatchingTransition) {
                locals.pop();
                locals.restoreIndex();
                return locals.getPc();
            }
            return -2;
        }
        long[] transitionBitSet = locals.getTransitionBitSet();
        CompilerDirectives.ensureVirtualized(transitionBitSet);
        int bitSetWords = (successors.length - 1 >> 6) + 1;
        CompilerAsserts.partialEvaluationConstant(bitSetWords);
        int lastMatch = 0;
        int lastFinal = 0;
        int nMatched = -1;
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant(iBS);
            bs = 0L;
            long bit = 1L;
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant(iStart);
            CompilerAsserts.partialEvaluationConstant(iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (this.transitionMatches(locals, compactString, transition, index, atEnd, c)) {
                    bs |= bit;
                    lastMatch = i;
                    if (((PureNFAState)transition.getTarget(this.isForward())).isFinalState(this.isForward())) {
                        locals.setResult();
                        lastFinal = i;
                        --nMatched;
                    }
                }
                bit <<= 1;
            }
            transitionBitSet[iBS] = bs;
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            nMatched += Long.bitCount(transitionBitSet[iBS]);
        }
        if (nMatched > 0) {
            locals.dupFrame(nMatched);
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant(iBS);
            bs = transitionBitSet[iBS];
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant(iStart);
            CompilerAsserts.partialEvaluationConstant(iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
                CompilerAsserts.partialEvaluationConstant(target);
                if ((bs & 1L) != 0L) {
                    if (target.isFinalState(this.isForward())) {
                        if (i == lastFinal) {
                            locals.pushResult(transition, index);
                        }
                        if (i == lastMatch) {
                            return -3;
                        }
                    } else {
                        this.updateState(locals, transition, index);
                        if (i == lastMatch) {
                            locals.restoreIndex();
                            return target.getId();
                        }
                        locals.setPc(target.getId());
                        locals.push();
                    }
                }
                bs >>>= 1;
            }
        }
        return -2;
    }

    private TRegexExecutorNode getLookAroundExecutor(PureNFAState lookAroundState) {
        return this.lookAroundExecutors[lookAroundState.getLookAroundId()];
    }

    protected boolean lookAroundExecutorIsLiteral(PureNFAState s) {
        return this.getLookAroundExecutor(s) instanceof TRegexLiteralLookAroundExecutorNode;
    }

    private boolean canInlineLookAroundIntoTransition(PureNFAState s) {
        return !(((PureNFATransition[])s.getPredecessors()).length != 1 && !this.lookAroundExecutorIsLiteral(s) || !s.isLookAroundNegated() && this.getLookAroundExecutor(s).writesCaptureGroups());
    }

    private boolean checkSubMatcherInline(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFATransition transition, PureNFAState target) {
        if (this.lookAroundExecutorIsLiteral(target)) {
            TRegexLiteralLookAroundExecutorNode literal = (TRegexLiteralLookAroundExecutorNode)this.getLookAroundExecutor(target);
            int saveIndex = locals.getIndex();
            int saveNextIndex = locals.getNextIndex();
            boolean result = (Boolean)literal.execute(locals, compactString);
            locals.setIndex(saveIndex);
            locals.setNextIndex(saveNextIndex);
            return result;
        }
        return !TRegexBacktrackingNFAExecutorNode.subMatchFailed(target, this.runSubMatcher(locals.createSubNFALocals(transition), compactString, target));
    }

    protected int[] runSubMatcher(TRegexBacktrackingNFAExecutorLocals subLocals, boolean compactString, PureNFAState lookAroundState) {
        return (int[])this.getLookAroundExecutor(lookAroundState).execute(subLocals, compactString);
    }

    protected static boolean subMatchFailed(PureNFAState curState, int[] subMatchResult) {
        return subMatchResult == null != curState.isLookAroundNegated();
    }

    @ExplodeLoop
    protected boolean transitionMatches(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFATransition transition, int index, boolean atEnd, int c) {
        int i;
        PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
        CompilerAsserts.partialEvaluationConstant(target);
        if (transition.hasCaretGuard() && index != 0) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getMaxIndex()) {
            return false;
        }
        int nGuards = transition.getQuantifierGuards().length;
        int n = i = this.isForward() ? 0 : nGuards - 1;
        while (this.isForward() ? i < nGuards : i >= 0) {
            QuantifierGuard guard = transition.getQuantifierGuards()[i];
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (this.isForward() ? guard.getKind() : guard.getKindReverse()) {
                case loop: {
                    if (locals.getQuantifierCount(q) != q.getMax()) break;
                    return false;
                }
                case exit: {
                    if (locals.getQuantifierCount(q) >= q.getMin()) break;
                    return false;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) != index || this.monitorCaptureGroupsInEmptyCheck && !locals.isResultUnmodifiedByZeroWidthQuantifier(q) || q.hasIndex() && locals.getQuantifierCount(q) <= q.getMin()) break;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) == index && (!this.monitorCaptureGroupsInEmptyCheck || locals.isResultUnmodifiedByZeroWidthQuantifier(q))) break;
                    return false;
                }
                case enterEmptyMatch: {
                    if (locals.getQuantifierCount(q) < q.getMin()) break;
                    return false;
                }
            }
            i = this.inputIncRaw(i);
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState(this.isForward()));
                return target.isAnchoredFinalState(this.isForward()) ? atEnd : true;
            }
            case 1: {
                return !atEnd && this.matchers[target.getId()].execute(c);
            }
            case 2: {
                if (this.canInlineLookAroundIntoTransition(target)) {
                    return this.checkSubMatcherInline(locals, compactString, transition, target);
                }
                return true;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition()) {
                    int start = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2, index);
                    int end = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2 + 1, index);
                    if (start < 0 || end < 0) {
                        return this.backrefWithNullTargetSucceeds;
                    }
                    return this.matchBackReferenceSimple(locals, start, end, index);
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected static int getBackRefBoundary(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int cgIndex, int index) {
        return transition.getGroupBoundaries().getUpdateIndices().get(cgIndex) ? index : (transition.getGroupBoundaries().getClearIndices().get(cgIndex) ? -1 : locals.getCaptureGroupBoundary(cgIndex));
    }

    @ExplodeLoop
    protected void updateState(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int index) {
        int i;
        CompilerAsserts.partialEvaluationConstant(transition);
        locals.apply(transition, index);
        int nGuards = transition.getQuantifierGuards().length;
        int n = i = this.isForward() ? 0 : nGuards - 1;
        while (this.isForward() ? i < nGuards : i >= 0) {
            QuantifierGuard guard = transition.getQuantifierGuards()[i];
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (this.isForward() ? guard.getKind() : guard.getKindReverse()) {
                case loop: 
                case enter: 
                case loopInc: {
                    locals.incQuantifierCount(q);
                    break;
                }
                case exit: 
                case exitReset: {
                    locals.resetQuantifierCount(q);
                    break;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(q);
                    locals.setZeroWidthQuantifierResults(q);
                    break;
                }
                case enterEmptyMatch: {
                    if (!transition.hasCaretGuard() && !transition.hasDollarGuard()) {
                        locals.setQuantifierCount(q, q.getMin());
                        break;
                    }
                    locals.incQuantifierCount(q);
                    break;
                }
            }
            i += this.isForward() ? 1 : -1;
        }
        locals.saveIndex(this.getNewIndex(locals, (PureNFAState)transition.getTarget(this.isForward()), index));
    }

    @ExplodeLoop
    protected boolean tryUpdateState(TRegexBacktrackingNFAExecutorLocals locals, boolean compactString, PureNFATransition transition, int index, boolean atEnd, int c) {
        int i;
        CompilerAsserts.partialEvaluationConstant(transition);
        PureNFAState target = (PureNFAState)transition.getTarget(this.isForward());
        CompilerAsserts.partialEvaluationConstant(target);
        if (transition.hasCaretGuard() && index != 0) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getMaxIndex()) {
            return false;
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState(this.isForward()));
                if (!target.isAnchoredFinalState(this.isForward()) || atEnd) break;
                return false;
            }
            case 1: {
                if (!atEnd && this.matchers[target.getId()].execute(c)) break;
                return false;
            }
            case 2: {
                if (!this.canInlineLookAroundIntoTransition(target) || this.checkSubMatcherInline(locals, compactString, transition, target)) break;
                return false;
            }
            case 3: {
                if (!this.canInlineBackReferenceIntoTransition()) break;
                int start = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2, index);
                int end = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, target.getBackRefNumber() * 2 + 1, index);
                if (!(start >= 0 && end >= 0 || this.backrefWithNullTargetSucceeds)) {
                    return false;
                }
                if (this.matchBackReferenceSimple(locals, start, end, index)) break;
                return false;
            }
            case 4: {
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        int nGuards = transition.getQuantifierGuards().length;
        int n = i = this.isForward() ? 0 : nGuards - 1;
        while (this.isForward() ? i < nGuards : i >= 0) {
            QuantifierGuard guard = transition.getQuantifierGuards()[i];
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (this.isForward() ? guard.getKind() : guard.getKindReverse()) {
                case enter: 
                case loopInc: {
                    locals.incQuantifierCount(q);
                    break;
                }
                case loop: {
                    if (locals.getQuantifierCount(q) == q.getMax()) {
                        return false;
                    }
                    locals.incQuantifierCount(q);
                    break;
                }
                case exit: {
                    if (locals.getQuantifierCount(q) < q.getMin()) {
                        return false;
                    }
                    locals.resetQuantifierCount(q);
                    break;
                }
                case exitReset: {
                    locals.resetQuantifierCount(q);
                    break;
                }
                case updateCG: {
                    locals.setCaptureGroupBoundary(guard.getIndex(), index);
                    break;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(q);
                    locals.setZeroWidthQuantifierResults(q);
                    break;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) != index || this.monitorCaptureGroupsInEmptyCheck && !locals.isResultUnmodifiedByZeroWidthQuantifier(q) || q.hasIndex() && locals.getQuantifierCount(q) <= q.getMin()) break;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) == index && (!this.monitorCaptureGroupsInEmptyCheck || locals.isResultUnmodifiedByZeroWidthQuantifier(q))) break;
                    return false;
                }
                case enterEmptyMatch: {
                    if (locals.getQuantifierCount(q) >= q.getMin()) {
                        return false;
                    }
                    if (!transition.hasCaretGuard() && !transition.hasDollarGuard()) {
                        locals.setQuantifierCount(q, q.getMin());
                        break;
                    }
                    locals.incQuantifierCount(q);
                    break;
                }
            }
            i = this.inputIncRaw(i);
        }
        locals.saveIndex(this.getNewIndex(locals, target, index));
        return true;
    }

    private int getNewIndex(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState target, int index) {
        CompilerAsserts.partialEvaluationConstant(target.getKind());
        switch (target.getKind()) {
            case 0: {
                return index;
            }
            case 1: {
                return locals.getNextIndex();
            }
            case 2: {
                return index;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition()) {
                    int end = locals.getCaptureGroupEnd(target.getBackRefNumber());
                    int start = locals.getCaptureGroupStart(target.getBackRefNumber());
                    if (start < 0 || end < 0) {
                        return index;
                    }
                    int length = end - start;
                    return this.isForward() ? index + length : index - length;
                }
                return index;
            }
            case 4: {
                return index;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private boolean canInlineBackReferenceIntoTransition() {
        return !this.ignoreCase && !this.loneSurrogates;
    }

    private boolean matchBackReferenceSimple(TRegexBacktrackingNFAExecutorLocals locals, int backrefStart, int backrefEnd, int index) {
        assert (!this.ignoreCase && !this.loneSurrogates);
        if (this.regionMatchesNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regionMatchesNode = this.insert(InputRegionMatchesNode.create());
        }
        int inputLength = locals.getMaxIndex();
        int backrefLength = backrefEnd - backrefStart;
        if (backrefLength == 0) {
            return true;
        }
        if (this.isForward() ? index + backrefLength > inputLength : index - backrefLength < 0) {
            return false;
        }
        return this.regionMatchesNode.execute(locals.getInput(), backrefStart, locals.getInput(), this.isForward() ? index : index - backrefLength, backrefLength, null);
    }

    private int matchBackReferenceGeneric(TRegexBacktrackingNFAExecutorLocals locals, int backrefStart, int backrefEnd) {
        assert (this.ignoreCase || this.loneSurrogates);
        int index = locals.getIndex();
        int inputLength = locals.getMaxIndex();
        int iBR = this.isForward() ? backrefStart : backrefEnd;
        int i = index;
        while (this.inputBoundsCheck(iBR, backrefStart, backrefEnd)) {
            int lowSurrogate;
            int lowSurrogate2;
            if (!this.inputBoundsCheck(i, 0, inputLength)) {
                return -1;
            }
            int codePointBR = this.inputReadRaw((TRegexExecutorLocals)locals, iBR);
            if (this.unicode && this.inputUTF16IsHighSurrogate(codePointBR) && this.inputBoundsCheck(this.inputIncRaw(iBR), backrefStart, backrefEnd) && this.inputUTF16IsLowSurrogate(lowSurrogate2 = this.inputReadRaw((TRegexExecutorLocals)locals, this.inputIncRaw(iBR)))) {
                codePointBR = this.inputUTF16ToCodePoint(codePointBR, lowSurrogate2);
                iBR = this.inputIncRaw(iBR);
            }
            int codePointI = this.inputReadRaw((TRegexExecutorLocals)locals, i);
            if (this.unicode && this.inputUTF16IsHighSurrogate(codePointI) && this.inputBoundsCheck(this.inputIncRaw(i), 0, inputLength) && this.inputUTF16IsLowSurrogate(lowSurrogate = this.inputReadRaw((TRegexExecutorLocals)locals, this.inputIncRaw(i)))) {
                codePointI = this.inputUTF16ToCodePoint(codePointI, lowSurrogate);
                i = this.inputIncRaw(i);
            }
            if (!(!this.isIgnoreCase() ? codePointBR == codePointI : this.equalsIgnoreCase(codePointBR, codePointI))) {
                return -1;
            }
            iBR = this.inputIncRaw(iBR);
            i = this.inputIncRaw(i);
        }
        return i;
    }

    private int findInnerLiteral(TRegexBacktrackingNFAExecutorLocals locals) {
        if (this.indexOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexOfNode = this.insert(InputIndexOfStringNode.create());
        }
        return this.indexOfNode.execute(locals.getInput(), locals.getIndex(), locals.getMaxIndex(), this.innerLiteral.getLiteral().content(), this.innerLiteral.getMaskContent());
    }

    private boolean inputBoundsCheck(int i, int min, int max) {
        return this.forward ? i < max : i > min;
    }

    private boolean equalsIgnoreCase(int a, int b) {
        return CaseFoldTable.equalsIgnoreCase(a, b, this.unicode ? CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptUnicode : CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptNonUnicode);
    }
}

