/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.nfa.QuantifierGuard;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyFlavor;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Arrays;
import java.util.Set;
import org.graalvm.collections.EconomicMap;

public abstract class NFATraversalRegexASTVisitor {
    private static final int SUCCESSOR_DEDUPLICATION_BAILOUT_THRESHOLD = 100000;
    protected final RegexAST ast;
    private Term root;
    private final LongArrayBuffer curPath = new LongArrayBuffer(8);
    private final EconomicMap<RegexASTNode, Integer> insideLoops;
    private final StateSet<RegexAST, Group> insideEmptyGuardGroup;
    private RegexASTNode cur;
    private Set<LookBehindAssertion> traversableLookBehindAssertions;
    private boolean canTraverseCaret = false;
    private boolean forward = true;
    private boolean done = false;
    private final EconomicMap<StateSet<RegexAST, RegexASTNode>, StateSet<RegexAST, RegexASTNode>> targetDeduplicationMap = EconomicMap.create();
    private final StateSet<RegexAST, RegexASTNode> lookAroundsOnPath;
    private final StateSet<RegexAST, RegexASTNode> dollarsOnPath;
    private final StateSet<RegexAST, RegexASTNode> targetsVisited;
    private final int[] nodeVisitCount;
    private int deduplicatedTargets = 0;
    private final TBitSet captureGroupUpdates;
    private final TBitSet captureGroupClears;
    private final ObjectArrayBuffer<QuantifierGuard> quantifierGuards = new ObjectArrayBuffer();
    private QuantifierGuard[] quantifierGuardsResult = null;
    private final TBitSet quantifierGuardsLoop;
    private final TBitSet quantifierGuardsExited;
    private static final int PATH_GROUP_ALT_INDEX_OFFSET = 0;
    private static final int PATH_NODE_OFFSET = 16;
    private static final int PATH_GROUP_ACTION_OFFSET = 48;
    private static final long PATH_GROUP_ACTION_CLEAR_MASK = 0xFFFFFFFFFFFFL;
    private static final long PATH_GROUP_ACTION_ENTER = 0x1000000000000L;
    private static final long PATH_GROUP_ACTION_EXIT = 0x2000000000000L;
    private static final long PATH_GROUP_ACTION_PASS_THROUGH = 0x4000000000000L;
    private static final long PATH_GROUP_ACTION_RUBY_ESCAPE = 0x8000000000000L;
    private static final long PATH_GROUP_ACTION_ENTER_OR_PASS_THROUGH = 0x5000000000000L;
    private static final long PATH_GROUP_ACTION_ANY = 0xF000000000000L;

    protected NFATraversalRegexASTVisitor(RegexAST ast) {
        this.ast = ast;
        this.insideLoops = EconomicMap.create();
        this.insideEmptyGuardGroup = StateSet.create(ast);
        this.targetsVisited = StateSet.create(ast);
        this.lookAroundsOnPath = StateSet.create(ast);
        this.dollarsOnPath = StateSet.create(ast);
        this.nodeVisitCount = new int[ast.getNumberOfStates()];
        this.captureGroupUpdates = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.captureGroupClears = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.quantifierGuardsLoop = new TBitSet(ast.getQuantifierCount().getCount());
        this.quantifierGuardsExited = new TBitSet(ast.getQuantifierCount().getCount());
    }

    public Set<LookBehindAssertion> getTraversableLookBehindAssertions() {
        return this.traversableLookBehindAssertions;
    }

    public void setTraversableLookBehindAssertions(Set<LookBehindAssertion> traversableLookBehindAssertions) {
        this.traversableLookBehindAssertions = traversableLookBehindAssertions;
    }

    public boolean canTraverseCaret() {
        return this.canTraverseCaret;
    }

    public void setCanTraverseCaret(boolean canTraverseCaret) {
        this.canTraverseCaret = canTraverseCaret;
    }

    public void setReverse() {
        this.forward = false;
    }

    protected abstract boolean canTraverseLookArounds();

    protected void run(Term runRoot) {
        assert (this.insideLoops.isEmpty());
        assert (this.insideEmptyGuardGroup.isEmpty());
        assert (this.curPath.isEmpty());
        assert (this.dollarsOnPath.isEmpty());
        assert (this.lookAroundsOnPath.isEmpty());
        assert (this.nodeVisitsEmpty()) : Arrays.toString(this.nodeVisitCount);
        this.targetsVisited.clear();
        this.targetDeduplicationMap.clear();
        this.deduplicatedTargets = 0;
        this.root = runRoot;
        if (runRoot.isGroup() && runRoot.getParent().isSubtreeRoot()) {
            this.cur = runRoot;
        } else {
            this.advanceTerm(runRoot);
        }
        while (!this.done) {
            while (this.doAdvance()) {
            }
            if (this.done) break;
            RegexASTNode target = this.pathGetNode(this.curPath.peek());
            this.visit(target);
            if (target.isMatchFound() && !this.dollarsOnPath() && this.lookAroundsOnPath.isEmpty() && !this.hasQuantifierGuards() && !this.caretsOnPath()) {
                this.insideLoops.clear();
                this.insideEmptyGuardGroup.clear();
                this.curPath.clear();
                this.quantifierGuardsResult = null;
                break;
            }
            this.quantifierGuardsResult = null;
            this.retreat();
        }
        this.done = false;
    }

    protected abstract void visit(RegexASTNode var1);

    protected abstract void enterLookAhead(LookAheadAssertion var1);

    protected abstract void leaveLookAhead(LookAheadAssertion var1);

    protected boolean caretsOnPath() {
        for (int i = 0; i < this.curPath.length(); ++i) {
            RegexASTNode node = this.pathGetNode(this.curPath.get(i));
            if (!node.isCaret()) continue;
            return true;
        }
        return false;
    }

    protected boolean dollarsOnPath() {
        return !this.dollarsOnPath.isEmpty();
    }

    protected boolean hasQuantifierGuards() {
        this.calcQuantifierGuards();
        return this.quantifierGuardsResult.length > 0;
    }

    protected QuantifierGuard[] getQuantifierGuardsOnPath() {
        this.calcQuantifierGuards();
        return this.quantifierGuardsResult;
    }

    protected void calcQuantifierGuards() {
        if (this.quantifierGuardsResult == null) {
            this.quantifierGuards.clear();
            this.quantifierGuardsLoop.clear();
            this.quantifierGuardsExited.clear();
            RegexASTNode target = this.pathGetNode(this.curPath.peek());
            Group emptyMatch = null;
            if (target.isGroup()) {
                emptyMatch = target.getParent().getParent().asGroup();
                this.quantifierGuards.add(QuantifierGuard.createEnterEmptyMatch(emptyMatch.getQuantifier()));
            }
            for (int i = 0; i < this.curPath.length(); ++i) {
                long element = this.curPath.get(i);
                if (!NFATraversalRegexASTVisitor.pathIsGroup(element)) continue;
                Group group = (Group)this.pathGetNode(element);
                if (group.hasQuantifier() && group != emptyMatch) {
                    Token.Quantifier quantifier = group.getQuantifier();
                    if (quantifier.hasIndex()) {
                        if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                            if (this.quantifierGuardsLoop.get(quantifier.getIndex()) && !this.quantifierGuardsExited.get(quantifier.getIndex())) {
                                this.quantifierGuards.add(quantifier.isInfiniteLoop() ? QuantifierGuard.createLoopInc(quantifier) : QuantifierGuard.createLoop(quantifier));
                            } else {
                                this.quantifierGuards.add(QuantifierGuard.createEnter(quantifier));
                            }
                        } else if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element)) {
                            if (quantifier.getMin() > 0) {
                                this.quantifierGuardsExited.set(quantifier.getIndex());
                                this.quantifierGuards.add(QuantifierGuard.createExit(quantifier));
                            } else {
                                this.quantifierGuards.add(QuantifierGuard.createClear(quantifier));
                            }
                        } else if (NFATraversalRegexASTVisitor.pathIsGroupExit(element)) {
                            this.quantifierGuardsLoop.set(quantifier.getIndex());
                        } else {
                            assert (NFATraversalRegexASTVisitor.pathIsGroupRubyEscape(element));
                            this.quantifierGuardsExited.set(quantifier.getIndex());
                        }
                    }
                    if (quantifier.hasZeroWidthIndex() && (group.getFirstAlternative().isExpandedQuantifier() || group.getLastAlternative().isExpandedQuantifier())) {
                        if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                            this.quantifierGuards.add(QuantifierGuard.createEnterZeroWidth(quantifier));
                        } else if (NFATraversalRegexASTVisitor.pathIsGroupExit(element) && (this.ast.getOptions().getFlavor() == RubyFlavor.INSTANCE || !this.root.isCharacterClass())) {
                            this.quantifierGuards.add(QuantifierGuard.createExitZeroWidth(quantifier));
                        } else if (NFATraversalRegexASTVisitor.pathIsGroupRubyEscape(element)) {
                            this.quantifierGuards.add(QuantifierGuard.createEscapeZeroWidth(quantifier));
                        }
                    }
                }
                if (this.ast.getOptions().getFlavor() != RubyFlavor.INSTANCE || !group.isCapturing()) continue;
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                    this.quantifierGuards.add(QuantifierGuard.createUpdateCG(group.getBoundaryIndexStart()));
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element)) {
                    this.quantifierGuards.add(QuantifierGuard.createUpdateCG(group.getBoundaryIndexStart()));
                    this.quantifierGuards.add(QuantifierGuard.createUpdateCG(group.getBoundaryIndexEnd()));
                    continue;
                }
                assert (NFATraversalRegexASTVisitor.pathIsGroupExit(element) || NFATraversalRegexASTVisitor.pathIsGroupRubyEscape(element));
                this.quantifierGuards.add(QuantifierGuard.createUpdateCG(group.getBoundaryIndexEnd()));
            }
            if (this.root.isGroup() && !this.root.getParent().isSubtreeRoot()) {
                emptyMatch = this.root.getParent().getParent().asGroup();
                this.quantifierGuards.add(QuantifierGuard.createExitEmptyMatch(emptyMatch.getQuantifier()));
            }
            this.quantifierGuardsResult = this.quantifierGuards.toArray(QuantifierGuard.NO_GUARDS);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected PositionAssertion getLastDollarOnPath() {
        assert (this.dollarsOnPath());
        for (int i = this.curPath.length() - 1; i >= 0; --i) {
            long element = this.curPath.get(i);
            if (!this.pathGetNode(element).isDollar()) continue;
            return (PositionAssertion)this.pathGetNode(element);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected GroupBoundaries getGroupBoundaries() {
        this.captureGroupUpdates.clear();
        this.captureGroupClears.clear();
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element) || !NFATraversalRegexASTVisitor.pathIsGroup(element)) continue;
            Group group = (Group)this.pathGetNode(element);
            if (group.isCapturing()) {
                int b = NFATraversalRegexASTVisitor.pathIsGroupEnter(element) ? group.getBoundaryIndexStart() : group.getBoundaryIndexEnd();
                this.captureGroupUpdates.set(b);
                this.captureGroupClears.clear(b);
            }
            if (this.ast.getOptions().getFlavor() == RubyFlavor.INSTANCE || !NFATraversalRegexASTVisitor.pathIsGroupEnter(element) || !group.hasQuantifier() || !group.hasEnclosedCaptureGroups()) continue;
            int lo = Group.groupNumberToBoundaryIndexStart(group.getEnclosedCaptureGroupsLow());
            int hi = Group.groupNumberToBoundaryIndexEnd(group.getEnclosedCaptureGroupsHigh() - 1);
            this.captureGroupUpdates.clearRange(lo, hi);
            this.captureGroupClears.setRange(lo, hi);
        }
        return this.ast.createGroupBoundaries(this.captureGroupUpdates, this.captureGroupClears);
    }

    private boolean doAdvance() {
        int extraEmptyLoopIterations;
        int n = extraEmptyLoopIterations = this.ast.getOptions().getFlavor() == RubyFlavor.INSTANCE ? 1 : 0;
        if (this.cur.isDead() || this.insideLoops.get(this.cur, 0) > extraEmptyLoopIterations) {
            return this.retreat();
        }
        if (this.cur.isSequence()) {
            Sequence sequence = (Sequence)this.cur;
            if (sequence.isEmpty()) {
                Group parent = sequence.getParent();
                if (sequence.isExpandedQuantifier()) {
                    long lastElement = this.curPath.pop();
                    assert (this.pathGetNode(lastElement) == parent && NFATraversalRegexASTVisitor.pathIsGroupEnter(lastElement));
                    if (parent.hasNotUnrolledQuantifier() && parent.getQuantifier().getMin() > 0 && !this.isGroupExitOnPath(parent)) {
                        this.curPath.add(lastElement);
                        return this.retreat();
                    }
                    this.curPath.add(NFATraversalRegexASTVisitor.pathSwitchEnterAndPassThrough(lastElement));
                    this.unregisterInsideLoop(parent);
                } else {
                    this.pushGroupExit(parent);
                }
                return this.advanceTerm(parent);
            }
            this.cur = this.forward ? sequence.getFirstTerm() : sequence.getLastTerm();
            return true;
        }
        if (this.cur.isGroup()) {
            Group group = (Group)this.cur;
            this.curPath.add(NFATraversalRegexASTVisitor.createGroupEnterPathElement(group));
            if (group.hasEmptyGuard()) {
                this.insideEmptyGuardGroup.add(group);
            }
            if (group.isLoop()) {
                this.registerInsideLoop(group);
            }
            this.cur = group.getFirstAlternative();
            return true;
        }
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(this.cur));
        if (this.cur.isPositionAssertion()) {
            PositionAssertion assertion = (PositionAssertion)this.cur;
            switch (assertion.type) {
                case CARET: {
                    if (this.canTraverseCaret) {
                        return this.advanceTerm(assertion);
                    }
                    return this.retreat();
                }
                case DOLLAR: {
                    this.addToVisitedSet(this.dollarsOnPath);
                    return this.advanceTerm((Term)this.cur);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (this.canTraverseLookArounds() && this.cur.isLookAheadAssertion()) {
            this.enterLookAhead((LookAheadAssertion)this.cur);
            this.addToVisitedSet(this.lookAroundsOnPath);
            return this.advanceTerm((Term)this.cur);
        }
        if (this.canTraverseLookArounds() && this.cur.isLookBehindAssertion()) {
            this.addToVisitedSet(this.lookAroundsOnPath);
            if (this.traversableLookBehindAssertions == null || this.traversableLookBehindAssertions.contains(this.cur)) {
                return this.advanceTerm((LookBehindAssertion)this.cur);
            }
            return this.retreat();
        }
        assert (this.cur.isCharacterClass() || this.cur.isBackReference() || this.cur.isMatchFound() || !this.canTraverseLookArounds() && this.cur.isLookAroundAssertion());
        if (this.forward && this.dollarsOnPath() && this.cur.isCharacterClass()) {
            return this.retreat();
        }
        return this.deduplicateTarget();
    }

    private boolean isGroupExitOnPath(Group group) {
        return !this.curPath.isEmpty() && NFATraversalRegexASTVisitor.pathIsGroupExit(this.curPath.peek()) && this.pathGetNode(this.curPath.peek()) == group;
    }

    private void registerInsideLoop(Group group) {
        this.insideLoops.put(group, this.insideLoops.get(group, 0) + 1);
    }

    private void unregisterInsideLoop(Group group) {
        int depth = this.insideLoops.get(group, 0);
        if (depth == 1) {
            this.insideLoops.removeKey(group);
        } else if (depth > 1) {
            this.insideLoops.put(group, depth - 1);
        }
    }

    private void addToVisitedSet(StateSet<RegexAST, RegexASTNode> visitedSet) {
        int n = this.cur.getId();
        this.nodeVisitCount[n] = this.nodeVisitCount[n] + 1;
        visitedSet.add(this.cur);
    }

    private boolean advanceTerm(Term term) {
        if (this.ast.isNFAInitialState(term) || term.getParent().isSubtreeRoot() && (term.isPositionAssertion() || term.isMatchFound())) {
            assert (term.isPositionAssertion() || term.isMatchFound());
            this.cur = term.isPositionAssertion() ? term.asPositionAssertion().getNext() : term.asMatchFound().getNext();
            return true;
        }
        Term curTerm = term;
        while (!curTerm.getParent().isSubtreeRoot()) {
            if (this.insideEmptyGuardGroup.contains(curTerm)) {
                return this.advanceEmptyGuard(curTerm);
            }
            Sequence parentSeq = (Sequence)curTerm.getParent();
            if (curTerm == (this.forward ? parentSeq.getLastTerm() : parentSeq.getFirstTerm())) {
                Group parentGroup = parentSeq.getParent();
                this.pushGroupExit(parentGroup);
                if (parentGroup.isLoop()) {
                    this.cur = parentGroup;
                    return true;
                }
                curTerm = parentGroup;
                continue;
            }
            this.cur = parentSeq.getTerms().get(curTerm.getSeqIndex() + (this.forward ? 1 : -1));
            return true;
        }
        assert (curTerm.isGroup());
        assert (curTerm.getParent().isSubtreeRoot());
        if (this.insideEmptyGuardGroup.contains(curTerm)) {
            return this.advanceEmptyGuard(curTerm);
        }
        this.cur = curTerm.getSubTreeParent().getMatchFound();
        return true;
    }

    private boolean advanceEmptyGuard(Term curTerm) {
        Group parent = curTerm.getParent().getParent().asGroup();
        if (parent.hasNotUnrolledQuantifier() && parent.getQuantifier().getMin() > 0) {
            assert (curTerm.isGroup());
            this.cur = curTerm;
            return false;
        }
        return this.retreat();
    }

    private void pushGroupExit(Group group) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | 0x2000000000000L);
    }

    private boolean retreat() {
        while (!this.curPath.isEmpty()) {
            long lastVisited = this.curPath.pop();
            RegexASTNode node = this.pathGetNode(lastVisited);
            if (NFATraversalRegexASTVisitor.pathIsGroup(lastVisited)) {
                Group group = (Group)node;
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(lastVisited) || NFATraversalRegexASTVisitor.pathIsGroupPassThrough(lastVisited)) {
                    if (this.pathGroupHasNext(lastVisited)) {
                        this.cur = this.pathGroupGetNext(lastVisited);
                        this.curPath.add(NFATraversalRegexASTVisitor.pathToGroupEnter(NFATraversalRegexASTVisitor.pathIncGroupAltIndex(lastVisited)));
                        if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(lastVisited)) {
                            this.registerInsideLoop(group);
                        }
                        return true;
                    }
                    assert (this.noEmptyGuardGroupEnterOnPath(group));
                    if (NFATraversalRegexASTVisitor.pathIsGroupEnter(lastVisited)) {
                        this.unregisterInsideLoop(group);
                    }
                    this.insideEmptyGuardGroup.remove(group);
                    continue;
                }
                if (this.ast.getOptions().getFlavor() != RubyFlavor.INSTANCE || !NFATraversalRegexASTVisitor.pathIsGroupExit(lastVisited) || !group.hasQuantifier() || !group.getQuantifier().hasZeroWidthIndex() || !group.getFirstAlternative().isExpandedQuantifier() && !group.getLastAlternative().isExpandedQuantifier()) continue;
                this.curPath.add(NFATraversalRegexASTVisitor.pathToGroupRubyEscape(lastVisited));
                if (this.advanceTerm(group)) {
                    return true;
                }
                this.retreat();
                continue;
            }
            if (this.canTraverseLookArounds() && node.isLookAroundAssertion()) {
                if (node.isLookAheadAssertion()) {
                    this.leaveLookAhead(node.asLookAheadAssertion());
                }
                this.removeFromVisitedSet(lastVisited, this.lookAroundsOnPath);
                continue;
            }
            if (!node.isDollar()) continue;
            this.removeFromVisitedSet(lastVisited, this.dollarsOnPath);
        }
        this.done = true;
        return false;
    }

    private void removeFromVisitedSet(long pathElement, StateSet<RegexAST, RegexASTNode> visitedSet) {
        int n = NFATraversalRegexASTVisitor.pathGetNodeId(pathElement);
        this.nodeVisitCount[n] = this.nodeVisitCount[n] - 1;
        if (this.nodeVisitCount[n] == 0) {
            visitedSet.remove(this.pathGetNode(pathElement));
        }
    }

    private boolean deduplicateTarget() {
        if (!this.canTraverseLookArounds()) {
            this.quantifierGuardsResult = null;
            this.calcQuantifierGuards();
            if (this.quantifierGuardsResult.length != 0) {
                return false;
            }
        }
        boolean isDuplicate = false;
        if (this.dollarsOnPath.isEmpty() && this.lookAroundsOnPath.isEmpty()) {
            isDuplicate = !this.targetsVisited.add(this.cur);
        } else if (this.canTraverseLookArounds()) {
            StateSet<RegexAST, RegexASTNode> key = this.lookAroundsOnPath.copy();
            key.addAll(this.dollarsOnPath);
            key.add(this.cur);
            isDuplicate = this.targetDeduplicationMap.put(key, key) != null;
        } else {
            StateSet<RegexAST, RegexASTNode> key = this.dollarsOnPath.copy();
            key.add(this.cur);
            boolean bl = isDuplicate = this.targetDeduplicationMap.put(key, key) != null;
        }
        if (isDuplicate) {
            if (++this.deduplicatedTargets > 100000) {
                throw new UnsupportedRegexException("NFATraversal explosion");
            }
            return this.retreat();
        }
        return false;
    }

    private static long createPathElement(RegexASTNode node) {
        return (long)node.getId() << 16;
    }

    private static long createGroupEnterPathElement(Group node) {
        return (long)node.getId() << 16 | 1L | 0x1000000000000L;
    }

    private static int pathGetNodeId(long pathElement) {
        return (int)(pathElement >>> 16);
    }

    private RegexASTNode pathGetNode(long pathElement) {
        return this.ast.getState(NFATraversalRegexASTVisitor.pathGetNodeId(pathElement));
    }

    private static int pathGetGroupAltIndex(long pathElement) {
        return (short)(pathElement >>> 0);
    }

    private static long pathToGroupEnter(long pathElement) {
        return pathElement & 0xFFFFFFFFFFFFL | 0x1000000000000L;
    }

    private static long pathToGroupRubyEscape(long pathElement) {
        return pathElement & 0xFFFFFFFFFFFFL | 0x8000000000000L;
    }

    private static boolean pathIsGroup(long pathElement) {
        return (pathElement & 0xF000000000000L) != 0L;
    }

    private static boolean pathIsGroupEnter(long pathElement) {
        return (pathElement & 0x1000000000000L) != 0L;
    }

    private static boolean pathIsGroupExit(long pathElement) {
        return (pathElement & 0x2000000000000L) != 0L;
    }

    private static boolean pathIsGroupPassThrough(long pathElement) {
        return (pathElement & 0x4000000000000L) != 0L;
    }

    private static boolean pathIsGroupRubyEscape(long pathElement) {
        return (pathElement & 0x8000000000000L) != 0L;
    }

    private static long pathSwitchEnterAndPassThrough(long pathElement) {
        assert (NFATraversalRegexASTVisitor.pathIsGroupEnter(pathElement) != NFATraversalRegexASTVisitor.pathIsGroupPassThrough(pathElement));
        return pathElement ^ 0x5000000000000L;
    }

    private boolean pathGroupHasNext(long pathElement) {
        return NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement) < ((Group)this.pathGetNode(pathElement)).size();
    }

    private Sequence pathGroupGetNext(long pathElement) {
        return ((Group)this.pathGetNode(pathElement)).getAlternatives().get(NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement));
    }

    private static long pathIncGroupAltIndex(long pathElement) {
        return pathElement + 1L;
    }

    private boolean noEmptyGuardGroupEnterOnPath(Group group) {
        if (!group.hasEmptyGuard()) {
            return true;
        }
        for (int i = 0; i < this.curPath.length(); ++i) {
            if (this.pathGetNode(this.curPath.get(i)) != group || !NFATraversalRegexASTVisitor.pathIsGroupEnter(this.curPath.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean nodeVisitsEmpty() {
        for (int i : this.nodeVisitCount) {
            if (i == 0) continue;
            return false;
        }
        return true;
    }

    private void dumpPath() {
        System.out.println("NEW PATH");
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (NFATraversalRegexASTVisitor.pathIsGroup(element)) {
                Group group = (Group)this.pathGetNode(element);
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                    System.out.println(String.format("ENTER (%d)   %s", NFATraversalRegexASTVisitor.pathGetGroupAltIndex(element), group));
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(element)) {
                    System.out.println(String.format("EXIT        %s", group));
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element)) {
                    System.out.println(String.format("PASSTHROUGH %s", group));
                    continue;
                }
                System.out.println(String.format("RUBY ESCAPE %s", group));
                continue;
            }
            System.out.println(String.format("NODE        %s", this.pathGetNode(element)));
        }
    }
}

