/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public abstract class CommonJSRequireBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    private static final boolean LOG_REQUIRE_PATH_RESOLUTION = false;
    private static final Stack<String> requireDebugStack = null;
    public static final String FILENAME_VAR_NAME = "__filename";
    public static final String DIRNAME_VAR_NAME = "__dirname";
    public static final String MODULE_PROPERTY_NAME = "module";
    public static final String EXPORTS_PROPERTY_NAME = "exports";
    public static final String REQUIRE_PROPERTY_NAME = "require";
    public static final String RESOLVE_PROPERTY_NAME = "resolve";
    private static final String MODULE_END = "\n});";
    private static final String MODULE_PREAMBLE = "(function (exports, require, module, __filename, __dirname) {";
    private static final String LOADED_PROPERTY_NAME = "loaded";
    private static final String FILENAME_PROPERTY_NAME = "filename";
    private static final String ID_PROPERTY_NAME = "id";
    private static final String ENV_PROPERTY_NAME = "env";
    private static final String JS_EXT = ".js";
    private static final String JSON_EXT = ".json";
    private static final String NODE_EXT = ".node";
    private final TruffleFile modulesResolutionCwd;

    public static void log(Object ... message) {
    }

    private static void debugStackPush(String moduleIdentifier) {
    }

    private static void debugStackPop() {
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleFile getModuleResolveCurrentWorkingDirectory(JSContext context) {
        TruffleLanguage.Env env = context.getRealm().getEnv();
        String currentFileNameFromStack = CommonJSResolution.getCurrentFileNameFromStack();
        if (currentFileNameFromStack == null) {
            String cwdOption = context.getContextOptions().getRequireCwd();
            return cwdOption == null ? env.getCurrentWorkingDirectory() : env.getPublicTruffleFile(cwdOption);
        }
        TruffleFile truffleFile = env.getPublicTruffleFile(currentFileNameFromStack);
        assert (truffleFile.isRegularFile(new LinkOption[0]) && truffleFile.getParent() != null);
        return truffleFile.getParent().normalize();
    }

    CommonJSRequireBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
        this.modulesResolutionCwd = CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(context);
    }

    @Specialization
    protected Object require(DynamicObject currentRequire, String moduleIdentifier) {
        TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
        TruffleFile resolutionEntryPath = this.getModuleResolutionEntryPath(currentRequire, env);
        return this.requireImpl(moduleIdentifier, resolutionEntryPath);
    }

    @CompilerDirectives.TruffleBoundary
    private Object requireImpl(String moduleIdentifier, TruffleFile entryPath) {
        String moduleReplacementName;
        CommonJSRequireBuiltin.log("required module '", moduleIdentifier, "'                                core:", CommonJSResolution.isCoreModule(moduleIdentifier), " from path ", entryPath);
        if (CommonJSResolution.isCoreModule(moduleIdentifier) && (moduleReplacementName = this.getContext().getContextOptions().getCommonJSRequireBuiltins().get(moduleIdentifier)) != null && !"".equals(moduleReplacementName)) {
            return this.requireImpl(moduleReplacementName, this.modulesResolutionCwd);
        }
        TruffleFile maybeModule = null;
        try {
            maybeModule = CommonJSResolution.resolve(this.getContext(), moduleIdentifier, entryPath);
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            throw CommonJSRequireBuiltin.fail(moduleIdentifier, e.getMessage());
        }
        CommonJSRequireBuiltin.log("module ", moduleIdentifier, " resolved to ", maybeModule);
        if (maybeModule == null) {
            throw CommonJSRequireBuiltin.fail(moduleIdentifier);
        }
        if (CommonJSRequireBuiltin.isJsFile(maybeModule)) {
            return this.evalJavaScriptFile(maybeModule, moduleIdentifier);
        }
        if (CommonJSRequireBuiltin.isJsonFile(maybeModule)) {
            return this.evalJsonFile(maybeModule);
        }
        if (CommonJSRequireBuiltin.isNodeBinFile(maybeModule)) {
            throw CommonJSRequireBuiltin.fail("Unsupported .node file: ", moduleIdentifier);
        }
        throw CommonJSRequireBuiltin.fail(moduleIdentifier);
    }

    private Object evalJavaScriptFile(TruffleFile modulePath, String moduleIdentifier) {
        JSRealm realm = this.getContext().getRealm();
        TruffleFile normalizedPath = modulePath.normalize();
        Map<TruffleFile, DynamicObject> commonJSCache = realm.getCommonJSRequireCache();
        if (commonJSCache.containsKey(normalizedPath)) {
            DynamicObject moduleBuiltin = commonJSCache.get(normalizedPath);
            Object cached = JSObject.get(moduleBuiltin, (Object)EXPORTS_PROPERTY_NAME);
            CommonJSRequireBuiltin.log("returning cached '", modulePath, cached);
            return cached;
        }
        Source source = this.sourceFromPath(modulePath.toString(), realm);
        String filenameBuiltin = normalizedPath.toString();
        if (modulePath.getParent() == null) {
            throw CommonJSRequireBuiltin.fail(moduleIdentifier);
        }
        String dirnameBuiltin = modulePath.getParent().getAbsoluteFile().normalize().toString();
        DynamicObject exportsBuiltin = CommonJSRequireBuiltin.createExportsBuiltin(realm);
        DynamicObject moduleBuiltin = CommonJSRequireBuiltin.createModuleBuiltin(realm, exportsBuiltin, filenameBuiltin);
        DynamicObject requireBuiltin = CommonJSRequireBuiltin.createRequireBuiltin(realm, moduleBuiltin, filenameBuiltin);
        DynamicObject env = JSOrdinary.create(this.getContext());
        JSObject.set(env, ENV_PROPERTY_NAME, (Object)JSOrdinary.create(this.getContext()));
        String characters = MODULE_PREAMBLE + source.getCharacters() + MODULE_END;
        Source moduleSources = Source.newBuilder("js", characters, filenameBuiltin).mimeType("text/javascript").build();
        CallTarget moduleCallTarget = realm.getEnv().parsePublic(moduleSources, new String[0]);
        Object moduleExecutableFunction = moduleCallTarget.call(new Object[0]);
        if (JSFunction.isJSFunction(moduleExecutableFunction)) {
            Object object;
            commonJSCache.put(normalizedPath, moduleBuiltin);
            try {
                CommonJSRequireBuiltin.debugStackPush(moduleIdentifier);
                CommonJSRequireBuiltin.log("executing '", filenameBuiltin, "' for ", moduleIdentifier);
                JSFunction.call(JSArguments.create(moduleExecutableFunction, moduleExecutableFunction, exportsBuiltin, requireBuiltin, moduleBuiltin, filenameBuiltin, dirnameBuiltin, env));
                JSObject.set(moduleBuiltin, LOADED_PROPERTY_NAME, (Object)true);
                object = JSObject.get(moduleBuiltin, (Object)EXPORTS_PROPERTY_NAME);
            }
            catch (Exception e) {
                try {
                    CommonJSRequireBuiltin.log("EXCEPTION: '", e.getMessage(), "'");
                    throw e;
                }
                catch (Throwable throwable) {
                    CommonJSRequireBuiltin.debugStackPop();
                    Object module = JSObject.get(moduleBuiltin, (Object)EXPORTS_PROPERTY_NAME);
                    CommonJSRequireBuiltin.log("done '", moduleIdentifier, "' module.exports: ", module, module);
                    throw throwable;
                }
            }
            CommonJSRequireBuiltin.debugStackPop();
            Object module = JSObject.get(moduleBuiltin, (Object)EXPORTS_PROPERTY_NAME);
            CommonJSRequireBuiltin.log("done '", moduleIdentifier, "' module.exports: ", module, module);
            return object;
        }
        return null;
    }

    private DynamicObject evalJsonFile(TruffleFile jsonFile) {
        try {
            if (CommonJSRequireBuiltin.fileExists(jsonFile)) {
                JSRealm realm = this.getContext().getRealm();
                TruffleFile file = GlobalBuiltins.resolveRelativeFilePath(jsonFile.toString(), realm.getEnv());
                if (!file.isRegularFile(new LinkOption[0])) {
                    throw CommonJSRequireBuiltin.fail(jsonFile.toString());
                }
                Source source = this.sourceFromTruffleFile(file);
                DynamicObject parse = (DynamicObject)realm.getJsonParseFunctionObject();
                assert (source != null);
                String jsonString = source.getCharacters().toString();
                Object jsonObj = JSFunction.call(JSArguments.create(parse, parse, jsonString));
                if (JSDynamicObject.isJSDynamicObject(jsonObj)) {
                    return (DynamicObject)jsonObj;
                }
            }
            throw CommonJSRequireBuiltin.fail(jsonFile.toString());
        }
        catch (SecurityException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    private static JSException fail(String moduleIdentifier) {
        return JSException.create(JSErrorType.TypeError, "Cannot load CommonJS module: '" + moduleIdentifier + "'");
    }

    private static JSException fail(String moduleIdentifier, String extraMessage) {
        return JSException.create(JSErrorType.TypeError, "Cannot load CommonJS module: '" + moduleIdentifier + "': " + extraMessage);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException fail(String ... message) {
        StringBuilder sb = new StringBuilder();
        for (String s : message) {
            sb.append(s);
        }
        return JSException.create(JSErrorType.TypeError, sb.toString());
    }

    private static DynamicObject createModuleBuiltin(JSRealm realm, DynamicObject exportsBuiltin, String fileNameBuiltin) {
        DynamicObject module = JSOrdinary.create(realm.getContext(), realm);
        JSObject.set(module, EXPORTS_PROPERTY_NAME, (Object)exportsBuiltin);
        JSObject.set(module, ID_PROPERTY_NAME, (Object)fileNameBuiltin);
        JSObject.set(module, FILENAME_PROPERTY_NAME, (Object)fileNameBuiltin);
        JSObject.set(module, LOADED_PROPERTY_NAME, (Object)false);
        return module;
    }

    private static DynamicObject createRequireBuiltin(JSRealm realm, DynamicObject moduleBuiltin, String fileNameBuiltin) {
        DynamicObject mainRequire = (DynamicObject)realm.getCommonJSRequireFunctionObject();
        DynamicObject mainResolve = (DynamicObject)JSObject.get(mainRequire, (Object)RESOLVE_PROPERTY_NAME);
        JSFunctionData functionData = JSFunction.getFunctionData(mainRequire);
        DynamicObject newRequire = JSFunction.create(realm, functionData);
        JSObject.set(newRequire, MODULE_PROPERTY_NAME, (Object)moduleBuiltin);
        JSObject.set(newRequire, RESOLVE_PROPERTY_NAME, (Object)mainResolve);
        JSObject.set(newRequire, FILENAME_VAR_NAME, (Object)fileNameBuiltin);
        return newRequire;
    }

    private static DynamicObject createExportsBuiltin(JSRealm realm) {
        return JSOrdinary.create(realm.getContext(), realm);
    }

    private static boolean isNodeBinFile(TruffleFile maybeModule) {
        return CommonJSRequireBuiltin.hasExtension(Objects.requireNonNull(maybeModule.getName()), NODE_EXT);
    }

    private static boolean isJsFile(TruffleFile maybeModule) {
        return CommonJSRequireBuiltin.hasExtension(Objects.requireNonNull(maybeModule.getName()), JS_EXT);
    }

    private static boolean isJsonFile(TruffleFile maybeModule) {
        return CommonJSRequireBuiltin.hasExtension(Objects.requireNonNull(maybeModule.getName()), JSON_EXT);
    }

    private static boolean fileExists(TruffleFile modulePath) {
        return modulePath.isRegularFile(new LinkOption[0]);
    }

    private TruffleFile getModuleResolutionEntryPath(DynamicObject currentRequire, TruffleLanguage.Env env) {
        String fileName;
        Object maybeFilename;
        if (JSDynamicObject.isJSDynamicObject(currentRequire) && JSRuntime.isString(maybeFilename = JSObject.get(currentRequire, (Object)FILENAME_VAR_NAME)) && CommonJSRequireBuiltin.isFile(env, fileName = JSRuntime.toStringIsString(maybeFilename))) {
            return CommonJSRequireBuiltin.getParent(env, fileName);
        }
        return CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(this.getContext());
    }

    private static TruffleFile getParent(TruffleLanguage.Env env, String fileName) {
        return env.getPublicTruffleFile(fileName).getParent();
    }

    private static boolean isFile(TruffleLanguage.Env env, String fileName) {
        return env.getPublicTruffleFile(fileName).exists(new LinkOption[0]);
    }

    private static boolean hasExtension(String fileName, String ext) {
        return fileName.lastIndexOf(ext) > 0 && fileName.lastIndexOf(ext) == fileName.length() - ext.length();
    }
}

