/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.DebugScopeNodeGen;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class DebugScopeNode
extends JavaScriptNode
implements ReadNode {
    protected DebugScopeNode() {
    }

    public static DebugScopeNode create() {
        return DebugScopeNodeGen.create();
    }

    @ExplodeLoop
    @Specialization
    protected final Object getScope(VirtualFrame frame, @CachedLibrary(limit="InteropLibraryLimit") NodeLibrary nodeLibrary) {
        Node instrumentableParent;
        block4: {
            instrumentableParent = this.getParent();
            while (instrumentableParent instanceof JavaScriptNode) {
                if (!((JavaScriptNode)instrumentableParent).isInstrumentable()) {
                    instrumentableParent = instrumentableParent.getParent();
                    continue;
                }
                break block4;
            }
            return Undefined.instance;
        }
        try {
            return nodeLibrary.getScope(instrumentableParent, frame, true);
        }
        catch (UnsupportedMessageException e) {
            return Undefined.instance;
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return DebugScopeNode.create();
    }
}

