/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@ImportStatic(value={Kind.class})
public abstract class IsArrayNode
extends JavaScriptBaseNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_JSCLASS_COUNT = 1;
    final Kind kind;

    protected IsArrayNode(Kind kind) {
        this.kind = kind;
    }

    public abstract boolean execute(Object var1);

    @Specialization(guards={"kind == Array", "isJSArray(object)"})
    protected static boolean doJSArray(Object object) {
        return true;
    }

    @Specialization(guards={"cachedShape.check(object)"}, limit="MAX_SHAPE_COUNT")
    protected static boolean doIsArrayShape(JSDynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isArray(object)") boolean cachedResult) {
        return cachedResult;
    }

    @Specialization(replaces={"doIsArrayShape"}, guards={"cachedClass != null", "cachedClass.isInstance(object)"}, limit="MAX_JSCLASS_COUNT")
    protected static boolean doIsArrayJSClass(JSDynamicObject object, @Cached(value="isArray(object)") boolean cachedResult, @Cached(value="getJSClassChecked(object)") JSClass cachedClass) {
        return cachedResult;
    }

    @Specialization(replaces={"doIsArrayJSClass"})
    protected final boolean isArray(JSDynamicObject object) {
        if (this.kind == Kind.FastOrTypedArray) {
            return JSArray.isJSFastArray(object) || JSArgumentsArray.isJSFastArgumentsObject(object) || JSArrayBufferView.isJSArrayBufferView(object);
        }
        if (this.kind == Kind.FastArray) {
            return JSArray.isJSFastArray(object);
        }
        if (this.kind == Kind.Array) {
            return JSArray.isJSArray(object);
        }
        assert (this.kind == Kind.AnyArray);
        return JSObject.hasArray(object);
    }

    @Specialization(guards={"!isJSDynamicObject(object)"})
    protected static boolean isNotDynamicObject(Object object) {
        return false;
    }

    public static IsArrayNode createIsAnyArray() {
        return IsArrayNodeGen.create(Kind.AnyArray);
    }

    public static IsArrayNode createIsArray() {
        return IsArrayNodeGen.create(Kind.Array);
    }

    public static IsArrayNode createIsFastArray() {
        return IsArrayNodeGen.create(Kind.FastArray);
    }

    public static IsArrayNode createIsFastOrTypedArray() {
        return IsArrayNodeGen.create(Kind.FastOrTypedArray);
    }

    public static abstract class IsArrayWrappedNode
    extends JSUnaryNode {
        @Node.Child
        private IsArrayNode isArrayNode;

        protected IsArrayWrappedNode(JavaScriptNode operandNode, IsArrayNode isArrayNode) {
            super(operandNode);
            this.isArrayNode = isArrayNode;
        }

        @Specialization
        protected boolean doObject(Object operand) {
            return this.isArrayNode.execute(operand);
        }

        public static JavaScriptNode createIsArray(JavaScriptNode operand) {
            return IsArrayNodeGen.IsArrayWrappedNodeGen.create(operand, IsArrayNode.createIsArray());
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return IsArrayWrappedNode.createIsArray(IsArrayWrappedNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }

    protected static enum Kind {
        FastOrTypedArray,
        FastArray,
        Array,
        AnyArray;

    }
}

