/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.instrumentation.DeclareTagProvider;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class BlockScopeNode
extends JavaScriptNode
implements ResumableNode,
RepeatingNode {
    @Node.Child
    protected JavaScriptNode block;

    protected BlockScopeNode(JavaScriptNode block) {
        this.block = block;
    }

    public static BlockScopeNode create(FrameDescriptor frameDescriptor, FrameSlot parentSlot, JavaScriptNode block) {
        return new FrameBlockScopeNode(block, frameDescriptor, parentSlot);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            Object object = this.block.execute(this.appendScopeFrame(frame));
            return object;
        }
        finally {
            this.exitScope(frame);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        try {
            this.block.executeVoid(this.appendScopeFrame(frame));
        }
        finally {
            this.exitScope(frame);
        }
    }

    public abstract VirtualFrame appendScopeFrame(VirtualFrame var1);

    public abstract void exitScope(VirtualFrame var1);

    @Override
    public boolean executeRepeating(VirtualFrame frame) {
        try {
            boolean bl = ((RepeatingNode)((Object)this.block)).executeRepeating(this.appendScopeFrame(frame));
            return bl;
        }
        finally {
            this.exitScope(frame);
        }
    }

    public JavaScriptNode getBlock() {
        return this.block;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.block.isResultAlwaysOfType(clazz);
    }

    public static class FrameBlockScopeNode
    extends BlockScopeNode
    implements FrameDescriptorProvider {
        protected final FrameDescriptor frameDescriptor;
        protected final FrameSlot parentSlot;

        protected FrameBlockScopeNode(JavaScriptNode block, FrameDescriptor frameDescriptor, FrameSlot parentSlot) {
            super(block);
            this.frameDescriptor = frameDescriptor;
            this.parentSlot = parentSlot;
        }

        @Override
        public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (materializedTags.contains(JSTags.DeclareTag.class) && !DeclareTagProvider.isMaterializedFrameProvider(this)) {
                JavaScriptNode materialized = DeclareTagProvider.createMaterializedBlockNode(FrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.frameDescriptor, this.parentSlot, this.getSourceSection());
                FrameBlockScopeNode.transferSourceSectionAndTags(this, materialized);
                return materialized;
            }
            return this;
        }

        @Override
        public VirtualFrame appendScopeFrame(VirtualFrame frame) {
            VirtualFrame scopeFrame = Truffle.getRuntime().createVirtualFrame(frame.getArguments(), this.frameDescriptor);
            scopeFrame.setObject(this.parentSlot, frame.materialize());
            return scopeFrame;
        }

        @Override
        public void exitScope(VirtualFrame frame) {
            assert (CompilerDirectives.inCompiledCode() || ScopeFrameNode.isBlockScopeFrame(frame));
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.block.execute(this.appendScopeFrame(frame));
        }

        @Override
        public void executeVoid(VirtualFrame frame) {
            this.block.executeVoid(this.appendScopeFrame(frame));
        }

        @Override
        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        @Override
        public Object resume(VirtualFrame frame) {
            Object savedScopeFrame = this.getStateAndReset(frame);
            MaterializedFrame scopeFrame = savedScopeFrame == Undefined.instance ? this.appendScopeFrame(frame).materialize() : JSFrameUtil.castMaterializedFrame(savedScopeFrame);
            try {
                return this.block.execute(scopeFrame);
            }
            catch (YieldException e) {
                this.setState(frame, scopeFrame);
                throw e;
            }
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new FrameBlockScopeNode(FrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.frameDescriptor, this.parentSlot);
        }
    }
}

