/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.Locale;

public final class JSLocale
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Locale";
    public static final String PROTOTYPE_NAME = "Locale.prototype";
    public static final JSLocale INSTANCE = new JSLocale();

    private JSLocale() {
    }

    public static boolean isJSLocale(Object obj) {
        return obj instanceof JSLocaleObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject localePrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, localePrototype, ctor);
        JSObjectUtil.putToStringTag(localePrototype, "Intl.Locale");
        JSObjectUtil.putFunctionsFromContainer(realm, localePrototype, LocalePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"baseName", JSLocale.createBaseNameGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"calendar", JSLocale.createCalendarGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"caseFirst", JSLocale.createCaseFirstGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"collation", JSLocale.createCollationGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"hourCycle", JSLocale.createHourCycleGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"numeric", JSLocale.createNumericGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"numberingSystem", JSLocale.createNumberingSystemGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"language", JSLocale.createLanguageGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"script", JSLocale.createScriptGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putBuiltinAccessorProperty(localePrototype, (Object)"region", JSLocale.createRegionGetterFunction(realm), Undefined.instance);
        return localePrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getLocaleFactory();
        JSLocaleObject obj = new JSLocaleObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSLocale.isJSLocale(obj));
        return obj;
    }

    static Object emptyStringToUndefined(String s) {
        return s.isEmpty() ? Undefined.instance : s;
    }

    private static DynamicObject createBaseNameGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleBaseName, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.getInternalState((DynamicObject)obj).getBaseName();
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get baseName");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCalendarGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCalendar, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).calendar);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get calendar");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCaseFirstGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCaseFirst, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).caseFirst);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get caseFirst");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCollationGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCollation, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).collation);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get collation");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createHourCycleGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleHourCycle, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).hourCycle);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get hourCycle");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createNumericGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleNumeric, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).numeric);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get numeric");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createNumberingSystemGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleNumberingSystem, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).numberingSystem);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get numberingSystem");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createLanguageGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleLanguage, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getLanguage());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get language");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createScriptGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleScript, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getScript());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get script");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createRegionGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleRegion, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getRegion());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get region");
        });
        return JSFunction.create(realm, getterData);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(InternalState state, Locale locale) {
        state.locale = locale;
        state.calendar = locale.getUnicodeLocaleType("ca");
        state.caseFirst = locale.getUnicodeLocaleType("kf");
        state.collation = locale.getUnicodeLocaleType("co");
        state.hourCycle = locale.getUnicodeLocaleType("hc");
        String kn = locale.getUnicodeLocaleType("kn");
        state.numeric = "true".equals(kn) || "".equals(kn);
        state.numberingSystem = locale.getUnicodeLocaleType("nu");
    }

    public static InternalState getInternalState(DynamicObject localeObject) {
        assert (JSLocale.isJSLocale(localeObject));
        return ((JSLocaleObject)localeObject).getInternalState();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getLocalePrototype();
    }

    public static class InternalState {
        private Locale locale;
        String calendar;
        String caseFirst;
        String collation;
        String hourCycle;
        boolean numeric;
        String numberingSystem;

        @CompilerDirectives.TruffleBoundary
        public String getLocale() {
            return IntlUtil.maybeAppendMissingLanguageSubTag(this.locale.toLanguageTag());
        }

        @CompilerDirectives.TruffleBoundary
        public String getBaseName() {
            return this.locale.stripExtensions().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String getLanguage() {
            return this.locale.getLanguage();
        }

        @CompilerDirectives.TruffleBoundary
        public String getScript() {
            return this.locale.getScript();
        }

        @CompilerDirectives.TruffleBoundary
        public String getRegion() {
            return this.locale.getCountry();
        }

        @CompilerDirectives.TruffleBoundary
        public String maximize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(max.getLanguage());
            builder.setScript(max.getScript());
            builder.setRegion(max.getCountry());
            return builder.build().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String minimize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            ULocale min = ULocale.minimizeSubtags(max);
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(min.getLanguage());
            builder.setScript(min.getScript());
            builder.setRegion(min.getCountry());
            return builder.build().toLanguageTag();
        }
    }
}

