/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.object.TypedLocation;
import com.oracle.truffle.object.LayoutImpl;

public abstract class LocationImpl
extends Location {
    private static final Assumption NEVER_VALID_ASSUMPTION = Truffle.getRuntime().createAssumption("never valid");
    private static final Assumption ALWAYS_VALID_ASSUMPTION;

    protected LocationImpl() {
    }

    @Override
    public void set(DynamicObject store, Object value, Shape shape) throws IncompatibleLocationException, FinalLocationException {
        this.set(store, value, LocationImpl.checkShape(store, shape));
    }

    @Override
    public void set(DynamicObject store, Object value, Shape oldShape, Shape newShape) throws IncompatibleLocationException {
        if (this.canStore(value)) {
            LayoutImpl.ACCESS.growAndSetShape(store, oldShape, newShape);
            try {
                this.setInternal(store, value);
            }
            catch (IncompatibleLocationException ex) {
                throw new IllegalStateException();
            }
        } else {
            throw LocationImpl.incompatibleLocation();
        }
    }

    @Override
    protected final Object getInternal(DynamicObject store) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Object get(DynamicObject var1, boolean var2);

    protected long getLong(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return LocationImpl.expectLong(this.get(store, condition));
    }

    protected int getInt(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return LocationImpl.expectInteger(this.get(store, condition));
    }

    protected double getDouble(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return LocationImpl.expectDouble(this.get(store, condition));
    }

    protected boolean getBoolean(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return LocationImpl.expectBoolean(this.get(store, condition));
    }

    protected void set(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException, FinalLocationException {
        this.setInternal(store, value, condition);
    }

    protected abstract void setInternal(DynamicObject var1, Object var2, boolean var3) throws IncompatibleLocationException;

    protected static final boolean checkShape(DynamicObject store, Shape shape) {
        return store.getShape() == shape;
    }

    @Override
    protected final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
        this.setInternal(store, value, false);
    }

    @Override
    public boolean canSet(DynamicObject store, Object value) {
        return this.canStore(value) && this.canStoreFinal(store, value);
    }

    @Override
    public boolean canSet(Object value) {
        return this.canSet(null, value);
    }

    @Override
    public boolean canStore(Object value) {
        return true;
    }

    protected boolean canStoreFinal(DynamicObject store, Object value) {
        return true;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isFinal() ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public String toString() {
        String finalString = this.isFinal() ? "f" : "";
        String typeString = this instanceof TypedLocation ? ((TypedLocation)((Object)this)).getType().getSimpleName() : "Object";
        return finalString + typeString + this.getWhereString();
    }

    protected String getWhereString() {
        return "";
    }

    public int objectArrayCount() {
        return 0;
    }

    public int objectFieldCount() {
        return 0;
    }

    public int primitiveFieldCount() {
        return 0;
    }

    public int primitiveArrayCount() {
        return 0;
    }

    public abstract void accept(LocationVisitor var1);

    protected LocationImpl getInternalLocation() {
        return this;
    }

    static boolean isSameLocation(LocationImpl loc1, LocationImpl loc2) {
        return loc1 == loc2 || loc1.getInternalLocation().equals(loc2.getInternalLocation());
    }

    protected void setInt(DynamicObject store, int value, boolean condition) throws IncompatibleLocationException, FinalLocationException {
        this.set(store, (Object)value, condition);
    }

    protected void setLong(DynamicObject store, long value, boolean condition) throws IncompatibleLocationException, FinalLocationException {
        this.set(store, (Object)value, condition);
    }

    protected void setDouble(DynamicObject store, double value, boolean condition) throws IncompatibleLocationException, FinalLocationException {
        this.set(store, (Object)value, condition);
    }

    protected boolean isIntLocation() {
        return false;
    }

    protected boolean isLongLocation() {
        return false;
    }

    protected boolean isDoubleLocation() {
        return false;
    }

    protected boolean isImplicitCastIntToLong() {
        return false;
    }

    protected boolean isImplicitCastIntToDouble() {
        return false;
    }

    static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public Class<?> getType() {
        return null;
    }

    @Override
    public Assumption getFinalAssumption() {
        return LocationImpl.neverValidAssumption();
    }

    protected static Assumption neverValidAssumption() {
        return NEVER_VALID_ASSUMPTION;
    }

    protected static Assumption alwaysValidAssumption() {
        return ALWAYS_VALID_ASSUMPTION;
    }

    static {
        NEVER_VALID_ASSUMPTION.invalidate();
        ALWAYS_VALID_ASSUMPTION = Truffle.getRuntime().createAssumption("always valid");
    }

    public static interface LocationVisitor {
        public void visitObjectField(int var1, int var2);

        public void visitObjectArray(int var1, int var2);

        public void visitPrimitiveField(int var1, int var2);

        public void visitPrimitiveArray(int var1, int var2);
    }

    public static interface InternalLongLocation
    extends LongLocation {
        public void setLongInternal(DynamicObject var1, long var2);

        public String getWhereString();
    }
}

