/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.polyglot.ResourceLimitEvent;

final class PolyglotLimits {
    final long statementLimit;
    final Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate;
    final Consumer<ResourceLimitEvent> onEvent;
    static final Object CACHED_CONTEXT = new Object(){

        public String toString() {
            return "$$$cached_context$$$";
        }
    };

    PolyglotLimits(long statementLimit, Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate, Consumer<ResourceLimitEvent> onEvent) {
        this.statementLimit = statementLimit;
        this.statementLimitSourcePredicate = statementLimitSourcePredicate;
        this.onEvent = onEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset(PolyglotContextImpl context) {
        PolyglotContextImpl polyglotContextImpl = context;
        synchronized (polyglotContextImpl) {
            context.statementCounter = context.statementLimit;
            context.volatileStatementCounter.set(context.statementLimit);
        }
    }

    static final class EngineLimits {
        private static final Predicate<org.graalvm.polyglot.Source> NO_PREDICATE = new Predicate<org.graalvm.polyglot.Source>(){

            @Override
            public boolean test(org.graalvm.polyglot.Source t) {
                return true;
            }
        };
        final PolyglotEngineImpl engine;
        @CompilerDirectives.CompilationFinal
        long statementLimit = -1L;
        @CompilerDirectives.CompilationFinal
        Assumption sameStatementLimit;
        @CompilerDirectives.CompilationFinal
        Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate;
        EventBinding<?> statementLimitBinding;

        EngineLimits(PolyglotEngineImpl engine) {
            this.engine = engine;
        }

        void validate(PolyglotLimits limits) {
            if (limits != null && limits.statementLimit != 0L) {
                Predicate<org.graalvm.polyglot.Source> newPredicate = limits.statementLimitSourcePredicate;
                if (newPredicate == null) {
                    newPredicate = NO_PREDICATE;
                }
                if (this.statementLimitSourcePredicate != null && newPredicate != this.statementLimitSourcePredicate) {
                    throw PolyglotEngineException.illegalArgument("Using multiple source predicates per engine is not supported. The same statement limit source predicate must be used for all polyglot contexts that are assigned to the same engine. Resolve this by using the same predicate instance when constructing the limits object with ResourceLimits.Builder.statementLimit(long, Predicate).");
                }
            }
        }

        void initialize(PolyglotLimits limits, final PolyglotContextImpl context) {
            assert (Thread.holdsLock(this.engine.lock));
            if (limits.statementLimit != 0L) {
                Predicate<org.graalvm.polyglot.Source> newPredicate = limits.statementLimitSourcePredicate;
                if (newPredicate == null) {
                    newPredicate = NO_PREDICATE;
                }
                if (this.statementLimitSourcePredicate == null) {
                    this.statementLimitSourcePredicate = newPredicate;
                }
                assert (this.statementLimitSourcePredicate == newPredicate);
                Assumption sameLimit = this.sameStatementLimit;
                if (sameLimit != null && sameLimit.isValid() && limits.statementLimit != this.statementLimit) {
                    sameLimit.invalidate();
                } else if (sameLimit == null) {
                    this.sameStatementLimit = Truffle.getRuntime().createAssumption("Same statement limit.");
                    this.statementLimit = limits.statementLimit;
                }
                if (this.statementLimitBinding == null) {
                    Instrumenter instrumenter = (Instrumenter)EngineAccessor.INSTRUMENT.getEngineInstrumenter(this.engine.instrumentationHandler);
                    SourceSectionFilter.Builder filter = SourceSectionFilter.newBuilder().tagIs(StandardTags.StatementTag.class);
                    if (this.statementLimitSourcePredicate != null) {
                        filter.sourceIs(new SourceSectionFilter.SourcePredicate(){

                            @Override
                            public boolean test(Source s) {
                                try {
                                    return statementLimitSourcePredicate.test(engine.getImpl().getOrCreatePolyglotSource(s));
                                }
                                catch (Throwable e) {
                                    throw PolyglotImpl.hostToGuestException(context, e);
                                }
                            }
                        });
                    }
                    this.statementLimitBinding = instrumenter.attachExecutionEventFactory(filter.build(), new ExecutionEventNodeFactory(){

                        @Override
                        public ExecutionEventNode create(EventContext eventContext) {
                            return new StatementIncrementNode(eventContext, this);
                        }
                    });
                }
            }
            PolyglotLimits.reset(context);
        }

        long getStatementLimit() {
            return this.statementLimit;
        }

        RuntimeException notifyEvent(PolyglotContextImpl context) {
            PolyglotLimits limits = context.config.limits;
            if (limits == null) {
                return null;
            }
            Consumer<ResourceLimitEvent> onEvent = limits.onEvent;
            if (onEvent == null) {
                return null;
            }
            try {
                onEvent.accept(this.engine.getImpl().getAPIAccess().newResourceLimitsEvent(context.creatorApi));
            }
            catch (Throwable t) {
                return PolyglotImpl.hostToGuestException(context, t);
            }
            return null;
        }
    }

    static final class StatementIncrementNode
    extends ExecutionEventNode {
        final EngineLimits limits;
        final EventContext eventContext;
        final PolyglotEngineImpl engine;
        final FrameSlot readContext;
        final ConditionProfile needsLookup = ConditionProfile.create();
        final FrameDescriptor descriptor;
        @CompilerDirectives.CompilationFinal
        private boolean seenInnerContext;

        StatementIncrementNode(EventContext context, EngineLimits limits) {
            this.limits = limits;
            this.eventContext = context;
            this.engine = limits.engine;
            if (!this.engine.singleThreadPerContext.isValid() || !this.engine.singleContext.isValid()) {
                this.descriptor = context.getInstrumentedNode().getRootNode().getFrameDescriptor();
                this.readContext = this.descriptor.findOrAddFrameSlot(CACHED_CONTEXT, FrameSlotKind.Object);
            } else {
                this.readContext = null;
                this.descriptor = null;
            }
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            PolyglotContextImpl currentContext;
            if (this.readContext == null || frame.getFrameDescriptor() != this.descriptor) {
                currentContext = this.getLimitContext();
            } else {
                try {
                    Object readValue = frame.getObject(this.readContext);
                    if (this.needsLookup.profile(readValue == this.descriptor.getDefaultValue())) {
                        currentContext = this.getLimitContext();
                        frame.setObject(this.readContext, currentContext);
                    } else {
                        currentContext = (PolyglotContextImpl)readValue;
                    }
                }
                catch (FrameSlotTypeException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    currentContext = this.getLimitContext();
                    frame.setObject(this.readContext, currentContext);
                }
            }
            long count = this.engine.singleThreadPerContext.isValid() ? --currentContext.statementCounter : currentContext.volatileStatementCounter.decrementAndGet();
            if (count < 0L) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.notifyStatementLimitReached(currentContext, currentContext.statementLimit - count, currentContext.statementLimit);
            }
        }

        private PolyglotContextImpl getLimitContext() {
            PolyglotContextImpl context = PolyglotContextImpl.currentEntered(this.engine);
            if (this.engine.noInnerContexts.isValid() || context.parent == null) {
                return context;
            }
            if (!this.seenInnerContext) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenInnerContext = true;
            }
            while (context.parent != null) {
                context = context.parent;
            }
            return context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyStatementLimitReached(PolyglotContextImpl context, long actualCount, long limit) {
            String message;
            boolean invalidated;
            boolean limitReached = false;
            PolyglotContextImpl polyglotContextImpl = context;
            synchronized (polyglotContextImpl) {
                if (this.limits.engine.singleThreadPerContext.isValid()) {
                    if (context.statementCounter < 0L) {
                        context.statementCounter = limit;
                        limitReached = true;
                    }
                } else if (context.volatileStatementCounter.get() < 0L) {
                    context.volatileStatementCounter.set(limit);
                    limitReached = true;
                }
            }
            if (limitReached && (invalidated = context.invalidate(true, message = String.format("Statement count limit of %s exceeded. Statements executed %s.", limit, actualCount)))) {
                context.close(context.creatorApi, true);
                RuntimeException e = this.limits.notifyEvent(context);
                if (e != null) {
                    throw e;
                }
                throw context.createCancelException(this.eventContext.getInstrumentedNode());
            }
        }
    }
}

