/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexExecNode;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.runtime.nodes.ExpectByteArrayHostObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ToLongNode;
import com.oracle.truffle.regex.util.TruffleNull;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap;
import com.oracle.truffle.regex.util.TruffleSmallReadOnlyStringToIntMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexObject
extends AbstractConstantKeysObject {
    static final String PROP_EXEC = "exec";
    static final String PROP_EXEC_BYTES = "execBytes";
    private static final String PROP_PATTERN = "pattern";
    private static final String PROP_FLAGS = "flags";
    private static final String PROP_GROUP_COUNT = "groupCount";
    private static final String PROP_GROUPS = "groups";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("exec", "pattern", "flags", "groupCount", "groups");
    private final RegexSource source;
    private final AbstractRegexObject flags;
    private final int numberOfCaptureGroups;
    private final AbstractRegexObject namedCaptureGroups;
    private final CallTarget execCallTarget;
    private static final String N_METHODS = "2";

    public RegexObject(RegexExecNode execNode, RegexSource source, AbstractRegexObject flags, int numberOfCaptureGroups, Map<String, Integer> namedCaptureGroups) {
        this.source = source;
        this.flags = flags;
        this.numberOfCaptureGroups = numberOfCaptureGroups;
        this.namedCaptureGroups = namedCaptureGroups != null ? RegexObject.createNamedCaptureGroupMap(namedCaptureGroups) : TruffleNull.INSTANCE;
        this.execCallTarget = Truffle.getRuntime().createCallTarget(new RegexRootNode(execNode.getRegexLanguage(), execNode));
    }

    @CompilerDirectives.TruffleBoundary
    private static AbstractRegexObject createNamedCaptureGroupMap(Map<String, Integer> namedCaptureGroups) {
        if (TruffleSmallReadOnlyStringToIntMap.canCreate(namedCaptureGroups)) {
            return TruffleSmallReadOnlyStringToIntMap.create(namedCaptureGroups);
        }
        return new TruffleReadOnlyMap(namedCaptureGroups);
    }

    public RegexSource getSource() {
        return this.source;
    }

    public TruffleObject getFlags() {
        return this.flags;
    }

    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    public TruffleObject getNamedCaptureGroups() {
        return this.namedCaptureGroups;
    }

    public CallTarget getExecCallTarget() {
        return this.execCallTarget;
    }

    public RegexObjectExecMethod getExecMethod() {
        return new RegexObjectExecMethod(this);
    }

    public RegexObjectExecUTF8Method getExecUTF8Method() {
        return new RegexObjectExecUTF8Method(this);
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "exec": {
                return this.getExecMethod();
            }
            case "execBytes": {
                return this.getExecUTF8Method();
            }
            case "pattern": {
                return this.getSource().getPattern();
            }
            case "flags": {
                return this.getFlags();
            }
            case "groupCount": {
                return this.getNumberOfCaptureGroups();
            }
            case "groups": {
                return this.getNamedCaptureGroups();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create(symbol);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToLongNode toLongNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (args.length != 2) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create(2, args.length);
        }
        Object input = args[0];
        long fromIndex = toLongNode.execute(args[1]);
        if (fromIndex > Integer.MAX_VALUE) {
            return NoMatchResult.getInstance();
        }
        return invokeCache.execute(member, this.getExecCallTarget(), input, (int)fromIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "TRegexObject{source=" + this.source + '}';
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class ExecCompiledRegexNode
    extends Node {
        ExecCompiledRegexNode() {
        }

        abstract Object execute(CallTarget var1, Object var2, int var3) throws UnsupportedMessageException, ArityException, UnsupportedTypeException;

        @Specialization(guards={"receiver == cachedCallTarget"}, limit="4")
        static Object executeDirectCall(CallTarget receiver, Object input, int fromIndex, @Cached(value="receiver") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode directCallNode) {
            return directCallNode.call(input, fromIndex);
        }

        @Specialization(replaces={"executeDirectCall"})
        @ReportPolymorphism.Megamorphic
        static Object executeIndirectCall(CallTarget receiver, Object input, int fromIndex, @Cached IndirectCallNode indirectCallNode) {
            return indirectCallNode.call(receiver, input, fromIndex);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecUTF8Method
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecUTF8Method(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            RegexObject regexObj = this.getRegexObject();
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(2, args.length);
            }
            byte[] input = expectByteArrayHostObjectNode.execute(args[0]);
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return NoMatchResult.getInstance();
            }
            return execNode.execute(regexObj.getExecCallTarget(), input, (int)fromIndex);
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexObjectExecUTF8Method{regex=" + this.regex + '}';
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecMethod
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecMethod(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(2, args.length);
            }
            Object input = expectStringOrTruffleObjectNode.execute(args[0]);
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return NoMatchResult.getInstance();
            }
            return execNode.execute(this.getRegexObject().getExecCallTarget(), input, (int)fromIndex);
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexObjectExecMethod{regex=" + this.regex + '}';
        }
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(String var1, CallTarget var2, Object var3, int var4) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC)"}, limit="2")
        Object execIdentity(String symbol, CallTarget receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC)"}, limit="2", replaces={"execIdentity"})
        Object execEquals(String symbol, CallTarget receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC_BYTES)"}, limit="2")
        Object execBytesIdentity(String symbol, CallTarget receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC_BYTES)"}, limit="2", replaces={"execBytesIdentity"})
        Object execBytesEquals(String symbol, CallTarget receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
        }

        @Specialization(replaces={"execEquals", "execBytesEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(String symbol, CallTarget receiver, Object input, int fromIndex, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            switch (symbol) {
                case "exec": {
                    return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
                }
                case "execBytes": {
                    return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="2")
        static boolean cacheIdentity(RegexObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexObject receiver, String symbol) {
            return RegexObject.PROP_EXEC.equals(symbol) || RegexObject.PROP_EXEC_BYTES.equals(symbol);
        }
    }
}

