/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.Arrays;

public final class TRegexDFAExecutorNode
extends TRegexExecutorNode {
    private static final int IP_TRANSITION_MARKER = 32768;
    public static final int NO_MATCH = -2;
    private final TRegexDFAExecutorProperties props;
    private final int maxNumberOfNFAStates;
    @Node.Children
    private final DFAAbstractStateNode[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DFACaptureGroupLazyTransition[] cgTransitions;
    private final TRegexDFAExecutorDebugRecorder debugRecorder;

    public TRegexDFAExecutorNode(TRegexDFAExecutorProperties props, int maxNumberOfNFAStates, DFAAbstractStateNode[] states, DFACaptureGroupLazyTransition[] cgTransitions, TRegexDFAExecutorDebugRecorder debugRecorder) {
        this.props = props;
        this.maxNumberOfNFAStates = maxNumberOfNFAStates;
        this.states = states;
        this.cgTransitions = cgTransitions;
        this.debugRecorder = debugRecorder;
    }

    public TRegexDFAExecutorNode(TRegexDFAExecutorProperties props, int maxNumberOfNFAStates, DFAAbstractStateNode[] states, DFACaptureGroupLazyTransition[] cgTransitions) {
        this(props, maxNumberOfNFAStates, states, cgTransitions, null);
    }

    private DFAInitialStateNode getInitialState() {
        return (DFAInitialStateNode)this.states[0];
    }

    public int getPrefixLength() {
        return this.getInitialState().getPrefixLength();
    }

    public boolean isAnchored() {
        return !this.getInitialState().hasUnAnchoredEntry();
    }

    @Override
    public boolean isForward() {
        return this.props.isForward();
    }

    public boolean isBackward() {
        return !this.props.isForward();
    }

    public boolean isSearching() {
        return this.props.isSearching();
    }

    public boolean isSimpleCG() {
        return this.props.isSimpleCG();
    }

    public boolean isGenericCG() {
        return this.props.isGenericCG();
    }

    public boolean isRegressionTestMode() {
        return this.props.isRegressionTestMode();
    }

    public DFACaptureGroupLazyTransition[] getCGTransitions() {
        return this.cgTransitions;
    }

    public int getNumberOfStates() {
        return this.states.length;
    }

    public boolean recordExecution() {
        return this.debugRecorder != null;
    }

    public TRegexDFAExecutorDebugRecorder getDebugRecorder() {
        return this.debugRecorder;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexDFAExecutorLocals(input, fromIndex, index, maxIndex, this.createCGData());
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isSimpleCG();
    }

    private DFACaptureGroupTrackingData createCGData() {
        if (this.isGenericCG() || this.isSimpleCG()) {
            return new DFACaptureGroupTrackingData(this.getMaxNumberOfNFAStates(), this.getNumberOfCaptureGroups(), this.props);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        block74: {
            locals = (TRegexDFAExecutorLocals)abstractLocals;
            CompilerDirectives.ensureVirtualized(locals);
            CompilerAsserts.compilationConstant(this.states);
            CompilerAsserts.compilationConstant(this.states.length);
            if (!this.validArgs(locals)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("Got illegal args! (fromIndex %d, initialIndex %d, maxIndex %d)", new Object[]{locals.getFromIndex(), locals.getIndex(), locals.getMaxIndex()}));
            }
            if (this.isGenericCG()) {
                this.initResultOrder(locals);
                locals.setLastTransition((short)-1);
                Arrays.fill(locals.getCGData().results, -1);
            } else if (this.isSimpleCG()) {
                CompilerDirectives.ensureVirtualized(locals.getCGData());
                Arrays.fill(locals.getCGData().results, -1);
            }
            if (this.props.getMinResultLength() > 0 && (this.isForward() != false ? locals.getMaxIndex() - locals.getIndex() : locals.getIndex() - Math.max(0, locals.getFromIndex() - this.getPrefixLength())) < this.props.getMinResultLength()) {
                return this.isGenericCG() != false || this.isSimpleCG() != false ? null : Integer.valueOf(-2);
            }
            if (this.recordExecution()) {
                this.debugRecorder.startRecording(locals);
            }
            if (this.isBackward()) {
                locals.setCurMinIndex(locals.getFromIndex());
            }
            ip = 0;
            block5: while (true) {
                block75: {
                    block77: {
                        block78: {
                            block79: {
                                block76: {
                                    LoopNode.reportLoopCount(this, 1);
                                    if (CompilerDirectives.inInterpreter()) {
                                        RegexRootNode.checkThreadInterrupted();
                                    }
                                    CompilerAsserts.partialEvaluationConstant(ip);
                                    if (ip < 0) break block74;
                                    curState = this.states[ip & 32767];
                                    CompilerAsserts.partialEvaluationConstant(curState);
                                    successors = curState.getSuccessors();
                                    CompilerAsserts.partialEvaluationConstant(successors);
                                    CompilerAsserts.partialEvaluationConstant(successors.length);
                                    if (curState instanceof DFAInitialStateNode) {
                                        if (this.isGenericCG()) {
                                            locals.setLastTransition((short)0);
                                        }
                                        if (this.isSearching()) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                throw new AssertionError();
                                            }
                                            for (i = 0; i < this.getPrefixLength(); ++i) {
                                                if (locals.getIndex() <= 0) {
                                                    this.initNextIndex(locals);
                                                    ip = successors[i];
                                                    continue block5;
                                                }
                                                this.inputSkipIntl(locals, false);
                                            }
                                            this.initNextIndex(locals);
                                            if (this.inputAtBegin(locals)) {
                                                ip = successors[this.getPrefixLength()];
                                                continue;
                                            }
                                            ip = successors[this.getPrefixLength() + successors.length / 2];
                                            continue;
                                        }
                                        this.initNextIndex(locals);
                                        atBegin = this.inputAtBegin(locals);
                                        for (i = 0; i < this.getPrefixLength(); ++i) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                throw new AssertionError();
                                            }
                                            if (locals.getIndex() >= locals.getFromIndex()) {
                                                if (atBegin) {
                                                    ip = successors[i];
                                                    continue block5;
                                                }
                                                ip = successors[i + successors.length / 2];
                                                continue block5;
                                            }
                                            this.inputSkipIntl(locals, true);
                                        }
                                        if (atBegin) {
                                            ip = successors[this.getPrefixLength()];
                                            continue;
                                        }
                                        ip = successors[this.getPrefixLength() + successors.length / 2];
                                        continue;
                                    }
                                    if (!(curState instanceof DFAStateNode)) break block75;
                                    state = (DFAStateNode)curState;
                                    if (ip > 32768) {
                                        i = ip >> 16;
                                        ip = this.execTransition(locals, state, i);
                                        continue;
                                    }
                                    state.getStateReachedProfile().enter();
                                    this.inputAdvance(locals);
                                    state.beforeFindSuccessor(locals, this);
                                    if (this.isForward() && state.canDoIndexOf()) {
                                        indexOfResult = state.loopOptimizationNode.execute(locals.getInput(), locals.getIndex(), this.getMaxIndex(locals));
                                        postLoopIndex = indexOfResult < 0 ? this.getMaxIndex(locals) : indexOfResult;
                                        state.afterIndexOf(locals, this, locals.getIndex(), postLoopIndex);
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != postLoopIndex) {
                                            throw new AssertionError();
                                        }
                                        if (successors.length == 2 && indexOfResult >= 0) {
                                            successor = state.getLoopToSelf() + 1 & 1;
                                            CompilerAsserts.partialEvaluationConstant(successor);
                                            this.inputIncNextIndexRaw(locals, state.loopOptimizationNode.encodedLength());
                                            ip = this.execTransition(locals, state, successor);
                                            continue;
                                        }
                                    }
                                    if (!this.inputHasNext(locals)) {
                                        state.atEnd(locals, this);
                                        if (this.isBackward() && state.hasBackwardPrefixState() && locals.getIndex() > 0) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != locals.getFromIndex()) {
                                                throw new AssertionError();
                                            }
                                            locals.setCurMinIndex(0);
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, ((BackwardDFAStateNode)state).getBackwardPrefixStateIndex());
                                            continue;
                                        }
                                        break block74;
                                    }
                                    if (state.treeTransitionMatching()) {
                                        c = this.inputReadAndDecode(locals);
                                        treeSuccessor = state.getTreeMatcher().checkMatchTree(c);
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && this.isRegressionTestMode() && !state.sameResultAsRegularMatchers(c, treeSuccessor)) {
                                            throw new AssertionError();
                                        }
                                        for (i = 0; i < successors.length; ++i) {
                                            if (i != treeSuccessor) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                        break block74;
                                    }
                                    matchers = state.getMatchers();
                                    if (!(matchers instanceof Matchers.SimpleMatchers)) break block76;
                                    c = this.inputReadAndDecode(locals);
                                    cMatchers = ((Matchers.SimpleMatchers)matchers).getMatchers();
                                    if (cMatchers != null) {
                                        for (i = 0; i < cMatchers.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(cMatchers, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                    break block77;
                                }
                                if (!(matchers instanceof Matchers.UTF8Matchers)) break block78;
                                utf8Matchers = (Matchers.UTF8Matchers)matchers;
                                ascii = utf8Matchers.getAscii();
                                enc2 = utf8Matchers.getEnc2();
                                enc3 = utf8Matchers.getEnc3();
                                enc4 = utf8Matchers.getEnc4();
                                c = this.inputReadRaw(locals);
                                if (!this.getInputProfile().profile(c < 128)) break block79;
                                this.inputIncNextIndexRaw(locals);
                                if (ascii != null) {
                                    for (i = 0; i < ascii.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(ascii, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                                break block77;
                            }
                            codepoint = c & 63;
                            if (this.isBackward()) {
                                if (!TRegexDFAExecutorNode.$assertionsDisabled && c >> 6 != 2) {
                                    throw new AssertionError();
                                }
                                for (i = 1; i < 4; ++i) {
                                    c = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() - i);
                                    if (i >= 3 || c >> 6 != 2) break;
                                    codepoint |= (c & 63) << 6 * i;
                                }
                            }
                            nBytes = Integer.numberOfLeadingZeros(~(c << 24));
                            if (!(TRegexDFAExecutorNode.$assertionsDisabled || 1 < nBytes && nBytes < 5)) {
                                throw new AssertionError(nBytes);
                            }
                            this.inputIncNextIndexRaw(locals, nBytes);
                            if (this.isBackward()) {
                                codepoint |= (c & 255 >>> nBytes) << 6 * (nBytes - 1);
                            }
                            switch (nBytes) {
                                case 2: {
                                    if (enc2 == null) break;
                                    codepoint = this.inputUTF8Decode2(locals, c, codepoint);
                                    for (i = 0; i < enc2.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc2, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block77;
                                }
                                case 3: {
                                    if (enc3 == null) break;
                                    codepoint = this.inputUTF8Decode3(locals, c, codepoint);
                                    for (i = 0; i < enc3.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc3, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block77;
                                }
                                case 4: {
                                    if (enc4 == null) break;
                                    codepoint = this.inputUTF8Decode4(locals, c, codepoint);
                                    for (i = 0; i < enc4.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc4, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break;
                                }
                            }
                            break block77;
                        }
                        if (matchers instanceof Matchers.UTF16RawMatchers) {
                            c = this.inputReadAndDecode(locals);
                            latin1 = ((Matchers.UTF16RawMatchers)matchers).getLatin1();
                            bmp = ((Matchers.UTF16RawMatchers)matchers).getBmp();
                            if (latin1 != null && (bmp == null || compactString || this.getInputProfile().profile(c < 256))) {
                                for (i = 0; i < latin1.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(latin1, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            } else if (bmp != null) {
                                for (i = 0; i < bmp.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            }
                        } else {
                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !(matchers instanceof Matchers.UTF16Matchers)) {
                                throw new AssertionError();
                            }
                            if (!TRegexDFAExecutorNode.$assertionsDisabled && this.getEncoding() != Encodings.UTF_16) {
                                throw new AssertionError();
                            }
                            utf16Matchers = (Matchers.UTF16Matchers)matchers;
                            latin1 = utf16Matchers.getLatin1();
                            bmp = utf16Matchers.getBmp();
                            astral = utf16Matchers.getAstral();
                            c = this.inputReadRaw(locals);
                            this.inputIncNextIndexRaw(locals);
                            if (!compactString && state.utf16MustDecode() && this.inputUTF16IsHighSurrogate(c) && this.inputHasNext((TRegexExecutorLocals)locals, locals.getNextIndex())) {
                                c2 = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getNextIndex());
                                if (this.inputUTF16IsLowSurrogate(c2)) {
                                    locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                                    if (astral != null) {
                                        c = this.inputUTF16ToCodePoint(c, c2);
                                        for (i = 0; i < astral.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(astral, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                    ip = TRegexDFAExecutorNode.transitionNoMatch(state);
                                    continue;
                                }
                            } else if (latin1 != null && (bmp == null || compactString || this.getInputProfile().profile(c < 256))) {
                                for (i = 0; i < latin1.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(latin1, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            }
                            if (bmp != null) {
                                for (i = 0; i < bmp.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            }
                        }
                    }
                    ip = TRegexDFAExecutorNode.transitionNoMatch(state);
                    continue;
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !(curState instanceof DFAFindInnerLiteralStateNode)) {
                    throw new AssertionError();
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                    throw new AssertionError();
                }
                state = (DFAFindInnerLiteralStateNode)curState;
lbl241:
                // 2 sources

                while (this.inputHasNext(locals)) {
                    locals.setIndex(state.executeInnerLiteralSearch(locals, this));
                    if (locals.getIndex() >= 0) {
                        if (state.hasPrefixMatcher() && !state.prefixMatcherMatches(locals, compactString)) break block5;
                        if (!state.hasPrefixMatcher() && this.isSimpleCG()) {
                            locals.getCGData().results[0] = locals.getIndex();
                        }
                        this.inputIncRaw((TRegexExecutorLocals)locals, state.getInnerLiteral().getLiteral().encodedLength());
                        locals.setNextIndex(locals.getIndex());
                        ip = successors[0];
                        continue block5;
                    }
                    break block74;
                }
                break block74;
                break;
            }
            this.inputIncRaw(locals);
            ** GOTO lbl241
        }
        if (this.recordExecution()) {
            this.debugRecorder.finishRecording();
        }
        if (this.isSimpleCG()) {
            result = this.props.isSimpleCGMustCopy() != false ? locals.getCGData().currentResult : locals.getCGData().results;
            return (int[])(locals.getResultInt() == 0 ? result : null);
        }
        if (this.isGenericCG()) {
            return locals.getResultInt() == 0 ? locals.getCGData().currentResult : null;
        }
        return locals.getResultInt();
    }

    private void initNextIndex(TRegexDFAExecutorLocals locals) {
        locals.setNextIndex(locals.getIndex());
        if (this.recordExecution()) {
            this.getDebugRecorder().setInitialIndex(locals.getIndex());
        }
    }

    private static boolean match(CharMatcher[] matchers, int i, int c) {
        return matchers[i] != null && matchers[i].execute(c);
    }

    private static int transitionMatch(DFAStateNode state, int i) {
        return state.getId() | 0x8000 | i << 16;
    }

    private static int transitionNoMatch(DFAStateNode state) {
        return state.getId() | 0x8000 | state.getMatchers().getNoMatchSuccessor() << 16;
    }

    private int execTransition(TRegexDFAExecutorLocals locals, DFAStateNode state, int i) {
        CompilerAsserts.partialEvaluationConstant(state);
        CompilerAsserts.partialEvaluationConstant(i);
        if (this.recordExecution()) {
            this.debugRecorder.recordTransition(locals.getIndex(), state.getId(), i);
        }
        state.successorFound(locals, this, i);
        return state.successors[i];
    }

    private int inputUTF8Decode2(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F;
        }
        return codepoint;
    }

    private int inputUTF8Decode3(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0x1F) << 12 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 2) & 0x3F;
        }
        return codepoint;
    }

    private int inputUTF8Decode4(TRegexDFAExecutorLocals locals, int c, int codepoint) {
        if (this.isForward()) {
            return (c & 0xF) << 18 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 1) & 0x3F) << 12 | (this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 2) & 0x3F) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() + 3) & 0x3F;
        }
        return codepoint;
    }

    @Override
    public int getMinIndex(TRegexExecutorLocals locals) {
        return this.isForward() ? super.getMinIndex(locals) : ((TRegexDFAExecutorLocals)locals).getCurMinIndex();
    }

    private boolean validArgs(TRegexDFAExecutorLocals locals) {
        int initialIndex = locals.getIndex();
        int inputLength = this.getInputLength(locals);
        int fromIndex = locals.getFromIndex();
        int maxIndex = locals.getMaxIndex();
        return inputLength >= 0 && inputLength < 2147483627 && fromIndex >= 0 && fromIndex <= inputLength && initialIndex >= 0 && initialIndex <= maxIndex && maxIndex >= fromIndex && maxIndex <= inputLength;
    }

    @ExplodeLoop
    private void initResultOrder(TRegexDFAExecutorLocals locals) {
        DFACaptureGroupTrackingData cgData = locals.getCGData();
        for (int i = 0; i < this.maxNumberOfNFAStates; ++i) {
            cgData.currentResultOrder[i] = i * this.getNumberOfCaptureGroups() * 2;
        }
    }

    public TRegexDFAExecutorProperties getProperties() {
        return this.props;
    }

    public int getMaxNumberOfNFAStates() {
        return this.maxNumberOfNFAStates;
    }

    public double getCGReorderRatio() {
        if (!this.isGenericCG()) {
            return 0.0;
        }
        int nPT = 0;
        int nReorder = 0;
        for (DFACaptureGroupLazyTransition t : this.cgTransitions) {
            nPT += t.getPartialTransitions().length;
            for (DFACaptureGroupPartialTransition pt : t.getPartialTransitions()) {
                if (!pt.doesReorderResults()) continue;
                ++nReorder;
            }
        }
        if (nPT > 0) {
            return (double)nReorder / (double)nPT;
        }
        return 0.0;
    }

    public double getCGArrayCopyRatio() {
        if (!this.isGenericCG()) {
            return 0.0;
        }
        int nPT = 0;
        int nArrayCopy = 0;
        for (DFACaptureGroupLazyTransition t : this.cgTransitions) {
            nPT += t.getPartialTransitions().length;
            for (DFACaptureGroupPartialTransition pt : t.getPartialTransitions()) {
                nArrayCopy += pt.getArrayCopies().length / 2;
            }
        }
        if (nPT > 0) {
            return (double)nArrayCopy / (double)nPT;
        }
        return 0.0;
    }
}

